/*
 * Decompiled with CFR 0.152.
 */
package com.goide.dataflow;

import com.goide.GoTypes;
import com.goide.intentions.negate.GoBooleanExpressionUtil;
import com.goide.psi.GoBinaryExpr;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoConditionalExpr;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFunctionLit;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoParamDefinition;
import com.goide.psi.GoRangeClause;
import com.goide.psi.GoRecursiveVisitor;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoResolvable;
import com.goide.psi.GoSignatureOwner;
import com.goide.psi.GoTypeOwner;
import com.goide.psi.GoUnaryExpr;
import com.goide.psi.GoVarDefinition;
import com.goide.psi.impl.GoExpressionUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.util.GoStdlibUtil;
import com.goide.util.Value;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoDataFlowUtil {
    @Nullable
    public static GoNamedElement findVarEqNil(@Nullable GoConditionalExpr condition) {
        return condition != null && condition.getEq() != null ? GoDataFlowUtil.findVarComparedToNil(condition) : null;
    }

    @Nullable
    public static GoNamedElement findVarNotEqNil(@Nullable GoConditionalExpr condition) {
        return condition != null && condition.getNotEq() != null ? GoDataFlowUtil.findVarComparedToNil(condition) : null;
    }

    @Nullable
    public static GoNamedElement findVarLenEqZero(@Nullable GoConditionalExpr condition) {
        return condition != null && condition.getEq() != null ? GoDataFlowUtil.findVarWithLenComparedToZero(condition) : null;
    }

    @Nullable
    public static GoNamedElement findVarLenNotEqZero(@Nullable GoConditionalExpr condition) {
        if (condition == null) {
            return null;
        }
        if (condition.getNotEq() != null) {
            return GoDataFlowUtil.findVarWithLenComparedToZero(condition);
        }
        if (condition.getEq() != null) {
            GoNamedElement var = GoDataFlowUtil.findVarWithLenComparedToNonZero(condition.getLeft(), condition.getRight());
            return var != null ? var : GoDataFlowUtil.findVarWithLenComparedToNonZero(condition.getRight(), condition.getLeft());
        }
        if (condition.getGreater() != null) {
            return GoDataFlowUtil.findVarWithLenComparedToZero(condition.getLeft(), condition.getRight());
        }
        if (condition.getGreaterOrEqual() != null) {
            return GoDataFlowUtil.findVarWithLenComparedToNonZero(condition.getLeft(), condition.getRight());
        }
        if (condition.getLess() != null) {
            return GoDataFlowUtil.findVarWithLenComparedToZero(condition.getRight(), condition.getLeft());
        }
        if (condition.getLessOrEqual() != null) {
            return GoDataFlowUtil.findVarWithLenComparedToNonZero(condition.getRight(), condition.getLeft());
        }
        return null;
    }

    @Contract(value="null -> null")
    @Nullable
    public static GoNamedElement findVarDefinition(@Nullable GoExpression expression) {
        GoReferenceExpression ref = (GoReferenceExpression)ObjectUtils.tryCast((Object)expression, GoReferenceExpression.class);
        if (ref == null || ref.getQualifier() != null) {
            return null;
        }
        PsiElement resolve = ref.resolve();
        return resolve instanceof GoVarDefinition || resolve instanceof GoParamDefinition ? (GoNamedElement)resolve : null;
    }

    @Nullable
    private static GoNamedElement findVarComparedToNil(@NotNull GoConditionalExpr conditionalExpr) {
        if (conditionalExpr == null) {
            GoDataFlowUtil.$$$reportNull$$$0(0);
        }
        if (GoExpressionUtil.isNil(conditionalExpr.getLeft())) {
            return GoDataFlowUtil.findVarDefinition(conditionalExpr.getRight());
        }
        if (GoExpressionUtil.isNil(conditionalExpr.getRight())) {
            return GoDataFlowUtil.findVarDefinition(conditionalExpr.getLeft());
        }
        return null;
    }

    @Nullable
    private static GoNamedElement findVarWithLenComparedToZero(@NotNull GoConditionalExpr conditionalExpr) {
        GoNamedElement var;
        if (conditionalExpr == null) {
            GoDataFlowUtil.$$$reportNull$$$0(1);
        }
        return (var = GoDataFlowUtil.findVarWithLenComparedToZero(conditionalExpr.getLeft(), conditionalExpr.getRight())) != null ? var : GoDataFlowUtil.findVarWithLenComparedToZero(conditionalExpr.getRight(), conditionalExpr.getLeft());
    }

    @Nullable
    private static GoNamedElement findVarWithLenComparedToZero(@Nullable GoExpression callExpression, @Nullable GoExpression zeroExpression) {
        Long integerValue = GoDataFlowUtil.getIntegerValue(zeroExpression);
        return integerValue != null && integerValue == 0L ? GoDataFlowUtil.findVarInBuiltinLenCall(callExpression) : null;
    }

    @Nullable
    private static GoNamedElement findVarWithLenComparedToNonZero(@Nullable GoExpression callExpression, @Nullable GoExpression nonZeroExpression) {
        Long integerValue = GoDataFlowUtil.getIntegerValue(nonZeroExpression);
        return integerValue != null && integerValue != 0L ? GoDataFlowUtil.findVarInBuiltinLenCall(callExpression) : null;
    }

    @Nullable
    private static Long getIntegerValue(@Nullable GoExpression zeroExpression) {
        Value value2 = zeroExpression != null ? zeroExpression.getValue() : null;
        return value2 != null ? value2.getInteger() : null;
    }

    @Nullable
    private static GoNamedElement findVarInBuiltinLenCall(@Nullable GoExpression callExpression) {
        GoCallExpr callExpr = (GoCallExpr)ObjectUtils.tryCast((Object)callExpression, GoCallExpr.class);
        if (callExpr == null || !GoPsiUtil.isBuiltinFunctionCall(callExpr, "len")) {
            return null;
        }
        return GoDataFlowUtil.findVarDefinition((GoExpression)ContainerUtil.getFirstItem(callExpr.getArgumentList().getExpressionList()));
    }

    @Nullable
    public static <T extends GoTypeOwner> T findLastErrorInMultiValueAssignment(@NotNull List<T> leftElements, @NotNull List<GoExpression> rightExpressions) {
        if (leftElements == null) {
            GoDataFlowUtil.$$$reportNull$$$0(2);
        }
        if (rightExpressions == null) {
            GoDataFlowUtil.$$$reportNull$$$0(3);
        }
        if (leftElements.size() < 2 || rightExpressions.size() != 1) {
            return null;
        }
        if (rightExpressions.get(0).getParent() instanceof GoRangeClause) {
            return null;
        }
        GoTypeOwner lastElement = (GoTypeOwner)ContainerUtil.getLastItem(leftElements);
        return (T)(lastElement != null && !lastElement.textMatches("_") && GoStdlibUtil.implementsError(lastElement.getGoType(null), lastElement) ? lastElement : null);
    }

    @NotNull
    static ParsedCondition parseAsSingleCondition(@NotNull List<GoExpression> conditions) {
        if (conditions == null) {
            GoDataFlowUtil.$$$reportNull$$$0(4);
        }
        if (conditions.isEmpty()) {
            throw new IllegalArgumentException("Cannot parse empty condition");
        }
        ConditionStructure conditionStructure = new ConditionStructure();
        conditions.forEach(c -> GoDataFlowUtil.extractAtomicConditions(c, conditionStructure));
        if (conditions.size() > 1) {
            conditionStructure.hasOrOperators = true;
        }
        ParsedCondition result = new ParsedCondition(ConditionType.of(conditionStructure));
        for (GoExpression expression : conditionStructure.atomicConditions) {
            GoConditionalExpr conditionalExpr = (GoConditionalExpr)ObjectUtils.tryCast((Object)expression, GoConditionalExpr.class);
            GoNamedElement var = GoDataFlowUtil.findVarEqNil(conditionalExpr);
            if (var != null) {
                result.varsEqNil.add(var);
                continue;
            }
            var = GoDataFlowUtil.findVarNotEqNil(conditionalExpr);
            if (var != null) {
                result.varsNotEqNil.add(var);
                continue;
            }
            var = GoDataFlowUtil.findVarLenEqZero(conditionalExpr);
            if (var != null) {
                result.varsWithZeroLen.add(var);
                continue;
            }
            var = GoDataFlowUtil.findVarLenNotEqZero(conditionalExpr);
            if (var != null) {
                result.varsWithNonZeroLen.add(var);
                continue;
            }
            result.hasSubConditionsWithUnknownMeaning = true;
        }
        ParsedCondition parsedCondition = result;
        if (parsedCondition == null) {
            GoDataFlowUtil.$$$reportNull$$$0(5);
        }
        return parsedCondition;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void extractAtomicConditions(@Nullable GoExpression condition, @NotNull ConditionStructure result) {
        GoExpression unwrapped;
        if (result == null) {
            GoDataFlowUtil.$$$reportNull$$$0(6);
        }
        GoExpression goExpression = unwrapped = condition != null ? condition.unwrapParentheses() : null;
        if (unwrapped instanceof GoBinaryExpr) {
            GoBinaryExpr binaryExpr = (GoBinaryExpr)unwrapped;
            if (GoBooleanExpressionUtil.isLogicalBinaryExpr(unwrapped)) {
                GoDataFlowUtil.extractAtomicConditions(binaryExpr.getLeft(), result);
                IElementType operatorType = GoExpressionUtil.getOperatorType(binaryExpr);
                if (operatorType == GoTypes.COND_AND) {
                    result.hasAndOperators = true;
                } else {
                    result.hasOrOperators = true;
                }
                GoDataFlowUtil.extractAtomicConditions(binaryExpr.getRight(), result);
                return;
            }
        }
        if (unwrapped == null) return;
        result.atomicConditions.add(unwrapped);
    }

    @NotNull
    public static Set<GoNamedElement> findUnpredictableVars(@NotNull GoExpression expression) {
        if (expression == null) {
            GoDataFlowUtil.$$$reportNull$$$0(7);
        }
        if (expression instanceof GoUnaryExpr && ((GoUnaryExpr)expression).getBitAnd() != null) {
            GoExpression operand = ((GoUnaryExpr)expression).getExpression();
            GoExpression unwrapped = operand != null ? operand.unwrapParentheses() : null;
            GoNamedElement varDefinition = GoDataFlowUtil.findVarDefinition(unwrapped);
            Set set = ContainerUtil.createMaybeSingletonSet((Object)varDefinition);
            if (set == null) {
                GoDataFlowUtil.$$$reportNull$$$0(8);
            }
            return set;
        }
        if (expression instanceof GoFunctionLit) {
            final HashSet<GoNamedElement> unpredictable = new HashSet<GoNamedElement>();
            expression.accept(new GoRecursiveVisitor(){

                @Override
                public void visitReferenceExpression(@NotNull GoReferenceExpression ref) {
                    if (ref == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.visitReferenceExpression(ref);
                    GoNamedElement varDefinition = GoDataFlowUtil.findVarDefinition(ref);
                    if (varDefinition == null || unpredictable.contains(varDefinition)) {
                        return;
                    }
                    if (!GoDataFlowUtil.isInSameFunctionBlock(ref, varDefinition)) {
                        unpredictable.add(varDefinition);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/goide/dataflow/GoDataFlowUtil$1", "visitReferenceExpression"));
                }
            });
            HashSet<GoNamedElement> hashSet = unpredictable;
            if (hashSet == null) {
                GoDataFlowUtil.$$$reportNull$$$0(9);
            }
            return hashSet;
        }
        Set<GoNamedElement> set = Collections.emptySet();
        if (set == null) {
            GoDataFlowUtil.$$$reportNull$$$0(10);
        }
        return set;
    }

    public static boolean isInSameFunctionBlock(@NotNull GoResolvable resolvable, @NotNull PsiElement resolve) {
        if (resolvable == null) {
            GoDataFlowUtil.$$$reportNull$$$0(11);
        }
        if (resolve == null) {
            GoDataFlowUtil.$$$reportNull$$$0(12);
        }
        GoSignatureOwner parent1 = (GoSignatureOwner)PsiTreeUtil.getParentOfType((PsiElement)resolvable, (Class[])new Class[]{GoFunctionOrMethodDeclaration.class, GoFunctionLit.class});
        GoSignatureOwner parent2 = (GoSignatureOwner)PsiTreeUtil.getParentOfType((PsiElement)resolve, (Class[])new Class[]{GoFunctionOrMethodDeclaration.class, GoFunctionLit.class});
        return parent1 == parent2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conditionalExpr";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftElements";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightExpressions";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conditions";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/dataflow/GoDataFlowUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvable";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/dataflow/GoDataFlowUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "parseAsSingleCondition";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findUnpredictableVars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findVarComparedToNil";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findVarWithLenComparedToZero";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findLastErrorInMultiValueAssignment";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseAsSingleCondition";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "extractAtomicConditions";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findUnpredictableVars";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isInSameFunctionBlock";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 8, 9, 10 -> new IllegalStateException(string);
        };
    }

    private static class ConditionStructure {
        final List<GoExpression> atomicConditions = new SmartList();
        boolean hasAndOperators;
        boolean hasOrOperators;

        private ConditionStructure() {
        }
    }

    static final class ParsedCondition {
        final ConditionType conditionType;
        final List<GoNamedElement> varsEqNil;
        final List<GoNamedElement> varsNotEqNil;
        final List<GoNamedElement> varsWithZeroLen;
        final List<GoNamedElement> varsWithNonZeroLen;
        boolean hasSubConditionsWithUnknownMeaning;

        private ParsedCondition(@NotNull ConditionType conditionType) {
            if (conditionType == null) {
                ParsedCondition.$$$reportNull$$$0(0);
            }
            this.varsEqNil = new SmartList();
            this.varsNotEqNil = new SmartList();
            this.varsWithZeroLen = new SmartList();
            this.varsWithNonZeroLen = new SmartList();
            this.conditionType = conditionType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conditionType", "com/goide/dataflow/GoDataFlowUtil$ParsedCondition", "<init>"));
        }
    }

    static enum ConditionType {
        ATOMIC,
        AND_CHAIN,
        OR_CHAIN,
        MIXED_CHAIN;


        @NotNull
        private static ConditionType of(@NotNull ConditionStructure conditionStructure) {
            if (conditionStructure == null) {
                ConditionType.$$$reportNull$$$0(0);
            }
            if (conditionStructure.hasOrOperators && conditionStructure.hasAndOperators) {
                ConditionType conditionType = MIXED_CHAIN;
                if (conditionType == null) {
                    ConditionType.$$$reportNull$$$0(1);
                }
                return conditionType;
            }
            if (conditionStructure.hasAndOperators) {
                ConditionType conditionType = AND_CHAIN;
                if (conditionType == null) {
                    ConditionType.$$$reportNull$$$0(2);
                }
                return conditionType;
            }
            if (conditionStructure.hasOrOperators) {
                ConditionType conditionType = OR_CHAIN;
                if (conditionType == null) {
                    ConditionType.$$$reportNull$$$0(3);
                }
                return conditionType;
            }
            ConditionType conditionType = ATOMIC;
            if (conditionType == null) {
                ConditionType.$$$reportNull$$$0(4);
            }
            return conditionType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "conditionStructure";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/dataflow/GoDataFlowUtil$ConditionType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/dataflow/GoDataFlowUtil$ConditionType";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "of";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "of";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

