/*
 * Decompiled with CFR 0.152.
 */
package com.goide.dfa.inspections;

import com.goide.dfa.GoDfaConfig;
import com.goide.dfa.GoDfaConfigGlobal;
import com.goide.dfa.quickfix.GoExcludeResourceProducerQuickFix;
import com.goide.dfa.quickfix.GoExcludeResourceTypeQuickFix;
import com.goide.dfa.symbolicExecution.interpreter.GoDfaResourceLeakAnalysisKt;
import com.goide.dfa.symbolicExecution.interpreter.ResourceLeak;
import com.goide.dfa.symbolicExecution.interpreter.ResourceType;
import com.goide.dfa.translator.GoFunctionPsiToIrTranslator;
import com.goide.execution.testing.GoTestFinder;
import com.goide.i18n.GoBundle;
import com.goide.inspections.GoFunctionDescriptors;
import com.goide.inspections.GoMethodDescriptors;
import com.goide.inspections.core.GoCallableDescriptor;
import com.goide.inspections.core.GoFunctionDescriptor;
import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoInspectionProblemUtil;
import com.goide.inspections.core.GoMethodDescriptor;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoVisitor;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.options.OptTableColumn;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.rml.dfa.ir.ast.IrFunctionDecl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u000e\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u000fJ\u000e\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/goide/dfa/inspections/GoResourceLeakInspection;", "Lcom/goide/inspections/core/GoInspectionBase;", "<init>", "()V", "disableInTests", "", "excludedFunctions", "Lcom/goide/inspections/GoFunctionDescriptors;", "excludedMethods", "Lcom/goide/inspections/GoMethodDescriptors;", "excludedTypes", "", "", "getExcludedFunctions", "", "Lcom/goide/inspections/core/GoCallableDescriptor;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/goide/inspections/core/GoProblemsHolder;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "readSettings", "", "node", "Lorg/jdom/Element;", "readTypes", "writeSettings", "writeTypes", "getOptionsPane", "Lcom/intellij/codeInspection/options/OptPane;", "excludeFunction", "descriptor", "excludeType", "type", "intellij.go.dfa"})
@SourceDebugExtension(value={"SMAP\nGoResourceLeakInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoResourceLeakInspection.kt\ncom/goide/dfa/inspections/GoResourceLeakInspection\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,132:1\n1#2:133\n*E\n"})
public final class GoResourceLeakInspection
extends GoInspectionBase {
    private boolean disableInTests = true;
    @NotNull
    private final GoFunctionDescriptors excludedFunctions = new GoFunctionDescriptors();
    @NotNull
    private final GoMethodDescriptors excludedMethods = new GoMethodDescriptors();
    @NotNull
    private final List<String> excludedTypes = new ArrayList();

    private final List<GoCallableDescriptor> getExcludedFunctions() {
        List<GoFunctionDescriptor> list = this.excludedFunctions.getDescriptors();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getDescriptors(...)");
        Collection collection = list;
        List<GoMethodDescriptor> list2 = this.excludedMethods.getDescriptors();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getDescriptors(...)");
        return CollectionsKt.plus((Collection)collection, (Iterable)list2);
    }

    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(@NotNull GoProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return new GoVisitor(this, holder){
            final /* synthetic */ GoResourceLeakInspection this$0;
            final /* synthetic */ GoProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitFunctionOrMethodDeclaration(GoFunctionOrMethodDeclaration o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                super.visitFunctionOrMethodDeclaration(o);
                PsiFile psiFile = o.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
                GoFile file2 = (GoFile)psiFile;
                if (GoResourceLeakInspection.access$getDisableInTests$p(this.this$0) && GoTestFinder.isTestFile((PsiFile)file2)) {
                    return;
                }
                GoDfaConfigGlobal config = GoDfaConfig.Companion.getGlobal();
                GoFunctionPsiToIrTranslator translator = new GoFunctionPsiToIrTranslator(config, false);
                IrFunctionDecl irFunctionDecl = translator.translateAndPerformTransformStages(o);
                if (irFunctionDecl == null) {
                    return;
                }
                IrFunctionDecl irFunction = irFunctionDecl;
                Set<ResourceLeak> resourceLeaks = GoDfaResourceLeakAnalysisKt.inferResourceLeaks(irFunction, file2, GoResourceLeakInspection.access$getExcludedFunctions(this.this$0), CollectionsKt.toSet((Iterable)GoResourceLeakInspection.access$getExcludedTypes$p(this.this$0)));
                for (ResourceLeak resourceLeak : resourceLeaks) {
                    Object[] objectArray;
                    GoInspectionMessage goInspectionMessage;
                    ResourceType resourceType = resourceLeak.component1();
                    GoCallExpr callExpr = resourceLeak.component2();
                    String funcName = resourceLeak.component3();
                    String typeName = resourceLeak.component4();
                    ResourceType resourceType2 = resourceType;
                    if (Intrinsics.areEqual((Object)resourceType2, (Object)ResourceType.General.INSTANCE)) {
                        goInspectionMessage = GoInspectionProblemUtil.message("go.inspection.potential.resource.leak.general.message");
                    } else if (resourceType2 instanceof ResourceType.Field) {
                        objectArray = new Object[]{((ResourceType.Field)resourceType).getFieldPath()};
                        goInspectionMessage = GoInspectionProblemUtil.message("go.inspection.potential.resource.leak.field.message", objectArray);
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    GoInspectionMessage goInspectionMessage2 = goInspectionMessage;
                    Intrinsics.checkNotNull((Object)goInspectionMessage2);
                    GoInspectionMessage message = goInspectionMessage2;
                    GoExcludeResourceProducerQuickFix excludeFunctionQuckFix = new GoExcludeResourceProducerQuickFix(callExpr, funcName);
                    GoExcludeResourceTypeQuickFix excludeTypeQuckFix = new GoExcludeResourceTypeQuickFix(callExpr, typeName);
                    objectArray = new LocalQuickFix[]{excludeFunctionQuckFix, excludeTypeQuckFix};
                    this.$holder.registerProblem((PsiElement)callExpr, message, (LocalQuickFix[])objectArray);
                }
            }
        };
    }

    public void readSettings(@NotNull Element node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        Element element = node2.getChild("disableInTests");
        if (element != null) {
            Element it = element;
            boolean bl = false;
            this.disableInTests = Boolean.parseBoolean(it.getText());
        }
        GoFunctionDescriptors.readList(node2, this.excludedFunctions);
        GoMethodDescriptors.readList(node2, this.excludedMethods);
        this.readTypes(node2);
    }

    private final void readTypes(Element node2) {
        Element element = node2.getChild("types");
        if (element == null) {
            return;
        }
        Element items = element;
        this.excludedTypes.clear();
        for (Element item : items.getChildren("type")) {
            this.excludedTypes.add(item.getAttributeValue("name"));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void writeSettings(@NotNull Element node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        if (!this.disableInTests) {
            void it;
            Element element;
            Element element2 = element = new Element("disableInTests");
            Element element3 = node2;
            boolean bl = false;
            it.setText("false");
            element3.addContent(element);
        }
        this.excludedFunctions.writeList(node2);
        this.excludedMethods.writeList(node2, new GoMethodDescriptors());
        this.writeTypes(node2);
    }

    /*
     * WARNING - void declaration
     */
    private final void writeTypes(Element node2) {
        Element element;
        if (this.excludedTypes.isEmpty()) {
            return;
        }
        Element element2 = element = new Element("types");
        Element element3 = node2;
        boolean bl = false;
        Iterator<String> iterator = this.excludedTypes.iterator();
        while (iterator.hasNext()) {
            String type;
            void it;
            void element4;
            Element element5;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            Element element6 = element5 = new Element("type");
            void var9_10 = element4;
            boolean bl2 = false;
            it.setAttribute("name", type);
            var9_10.addContent(element5);
        }
        element3.addContent(element);
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptRegularComponent[] optRegularComponentArray = new OptRegularComponent[5];
        optRegularComponentArray[0] = OptPane.checkbox((String)"disableInTests", (String)GoBundle.message((String)"go.inspection.dfa.potential.resource.leak.settings.disable.in.tests.checkbox", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]);
        optRegularComponentArray[1] = OptPane.separator();
        optRegularComponentArray[2] = this.excludedFunctions.getTable(GoBundle.message((String)"go.inspection.dfa.potential.resource.leak.settings.excluded.functions.label", (Object[])new Object[0])).prefix("excludedFunctions");
        optRegularComponentArray[3] = this.excludedMethods.getTable(GoBundle.message((String)"go.inspection.dfa.potential.resource.leak.settings.excluded.methods.label", (Object[])new Object[0])).prefix("excludedMethods");
        OptTableColumn[] optTableColumnArray = new OptTableColumn[]{OptPane.column((String)"excludedTypes", (String)GoBundle.message((String)"go.inspection.dfa.potential.resource.leak.settings.excluded.type.name", (Object[])new Object[0]))};
        optRegularComponentArray[4] = OptPane.table((String)GoBundle.message((String)"go.inspection.dfa.potential.resource.leak.settings.excluded.types.label", (Object[])new Object[0]), (OptTableColumn[])optTableColumnArray);
        OptPane optPane = OptPane.pane((OptRegularComponent[])optRegularComponentArray);
        Intrinsics.checkNotNullExpressionValue((Object)optPane, (String)"pane(...)");
        return optPane;
    }

    public final void excludeFunction(@NotNull GoCallableDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        GoCallableDescriptor goCallableDescriptor = descriptor;
        if (goCallableDescriptor instanceof GoFunctionDescriptor) {
            this.excludedFunctions.add(((GoFunctionDescriptor)descriptor).getImportPath(), ((GoFunctionDescriptor)descriptor).getName());
        } else if (goCallableDescriptor instanceof GoMethodDescriptor) {
            this.excludedMethods.add(((GoMethodDescriptor)descriptor).getImportPath(), ((GoMethodDescriptor)descriptor).getReceiver(), ((GoMethodDescriptor)descriptor).getName());
        }
    }

    public final void excludeType(@NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.excludedTypes.add(type);
    }

    public static final /* synthetic */ boolean access$getDisableInTests$p(GoResourceLeakInspection $this) {
        return $this.disableInTests;
    }

    public static final /* synthetic */ List access$getExcludedFunctions(GoResourceLeakInspection $this) {
        return $this.getExcludedFunctions();
    }

    public static final /* synthetic */ List access$getExcludedTypes$p(GoResourceLeakInspection $this) {
        return $this.excludedTypes;
    }
}

