/*
 * Decompiled with CFR 0.152.
 */
package com.goide.dfa.symbolicExecution.interpreter;

import com.goide.dfa.translator.GoDfaUtilsKt;
import com.goide.inspections.core.GoCallableDescriptor;
import com.goide.inspections.core.GoFunctionDescriptor;
import com.goide.psi.GoCompositeElement;
import com.goide.psi.GoFile;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoMethodSpec;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoNamedSignatureOwner;
import com.goide.psi.GoParameters;
import com.goide.psi.GoReceiver;
import com.goide.psi.GoSignature;
import com.goide.psi.GoSignatureOwner;
import com.goide.psi.GoType;
import com.goide.psi.impl.GoTypeUtil;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\f\u0010\u0006\u001a\u00020\u0001*\u00020\u0007H\u0000\u001a\f\u0010\u000b\u001a\u00020\u0001*\u00020\u0007H\u0000\u001a\f\u0010\r\u001a\u00020\u0001*\u00020\u0007H\u0000\u001a\f\u0010\u000f\u001a\u00020\u0001*\u00020\u0007H\u0000\u001a\f\u0010\u0011\u001a\u00020\u0001*\u00020\u0007H\u0000\u001a\f\u0010\u0012\u001a\u00020\u0001*\u00020\u0007H\u0000\u001a\f\u0010\u0015\u001a\u00020\u0001*\u00020\u0007H\u0000\u001a\f\u0010\u0018\u001a\u00020\u0001*\u00020\u0017H\u0000\u001a\u000e\u0010\u001a\u001a\u00020\u0001*\u0004\u0018\u00010\nH\u0000\u001a\f\u0010\u001b\u001a\u00020\u0001*\u00020\u0007H\u0000\"\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"implementsClose", "", "type", "Lcom/goide/psi/GoType;", "file", "Lcom/goide/psi/GoFile;", "isCloseFunction", "Lcom/goide/psi/GoNamedSignatureOwner;", "CLOSE_FUNCTION_NAMES", "", "", "isPotentialCloseFunction", "CONSTRUCTOR_PREFIXES", "isPotentialConstructor", "APPEND_PREFIXES", "isPotentialAppendFunction", "SET_PREFIXES", "isPotentialSetter", "isPotentialGetter", "INCLUDED_METHODS_BY_TYPE", "", "isResourceProducingMethod", "EXCLUDED_RESOURCE_PRODUCERS", "Lcom/goide/inspections/core/GoCallableDescriptor;", "isExcludedResourceProducer", "ESCAPING_RESOURCE_TYPES", "isEscapingResourceType", "isPotentialErrorChecker", "intellij.go.dfa"})
@SourceDebugExtension(value={"SMAP\nGoResourcePatterns.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoResourcePatterns.kt\ncom/goide/dfa/symbolicExecution/interpreter/GoResourcePatternsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,95:1\n1761#2,3:96\n1761#2,3:99\n1761#2,3:102\n1761#2,3:105\n1761#2,3:108\n*S KotlinDebug\n*F\n+ 1 GoResourcePatterns.kt\ncom/goide/dfa/symbolicExecution/interpreter/GoResourcePatternsKt\n*L\n16#1:96,3\n29#1:99,3\n36#1:102,3\n43#1:105,3\n50#1:108,3\n*E\n"})
public final class GoResourcePatternsKt {
    @NotNull
    private static final List<String> CLOSE_FUNCTION_NAMES;
    @NotNull
    private static final List<String> CONSTRUCTOR_PREFIXES;
    @NotNull
    private static final List<String> APPEND_PREFIXES;
    @NotNull
    private static final List<String> SET_PREFIXES;
    @NotNull
    private static final Set<String> INCLUDED_METHODS_BY_TYPE;
    @NotNull
    private static final Set<GoCallableDescriptor> EXCLUDED_RESOURCE_PRODUCERS;
    @NotNull
    private static final Set<String> ESCAPING_RESOURCE_TYPES;

    public static final boolean implementsClose(@NotNull GoType type, @NotNull GoFile file2) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)((Object)file2), (String)"file");
            List<? extends GoNamedSignatureOwner> methods = GoTypeUtil.getMethodSet(type, (PsiElement)file2);
            Intrinsics.checkNotNull(methods);
            Iterable $this$any$iv = methods;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GoNamedSignatureOwner it = (GoNamedSignatureOwner)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!GoResourcePatternsKt.isCloseFunction(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isCloseFunction(@NotNull GoNamedSignatureOwner $this$isCloseFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$isCloseFunction, (String)"<this>");
        if (!($this$isCloseFunction instanceof GoMethodDeclaration)) {
            if (!($this$isCloseFunction instanceof GoMethodSpec)) return false;
        }
        if (!Intrinsics.areEqual((Object)((GoNamedElement)$this$isCloseFunction).getName(), (Object)"Close")) return false;
        GoSignature goSignature = ((GoSignatureOwner)$this$isCloseFunction).getSignature();
        GoCompositeElement goCompositeElement = goSignature;
        if (goSignature == null) return false;
        GoParameters goParameters = goCompositeElement.getParameters();
        goCompositeElement = goParameters;
        if (goParameters == null) return false;
        if (goCompositeElement.getParameterCount() != 0) return false;
        boolean bl = true;
        if (!bl) return false;
        GoCompositeElement goCompositeElement2 = ((GoSignatureOwner)$this$isCloseFunction).getSignature();
        if (!GoTypeUtil.isError(goCompositeElement2 != null && (goCompositeElement2 = goCompositeElement2.getResult()) != null ? goCompositeElement2.getType() : null, $this$isCloseFunction)) return false;
        return true;
    }

    public static final boolean isPotentialCloseFunction(@NotNull GoNamedSignatureOwner $this$isPotentialCloseFunction) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)$this$isPotentialCloseFunction, (String)"<this>");
            String string = $this$isPotentialCloseFunction.getName();
            if (string == null) {
                return false;
            }
            String n = string;
            Iterable $this$any$iv = CLOSE_FUNCTION_NAMES;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String name = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.contains((CharSequence)n, (CharSequence)name, (boolean)true)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean isPotentialConstructor(@NotNull GoNamedSignatureOwner $this$isPotentialConstructor) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)$this$isPotentialConstructor, (String)"<this>");
            String string = $this$isPotentialConstructor.getName();
            if (string == null) {
                return false;
            }
            String n = string;
            Iterable $this$any$iv = CONSTRUCTOR_PREFIXES;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String prefix = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith((String)n, (String)prefix, (boolean)true)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean isPotentialAppendFunction(@NotNull GoNamedSignatureOwner $this$isPotentialAppendFunction) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)$this$isPotentialAppendFunction, (String)"<this>");
            String string = $this$isPotentialAppendFunction.getName();
            if (string == null) {
                return false;
            }
            String n = string;
            Iterable $this$any$iv = APPEND_PREFIXES;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String prefix = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith((String)n, (String)prefix, (boolean)true)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean isPotentialSetter(@NotNull GoNamedSignatureOwner $this$isPotentialSetter) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)$this$isPotentialSetter, (String)"<this>");
            String string = $this$isPotentialSetter.getName();
            if (string == null) {
                return false;
            }
            String n = string;
            Iterable $this$any$iv = SET_PREFIXES;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String prefix = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith((String)n, (String)prefix, (boolean)true)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean isPotentialGetter(@NotNull GoNamedSignatureOwner $this$isPotentialGetter) {
        Intrinsics.checkNotNullParameter((Object)$this$isPotentialGetter, (String)"<this>");
        String string = $this$isPotentialGetter.getName();
        return string != null ? StringsKt.startsWith((String)string, (String)"get", (boolean)true) : false;
    }

    public static final boolean isResourceProducingMethod(@NotNull GoNamedSignatureOwner $this$isResourceProducingMethod) {
        Intrinsics.checkNotNullParameter((Object)$this$isResourceProducingMethod, (String)"<this>");
        if (!($this$isResourceProducingMethod instanceof GoMethodDeclaration)) {
            return false;
        }
        GoReceiver goReceiver = ((GoMethodDeclaration)$this$isResourceProducingMethod).getReceiver();
        return CollectionsKt.contains((Iterable)INCLUDED_METHODS_BY_TYPE, (Object)GoDfaUtilsKt.getTypeName(goReceiver != null ? goReceiver.getType() : null));
    }

    public static final boolean isExcludedResourceProducer(@NotNull GoCallableDescriptor $this$isExcludedResourceProducer) {
        Intrinsics.checkNotNullParameter((Object)$this$isExcludedResourceProducer, (String)"<this>");
        return EXCLUDED_RESOURCE_PRODUCERS.contains($this$isExcludedResourceProducer);
    }

    public static final boolean isEscapingResourceType(@Nullable String $this$isEscapingResourceType) {
        if ($this$isEscapingResourceType == null) {
            return false;
        }
        return StringsKt.endsWith((String)$this$isEscapingResourceType, (String)"closer", (boolean)true) || ESCAPING_RESOURCE_TYPES.contains($this$isEscapingResourceType);
    }

    public static final boolean isPotentialErrorChecker(@NotNull GoNamedSignatureOwner $this$isPotentialErrorChecker) {
        Intrinsics.checkNotNullParameter((Object)$this$isPotentialErrorChecker, (String)"<this>");
        GoCompositeElement goCompositeElement = $this$isPotentialErrorChecker.getSignature();
        return Intrinsics.areEqual(goCompositeElement != null && (goCompositeElement = goCompositeElement.getResult()) != null && (goCompositeElement = goCompositeElement.getType()) != null ? GoDfaUtilsKt.getTypeName((GoType)goCompositeElement) : null, (Object)"builtin.bool");
    }

    static {
        Object[] objectArray = new String[]{"close", "cleanup", "teardown", "shutdown", "destroy", "release"};
        CLOSE_FUNCTION_NAMES = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"new", "mustnew", "create"};
        CONSTRUCTOR_PREFIXES = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"append", "add", "push", "insert", "put"};
        APPEND_PREFIXES = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"set", "with"};
        SET_PREFIXES = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"sql.DB", "sql.Conn", "sql.Tx", "sql.Stmt", "http.Client"};
        INCLUDED_METHODS_BY_TYPE = SetsKt.setOf((Object[])objectArray);
        objectArray = new GoFunctionDescriptor[]{GoFunctionDescriptor.of("io.NopCloser"), GoFunctionDescriptor.of("io.Pipe"), GoFunctionDescriptor.of("debug/elf.NewFile"), GoFunctionDescriptor.of("debug/macho.NewFile"), GoFunctionDescriptor.of("debug/macho.NewFatFile"), GoFunctionDescriptor.of("debug/pe.NewFile"), GoFunctionDescriptor.of("debug/plan9obj.NewFile")};
        EXCLUDED_RESOURCE_PRODUCERS = SetsKt.setOf((Object[])objectArray);
        ESCAPING_RESOURCE_TYPES = SetsKt.setOf((Object)"net.Listener");
    }
}

