/*
 * Decompiled with CFR 0.152.
 */
package com.goide.dfa.symbolicExecution.interpreter;

import com.goide.dfa.symbolicExecution.interpreter.SymbolicValue;
import com.goide.dfa.symbolicExecution.interpreter.SymbolicValues;
import com.intellij.openapi.util.TextRange;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0005\u0004\u0005\u0006\u0007\bB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0004\t\n\u000b\f\u00a8\u0006\r"}, d2={"Lcom/goide/dfa/symbolicExecution/interpreter/SymbolicExpression;", "Lcom/goide/dfa/symbolicExecution/interpreter/SymbolicValue;", "<init>", "()V", "Parameter", "FieldAccess", "CallExpr", "CallReturnValue", "Unknown", "Lcom/goide/dfa/symbolicExecution/interpreter/SymbolicExpression$CallReturnValue;", "Lcom/goide/dfa/symbolicExecution/interpreter/SymbolicExpression$FieldAccess;", "Lcom/goide/dfa/symbolicExecution/interpreter/SymbolicExpression$Parameter;", "Lcom/goide/dfa/symbolicExecution/interpreter/SymbolicExpression$Unknown;", "intellij.go.dfa"})
public abstract sealed class SymbolicExpression
extends SymbolicValue {
    private SymbolicExpression() {
        super(null);
    }

    public /* synthetic */ SymbolicExpression(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0017\u001a\u00020\u000bH\u0016J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001b\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001c"}, d2={"Lcom/goide/dfa/symbolicExecution/interpreter/SymbolicExpression$CallExpr;", "", "range", "Lcom/intellij/openapi/util/TextRange;", "iteration", "", "args", "", "Lcom/goide/dfa/symbolicExecution/interpreter/SymbolicValues;", "returnArity", "prettyName", "", "<init>", "(Lcom/intellij/openapi/util/TextRange;ILjava/util/List;ILjava/lang/String;)V", "getRange", "()Lcom/intellij/openapi/util/TextRange;", "getIteration", "()I", "getArgs", "()Ljava/util/List;", "getReturnArity", "getPrettyName", "()Ljava/lang/String;", "toString", "equals", "", "other", "hashCode", "intellij.go.dfa"})
    public static final class CallExpr {
        @NotNull
        private final TextRange range;
        private final int iteration;
        @NotNull
        private final List<SymbolicValues> args;
        private final int returnArity;
        @Nullable
        private final String prettyName;

        public CallExpr(@NotNull TextRange range, int iteration, @NotNull List<SymbolicValues> args, int returnArity, @Nullable String prettyName) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter(args, (String)"args");
            this.range = range;
            this.iteration = iteration;
            this.args = args;
            this.returnArity = returnArity;
            this.prettyName = prettyName;
        }

        @NotNull
        public final TextRange getRange() {
            return this.range;
        }

        public final int getIteration() {
            return this.iteration;
        }

        @NotNull
        public final List<SymbolicValues> getArgs() {
            return this.args;
        }

        public final int getReturnArity() {
            return this.returnArity;
        }

        @Nullable
        public final String getPrettyName() {
            return this.prettyName;
        }

        @NotNull
        public String toString() {
            String string = this.prettyName;
            if (string == null) {
                String string2 = this.range.toString();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            }
            String name = string;
            String suffix = this.iteration == 0 ? "" : "_" + this.iteration;
            return name + suffix + "(" + CollectionsKt.joinToString$default((Iterable)this.args, null, null, null, (int)0, null, null, (int)63, null) + ")";
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CallExpr)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.range, (Object)((CallExpr)other).range) && this.iteration == ((CallExpr)other).iteration;
        }

        public int hashCode() {
            return this.range.hashCode() + 31 * Integer.hashCode(this.iteration);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\u0006\u0010\u000e\u001a\u00020\u000fJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u000f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/goide/dfa/symbolicExecution/interpreter/SymbolicExpression$CallReturnValue;", "Lcom/goide/dfa/symbolicExecution/interpreter/SymbolicExpression;", "idx", "", "call", "Lcom/goide/dfa/symbolicExecution/interpreter/SymbolicExpression$CallExpr;", "<init>", "(ILcom/goide/dfa/symbolicExecution/interpreter/SymbolicExpression$CallExpr;)V", "getIdx", "()I", "getCall", "()Lcom/goide/dfa/symbolicExecution/interpreter/SymbolicExpression$CallExpr;", "toString", "", "isErrorLikeValue", "", "component1", "component2", "copy", "equals", "other", "", "hashCode", "intellij.go.dfa"})
    public static final class CallReturnValue
    extends SymbolicExpression {
        private final int idx;
        @NotNull
        private final CallExpr call;

        public CallReturnValue(int idx, @NotNull CallExpr call) {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            super(null);
            this.idx = idx;
            this.call = call;
        }

        public final int getIdx() {
            return this.idx;
        }

        @NotNull
        public final CallExpr getCall() {
            return this.call;
        }

        @NotNull
        public String toString() {
            return this.call.getReturnArity() == 1 ? "<" + this.call + ">" : "<" + this.call + ">[" + this.idx + "]";
        }

        public final boolean isErrorLikeValue() {
            return this.call.getReturnArity() > 1 && this.idx == this.call.getReturnArity() - 1;
        }

        public final int component1() {
            return this.idx;
        }

        @NotNull
        public final CallExpr component2() {
            return this.call;
        }

        @NotNull
        public final CallReturnValue copy(int idx, @NotNull CallExpr call) {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            return new CallReturnValue(idx, call);
        }

        public static /* synthetic */ CallReturnValue copy$default(CallReturnValue callReturnValue, int n, CallExpr callExpr, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = callReturnValue.idx;
            }
            if ((n2 & 2) != 0) {
                callExpr = callReturnValue.call;
            }
            return callReturnValue.copy(n, callExpr);
        }

        public int hashCode() {
            int result = Integer.hashCode(this.idx);
            result = result * 31 + this.call.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CallReturnValue)) {
                return false;
            }
            CallReturnValue callReturnValue = (CallReturnValue)other;
            if (this.idx != callReturnValue.idx) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.call, (Object)callReturnValue.call);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000b\u001a\u00020\u0004H\u0016J\t\u0010\f\u001a\u00020\u0001H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0004H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00012\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/goide/dfa/symbolicExecution/interpreter/SymbolicExpression$FieldAccess;", "Lcom/goide/dfa/symbolicExecution/interpreter/SymbolicExpression;", "expr", "field", "", "<init>", "(Lcom/goide/dfa/symbolicExecution/interpreter/SymbolicExpression;Ljava/lang/String;)V", "getExpr", "()Lcom/goide/dfa/symbolicExecution/interpreter/SymbolicExpression;", "getField", "()Ljava/lang/String;", "toString", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "intellij.go.dfa"})
    public static final class FieldAccess
    extends SymbolicExpression {
        @NotNull
        private final SymbolicExpression expr;
        @NotNull
        private final String field;

        public FieldAccess(@NotNull SymbolicExpression expr, @NotNull String field) {
            Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            super(null);
            this.expr = expr;
            this.field = field;
        }

        @NotNull
        public final SymbolicExpression getExpr() {
            return this.expr;
        }

        @NotNull
        public final String getField() {
            return this.field;
        }

        @NotNull
        public String toString() {
            return this.expr + "." + this.field;
        }

        @NotNull
        public final SymbolicExpression component1() {
            return this.expr;
        }

        @NotNull
        public final String component2() {
            return this.field;
        }

        @NotNull
        public final FieldAccess copy(@NotNull SymbolicExpression expr, @NotNull String field) {
            Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            return new FieldAccess(expr, field);
        }

        public static /* synthetic */ FieldAccess copy$default(FieldAccess fieldAccess, SymbolicExpression symbolicExpression, String string, int n, Object object) {
            if ((n & 1) != 0) {
                symbolicExpression = fieldAccess.expr;
            }
            if ((n & 2) != 0) {
                string = fieldAccess.field;
            }
            return fieldAccess.copy(symbolicExpression, string);
        }

        public int hashCode() {
            int result = this.expr.hashCode();
            result = result * 31 + this.field.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FieldAccess)) {
                return false;
            }
            FieldAccess fieldAccess = (FieldAccess)other;
            if (!Intrinsics.areEqual((Object)this.expr, (Object)fieldAccess.expr)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.field, (Object)fieldAccess.field);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\u0005H\u0016J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lcom/goide/dfa/symbolicExecution/interpreter/SymbolicExpression$Parameter;", "Lcom/goide/dfa/symbolicExecution/interpreter/SymbolicExpression;", "idx", "", "prettyName", "", "<init>", "(ILjava/lang/String;)V", "getIdx", "()I", "getPrettyName", "()Ljava/lang/String;", "toString", "equals", "", "other", "", "hashCode", "intellij.go.dfa"})
    public static final class Parameter
    extends SymbolicExpression {
        private final int idx;
        @Nullable
        private final String prettyName;

        public Parameter(int idx, @Nullable String prettyName) {
            super(null);
            this.idx = idx;
            this.prettyName = prettyName;
        }

        public /* synthetic */ Parameter(int n, String string, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                string = null;
            }
            this(n, string);
        }

        public final int getIdx() {
            return this.idx;
        }

        @Nullable
        public final String getPrettyName() {
            return this.prettyName;
        }

        @NotNull
        public String toString() {
            return "<" + this.prettyName + ">";
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Parameter)) {
                return false;
            }
            return this.idx == ((Parameter)other).idx;
        }

        public int hashCode() {
            return Integer.hashCode(this.idx);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/goide/dfa/symbolicExecution/interpreter/SymbolicExpression$Unknown;", "Lcom/goide/dfa/symbolicExecution/interpreter/SymbolicExpression;", "origin", "", "<init>", "(Ljava/lang/String;)V", "toString", "intellij.go.dfa"})
    public static final class Unknown
    extends SymbolicExpression {
        @NotNull
        private final String origin;

        public Unknown(@NotNull String origin) {
            Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
            super(null);
            this.origin = origin;
        }

        @NotNull
        public String toString() {
            return "unknown(" + this.origin + ")";
        }
    }
}

