/*
 * Decompiled with CFR 0.152.
 */
package com.goide.dfa.symbolicExecution.interpreter;

import com.goide.dfa.symbolicExecution.common.UtilsKt;
import com.goide.dfa.symbolicExecution.interpreter.ResourceState;
import com.goide.dfa.symbolicExecution.interpreter.SymbolicResourceHandler;
import com.goide.dfa.symbolicExecution.interpreter.SymbolicValue;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u00002\u00020\u0001B)\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007\u00a2\u0006\u0004\b\b\u0010\tB\t\b\u0016\u00a2\u0006\u0004\b\b\u0010\nJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0005J \u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u00102\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00160\u0015J\u000e\u0010\u0019\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004J\u000e\u0010\u001a\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004J\u0006\u0010\u001b\u001a\u00020\fJ\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0000J\u0006\u0010\u001e\u001a\u00020\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lcom/goide/dfa/symbolicExecution/interpreter/SymbolicResourceHandler;", "", "resources", "", "Lcom/goide/dfa/symbolicExecution/interpreter/SymbolicValue;", "Lcom/goide/dfa/symbolicExecution/interpreter/ResourceState;", "resourceLeaks", "", "<init>", "(Ljava/util/Map;Ljava/util/Set;)V", "()V", "setResourceState", "", "resource", "state", "allResources", "", "getAllResources", "()Ljava/util/Set;", "findResources", "predicate", "Lkotlin/Function1;", "", "allLeaks", "getAllLeaks", "markLeak", "removeLeak", "clearResourceLeaks", "merge", "other", "copy", "intellij.go.dfa"})
@SourceDebugExtension(value={"SMAP\nGoDfaSymbolicResourceHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoDfaSymbolicResourceHandler.kt\ncom/goide/dfa/symbolicExecution/interpreter/SymbolicResourceHandler\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,63:1\n536#2:64\n521#2,6:65\n*S KotlinDebug\n*F\n+ 1 GoDfaSymbolicResourceHandler.kt\ncom/goide/dfa/symbolicExecution/interpreter/SymbolicResourceHandler\n*L\n35#1:64\n35#1:65,6\n*E\n"})
public final class SymbolicResourceHandler {
    @NotNull
    private final Map<SymbolicValue, ResourceState> resources;
    @NotNull
    private final Set<SymbolicValue> resourceLeaks;

    public SymbolicResourceHandler(@NotNull Map<SymbolicValue, ResourceState> resources, @NotNull Set<SymbolicValue> resourceLeaks) {
        Intrinsics.checkNotNullParameter(resources, (String)"resources");
        Intrinsics.checkNotNullParameter(resourceLeaks, (String)"resourceLeaks");
        this.resources = resources;
        this.resourceLeaks = resourceLeaks;
    }

    public SymbolicResourceHandler() {
        this(new LinkedHashMap(), new LinkedHashSet());
    }

    public final void setResourceState(@NotNull SymbolicValue resource, @NotNull ResourceState state) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        this.resources.put(resource, state);
    }

    @NotNull
    public final Set<SymbolicValue> getAllResources() {
        return CollectionsKt.toSet((Iterable)this.resources.keySet());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<SymbolicValue> findResources(@NotNull Function1<? super ResourceState, Boolean> predicate) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        Map<SymbolicValue, ResourceState> $this$filter$iv = this.resources;
        boolean $i$f$filter = false;
        Map<SymbolicValue, ResourceState> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl = false;
            ResourceState state = (ResourceState)((Object)entry.getValue());
            if (!((Boolean)predicate.invoke((Object)state)).booleanValue()) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return destination$iv$iv.keySet();
    }

    @NotNull
    public final Set<SymbolicValue> getAllLeaks() {
        return CollectionsKt.toSet((Iterable)this.resourceLeaks);
    }

    public final void markLeak(@NotNull SymbolicValue resource) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        this.resourceLeaks.add(resource);
    }

    public final void removeLeak(@NotNull SymbolicValue resource) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        this.resourceLeaks.remove(resource);
    }

    public final void clearResourceLeaks() {
        this.resourceLeaks.clear();
    }

    @NotNull
    public final SymbolicResourceHandler merge(@NotNull SymbolicResourceHandler other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Map newResources2 = MapsKt.toMutableMap(UtilsKt.merge(this.resources, other.resources, merge.newResources.1.INSTANCE));
        Set resourceLeaks = CollectionsKt.toMutableSet((Iterable)SetsKt.plus(this.resourceLeaks, (Iterable)other.resourceLeaks));
        return new SymbolicResourceHandler(newResources2, resourceLeaks);
    }

    @NotNull
    public final SymbolicResourceHandler copy() {
        return new SymbolicResourceHandler(MapsKt.toMutableMap(this.resources), CollectionsKt.toMutableSet((Iterable)this.resourceLeaks));
    }
}

