/*
 * Decompiled with CFR 0.152.
 */
package com.goide.directiveComment;

import com.goide.GoParserDefinition;
import com.goide.directiveComment.GoDirectiveCommentArgument;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoDirectiveComment {
    private static final String GO_PREFIX = "go:";
    protected static final String COMMENT_START = "//go:";
    @NotNull
    private final String myName;
    @NotNull
    private final List<GoDirectiveCommentArgument> myArguments;

    public GoDirectiveComment(@NotNull String name, @NotNull List<GoDirectiveCommentArgument> arguments) {
        if (name == null) {
            GoDirectiveComment.$$$reportNull$$$0(0);
        }
        if (arguments == null) {
            GoDirectiveComment.$$$reportNull$$$0(1);
        }
        this.myName = name;
        this.myArguments = arguments;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            GoDirectiveComment.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public List<GoDirectiveCommentArgument> getArguments() {
        List<GoDirectiveCommentArgument> list = this.myArguments;
        if (list == null) {
            GoDirectiveComment.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public TextRange getPrefixAndNameRange(@Nullable PsiComment psiComment) {
        int prefixAndNameLength = GO_PREFIX.length() + this.myName.length();
        TextRange rangeInElement = TextRange.from((int)2, (int)prefixAndNameLength);
        TextRange textRange = psiComment == null ? rangeInElement : rangeInElement.shiftRight(psiComment.getTextRange().getStartOffset());
        if (textRange == null) {
            GoDirectiveComment.$$$reportNull$$$0(4);
        }
        return textRange;
    }

    @NotNull
    public TextRange getNameRange(@Nullable PsiComment psiComment) {
        TextRange rangeInElement = TextRange.from((int)(2 + GO_PREFIX.length()), (int)this.myName.length());
        TextRange textRange = psiComment == null ? rangeInElement : rangeInElement.shiftRight(psiComment.getTextRange().getStartOffset());
        if (textRange == null) {
            GoDirectiveComment.$$$reportNull$$$0(5);
        }
        return textRange;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GoDirectiveComment comment = (GoDirectiveComment)o;
        return this.myName.equals(comment.myName) && this.myArguments.equals(comment.myArguments);
    }

    public int hashCode() {
        return Objects.hash(this.myName, this.myArguments);
    }

    public String toString() {
        return "{" + this.myName + "," + String.valueOf(this.myArguments) + "}";
    }

    @Nullable
    public static GoDirectiveComment directiveCommentFrom(@NotNull PsiComment comment) {
        if (comment == null) {
            GoDirectiveComment.$$$reportNull$$$0(6);
        }
        if (comment.getTokenType() != GoParserDefinition.Lazy.LINE_COMMENT) {
            return null;
        }
        String commentText = comment.getText();
        if (!StringUtil.startsWith((CharSequence)commentText, (CharSequence)COMMENT_START)) {
            return null;
        }
        int firstWhitespaceOffset = StringUtil.findFirst((CharSequence)commentText, ch -> ch == ' ' || ch == '\t');
        if (firstWhitespaceOffset == -1) {
            return new GoDirectiveComment(commentText.substring(COMMENT_START.length()), Collections.emptyList());
        }
        String directiveName = commentText.substring(COMMENT_START.length(), firstWhitespaceOffset);
        int suffixOffset = firstWhitespaceOffset + 1;
        String suffix = commentText.substring(suffixOffset);
        return suffix.isEmpty() ? new GoDirectiveComment(directiveName, Collections.emptyList()) : new GoDirectiveComment(directiveName, Collections.singletonList(new GoDirectiveCommentArgument(suffix, suffixOffset)));
    }

    public static boolean isDirectiveComment(@NotNull PsiComment comment) {
        if (comment == null) {
            GoDirectiveComment.$$$reportNull$$$0(7);
        }
        return comment.getTokenType() == GoParserDefinition.Lazy.LINE_COMMENT && StringUtil.startsWith((CharSequence)comment.getText(), (CharSequence)COMMENT_START);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/directiveComment/GoDirectiveComment";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/directiveComment/GoDirectiveComment";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrefixAndNameRange";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "directiveCommentFrom";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isDirectiveComment";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

