/*
 * Decompiled with CFR 0.152.
 */
package com.goide.dlv;

import com.goide.dlv.JsonReaderEx;
import com.goide.dlv.protocol.DlvRequest;
import com.goide.dlv.protocol.DlvResponse;
import com.goide.i18n.GoBundle;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.rpc.CommandProcessor;
import org.jetbrains.rpc.RequestCallback;
import org.jetbrains.rpc.ResultReader;

public abstract class DlvCommandProcessor
extends CommandProcessor<JsonReaderEx, DlvResponse, DlvResponse> {
    @NonNls
    private static final String RPC_SERVER_PREFIX = "RPCServer\\.";
    @NonNls
    private static final String NULL_MESSAGE = "<null>";
    private static final Logger LOG = Logger.getInstance(DlvCommandProcessor.class);

    @Nullable
    public DlvResponse readIfHasSequence(@NotNull JsonReaderEx message) {
        if (message == null) {
            DlvCommandProcessor.$$$reportNull$$$0(0);
        }
        return new DlvResponse.CommandResponseImpl(message, null);
    }

    public int getSequence(@NotNull DlvResponse response) {
        if (response == null) {
            DlvCommandProcessor.$$$reportNull$$$0(1);
        }
        return response.id();
    }

    public void acceptNonSequence(JsonReaderEx message) {
    }

    public void processIncomingJson(@NotNull JsonReaderEx reader) {
        if (reader == null) {
            DlvCommandProcessor.$$$reportNull$$$0(2);
        }
        this.getMessageManager().processIncoming((Object)reader);
    }

    public void call(@NotNull DlvResponse response, @NotNull RequestCallback<DlvResponse> callback) {
        if (response == null) {
            DlvCommandProcessor.$$$reportNull$$$0(3);
        }
        if (callback == null) {
            DlvCommandProcessor.$$$reportNull$$$0(4);
        }
        if (response.result() != null) {
            callback.onSuccess((Object)response, (ResultReader)this);
        } else {
            callback.onError((Throwable)Promises.createError((String)DlvCommandProcessor.createMessage(response)));
        }
    }

    @NotNull
    private static String createMessage(@NotNull DlvResponse r) {
        DlvResponse.ErrorInfo e;
        if (r == null) {
            DlvCommandProcessor.$$$reportNull$$$0(5);
        }
        if ((e = r.error()) == null) {
            String string = GoBundle.message((String)"go.debugger.internal.messaging.error", (Object[])new Object[0]);
            if (string == null) {
                DlvCommandProcessor.$$$reportNull$$$0(6);
            }
            return string;
        }
        List<String> data = e.data();
        String message = e.message();
        if (ContainerUtil.isEmpty(data)) {
            String string = StringUtil.defaultIfEmpty((String)message, (String)NULL_MESSAGE);
            if (string == null) {
                DlvCommandProcessor.$$$reportNull$$$0(7);
            }
            return string;
        }
        SmartList list = new SmartList((Object)message);
        list.addAll(data);
        String string = list.toString();
        if (string == null) {
            DlvCommandProcessor.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public <RESULT> RESULT readResult(@NotNull String method, @NotNull DlvResponse successResponse) {
        Object o;
        if (method == null) {
            DlvCommandProcessor.$$$reportNull$$$0(9);
        }
        if (successResponse == null) {
            DlvCommandProcessor.$$$reportNull$$$0(10);
        }
        JsonReaderEx result = successResponse.result();
        assert (result != null) : "success result should be not null";
        JsonReader reader = result.asGson();
        Object object = o = new GsonBuilder().create().fromJson(reader, DlvCommandProcessor.getResultType(method.replaceFirst(RPC_SERVER_PREFIX, "")));
        if (object == null) {
            DlvCommandProcessor.$$$reportNull$$$0(11);
        }
        return (RESULT)object;
    }

    @NotNull
    private static Type getResultType(@NotNull String method) {
        if (method == null) {
            DlvCommandProcessor.$$$reportNull$$$0(12);
        }
        for (Class<?> c : DlvRequest.class.getDeclaredClasses()) {
            if (!method.equals(c.getSimpleName())) continue;
            Type s = c.getGenericSuperclass();
            assert (s instanceof ParameterizedType) : c.getCanonicalName() + " should have a generic parameter for correct callback processing";
            Type[] arguments = ((ParameterizedType)s).getActualTypeArguments();
            assert (arguments.length == 1) : c.getCanonicalName() + " should have only one generic argument for correct callback processing";
            Type type = arguments[0];
            if (type == null) {
                DlvCommandProcessor.$$$reportNull$$$0(13);
            }
            return type;
        }
        LOG.error("Unknown response " + method + ", please register an appropriate request into com.goide.dlv.protocol.DlvRequest");
        return Object.class;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 11, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/dlv/DlvCommandProcessor";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "successResponse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/dlv/DlvCommandProcessor";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createMessage";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "readResult";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readIfHasSequence";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSequence";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processIncomingJson";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "call";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createMessage";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 13: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "readResult";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getResultType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 11, 13 -> new IllegalStateException(string);
        };
    }
}

