/*
 * Decompiled with CFR 0.152.
 */
package com.goide.dlv;

import com.goide.dlv.DlvDebugProcess;
import com.goide.dlv.DlvUtil;
import com.goide.dlv.protocol.DlvApi;
import com.goide.dlv.protocol.DlvRequest;
import com.goide.i18n.GoBundle;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

class DlvSmartStepInto {
    private final DlvDebugProcess myProcess;

    DlvSmartStepInto(@NotNull DlvDebugProcess process) {
        if (process == null) {
            DlvSmartStepInto.$$$reportNull$$$0(0);
        }
        this.myProcess = process;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    Promise<Void> smartStepIntoFunctionValue(long goroutineId, int maxLine, @NotNull String string) {
        void functionExpression;
        if (string == null) {
            DlvSmartStepInto.$$$reportNull$$$0(1);
        }
        Promise promise = this.myProcess.send(new DlvRequest.Eval((String)functionExpression, 0, goroutineId)).thenAsync(arg_0 -> this.lambda$smartStepIntoFunctionValue$0((String)functionExpression, goroutineId, maxLine, arg_0));
        if (promise == null) {
            DlvSmartStepInto.$$$reportNull$$$0(2);
        }
        return promise;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    Promise<Void> smartStepIntoFunction(long goroutineId, int maxLine, @NotNull String packagePath, @NotNull String string) {
        void functionName;
        if (packagePath == null) {
            DlvSmartStepInto.$$$reportNull$$$0(3);
        }
        if (string == null) {
            DlvSmartStepInto.$$$reportNull$$$0(4);
        }
        return this.smartStepInto(goroutineId, maxLine, Set.of(DlvSmartStepInto.getLocation(packagePath, null, (String)functionName)), null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    Promise<Void> smartStepIntoMethod(long goroutineId, int maxLine, @NotNull String packagePath, @NotNull String receiverType, @NotNull String string) {
        void functionName;
        if (packagePath == null) {
            DlvSmartStepInto.$$$reportNull$$$0(5);
        }
        if (receiverType == null) {
            DlvSmartStepInto.$$$reportNull$$$0(6);
        }
        if (string == null) {
            DlvSmartStepInto.$$$reportNull$$$0(7);
        }
        return this.smartStepInto(goroutineId, maxLine, Set.of(DlvSmartStepInto.getLocation(packagePath, receiverType, (String)functionName)), null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    Promise<Void> smartStepIntoInterfaceMethod(long goroutineId, int maxLine, @NotNull Set<String> interfaceValues, @NotNull String string) {
        void functionName;
        if (interfaceValues == null) {
            DlvSmartStepInto.$$$reportNull$$$0(8);
        }
        if (string == null) {
            DlvSmartStepInto.$$$reportNull$$$0(9);
        }
        Promise promise = this.eval(goroutineId, interfaceValues).thenAsync(arg_0 -> this.lambda$smartStepIntoInterfaceMethod$2(interfaceValues, (String)functionName, goroutineId, maxLine, arg_0));
        if (promise == null) {
            DlvSmartStepInto.$$$reportNull$$$0(10);
        }
        return promise;
    }

    private static boolean isNilAddress(@Nullable BigInteger address) {
        return address == null || address.equals(BigInteger.ZERO);
    }

    @Nullable
    private static Pair<String, String> getImplementationType(@NotNull DlvApi.Variable var) {
        if (var == null) {
            DlvSmartStepInto.$$$reportNull$$$0(11);
        }
        if (var.isInterface() && var.children.length > 0 && "data".equals(var.children[0].name)) {
            DlvApi.Variable data = var.children[0];
            String type = data.type;
            int packageEnd = type.lastIndexOf(46);
            String implementationPackage = StringUtil.trimStart((String)type.substring(0, packageEnd), (String)"*");
            Object implementationType = type.substring(packageEnd + 1);
            if (type.startsWith("*")) {
                implementationType = "*" + (String)implementationType;
            }
            return Pair.create((Object)implementationPackage, (Object)implementationType);
        }
        return null;
    }

    @NotNull
    private static String getLocation(@NotNull String packagePath, @Nullable String receiverType, @NotNull String functionName) {
        if (packagePath == null) {
            DlvSmartStepInto.$$$reportNull$$$0(12);
        }
        if (functionName == null) {
            DlvSmartStepInto.$$$reportNull$$$0(13);
        }
        if (receiverType != null) {
            String string = receiverType.startsWith("*") ? packagePath + ".(" + receiverType + ")." + functionName : packagePath + "." + receiverType + "." + functionName;
            if (string == null) {
                DlvSmartStepInto.$$$reportNull$$$0(14);
            }
            return string;
        }
        String string = packagePath + "." + functionName;
        if (string == null) {
            DlvSmartStepInto.$$$reportNull$$$0(15);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private Promise<List<DlvApi.Variable>> eval(long goroutineId, @NotNull Collection<String> collection) {
        void expressions;
        if (collection == null) {
            DlvSmartStepInto.$$$reportNull$$$0(16);
        }
        Promise promise = Promises.collectResults((Collection)ContainerUtil.map((Collection)expressions, it -> this.myProcess.send(new DlvRequest.Eval((String)it, 0, goroutineId))));
        if (promise == null) {
            DlvSmartStepInto.$$$reportNull$$$0(17);
        }
        return promise;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private Promise<Void> smartStepInto(long goroutineId, int maxLine, @NotNull Set<String> locations, @Nullable BigInteger bigInteger) {
        void entryPointAddress;
        if (locations == null) {
            DlvSmartStepInto.$$$reportNull$$$0(18);
        }
        Promise promise = this.myProcess.send(new DlvRequest.Stacktrace((int)goroutineId)).thenAsync(arg_0 -> this.lambda$smartStepInto$5(goroutineId, locations, (BigInteger)entryPointAddress, maxLine, arg_0));
        if (promise == null) {
            DlvSmartStepInto.$$$reportNull$$$0(19);
        }
        return promise;
    }

    @NotNull
    private Promise<Void> handleStepIn(@NotNull DlvApi.DebuggerState state, @NotNull SmartStepIntoContext context) {
        if (state == null) {
            DlvSmartStepInto.$$$reportNull$$$0(20);
        }
        if (context == null) {
            DlvSmartStepInto.$$$reportNull$$$0(21);
        }
        Promise promise = context.isSteppedIn(state).thenAsync(steppedIn -> this.handleStepIn(state, context, (boolean)steppedIn));
        if (promise == null) {
            DlvSmartStepInto.$$$reportNull$$$0(22);
        }
        return promise;
    }

    @NotNull
    private Promise<Void> handleStepIn(@NotNull DlvApi.DebuggerState inState, @NotNull SmartStepIntoContext context, boolean steppedIn) {
        if (inState == null) {
            DlvSmartStepInto.$$$reportNull$$$0(23);
        }
        if (context == null) {
            DlvSmartStepInto.$$$reportNull$$$0(24);
        }
        return steppedIn ? context.isInsideSelectedCall(inState).thenAsync(isInside -> isInside != false ? this.finishStepInto(inState) : this.stepOutAndRepeat(context)) : this.tryStepIn(inState, context);
    }

    @NotNull
    private Promise<Void> tryStepIn(@NotNull DlvApi.DebuggerState state, @NotNull SmartStepIntoContext context) {
        if (state == null) {
            DlvSmartStepInto.$$$reportNull$$$0(25);
        }
        if (context == null) {
            DlvSmartStepInto.$$$reportNull$$$0(26);
        }
        return context.canStepIn(state) ? this.myProcess.step().thenAsync(inState -> this.handleStepIn((DlvApi.DebuggerState)inState, context)) : this.finishStepInto(state);
    }

    @NotNull
    private Promise<Void> stepOutAndRepeat(@NotNull SmartStepIntoContext context) {
        if (context == null) {
            DlvSmartStepInto.$$$reportNull$$$0(27);
        }
        Promise promise = this.myProcess.send(new DlvRequest.Command("stepOut")).thenAsync(outState -> this.tryStepIn((DlvApi.DebuggerState)outState, context));
        if (promise == null) {
            DlvSmartStepInto.$$$reportNull$$$0(28);
        }
        return promise;
    }

    @NotNull
    private Promise<Void> finishStepInto(@NotNull DlvApi.DebuggerState s) {
        if (s == null) {
            DlvSmartStepInto.$$$reportNull$$$0(29);
        }
        Promise<Void> promise = this.myProcess.consumeDebuggerState(s);
        if (promise == null) {
            DlvSmartStepInto.$$$reportNull$$$0(30);
        }
        return promise;
    }

    private /* synthetic */ Promise lambda$smartStepInto$5(long goroutineId, Set locations, BigInteger entryPointAddress, int maxLine, List initialStack) {
        DlvApi.Location topEntry = (DlvApi.Location)ContainerUtil.getFirstItem((List)initialStack);
        if (topEntry == null) {
            return this.myProcess.consumeStateWithError(GoBundle.message((String)"go.debugger.smart.step.into.failed", (Object[])new Object[]{GoBundle.message((String)"go.debugger.cannot.get.current.stack", (Object[])new Object[0])}));
        }
        SmartStepIntoContext context = new SmartStepIntoContext(goroutineId, initialStack, topEntry, locations, entryPointAddress, maxLine);
        return this.myProcess.step().thenAsync(s -> this.handleStepIn((DlvApi.DebuggerState)s, context));
    }

    private /* synthetic */ Promise lambda$smartStepIntoInterfaceMethod$2(Set interfaceValues, String functionName, long goroutineId, int maxLine, List vars) {
        List<Pair> types = vars.stream().map(DlvSmartStepInto::getImplementationType).filter(Objects::nonNull).toList();
        if (types.size() != interfaceValues.size()) {
            return this.myProcess.consumeStateWithError(GoBundle.message((String)"go.debugger.smart.step.into.failed", (Object[])new Object[]{GoBundle.message((String)"go.debugger.cannot.retrieve.interface.value.type", (Object[])new Object[0])}));
        }
        Set<String> locations = types.stream().map(it -> DlvSmartStepInto.getLocation((String)it.first, (String)it.second, functionName)).collect(Collectors.toSet());
        return this.smartStepInto(goroutineId, maxLine, locations, null);
    }

    private /* synthetic */ Promise lambda$smartStepIntoFunctionValue$0(String functionExpression, long goroutineId, int maxLine, DlvApi.Variable var) {
        if (!var.isFunction()) {
            return this.myProcess.consumeStateWithError(GoBundle.message((String)"go.debugger.smart.step.into.failed", (Object[])new Object[]{GoBundle.message((String)"go.debugger.expression.is.not.a.function", (Object[])new Object[]{functionExpression})}));
        }
        BigInteger base = var.base;
        return DlvSmartStepInto.isNilAddress(base) ? this.myProcess.consumeStateWithError(GoBundle.message((String)"go.debugger.smart.step.into.failed", (Object[])new Object[]{GoBundle.message((String)"go.debugger.expression.is.nil", (Object[])new Object[]{functionExpression})})) : this.smartStepInto(goroutineId, maxLine, Collections.emptySet(), base);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 10, 14, 15, 17, 19, 22, 28, 30 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionExpression";
                break;
            }
            case 2: 
            case 10: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 22: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/dlv/DlvSmartStepInto";
                break;
            }
            case 3: 
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packagePath";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiverType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceValues";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locations";
                break;
            }
            case 20: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 21: 
            case 24: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inState";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/dlv/DlvSmartStepInto";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "smartStepIntoFunctionValue";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "smartStepIntoInterfaceMethod";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "eval";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "smartStepInto";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "handleStepIn";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "stepOutAndRepeat";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "finishStepInto";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "smartStepIntoFunctionValue";
                break;
            }
            case 2: 
            case 10: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 22: 
            case 28: 
            case 30: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "smartStepIntoFunction";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "smartStepIntoMethod";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "smartStepIntoInterfaceMethod";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getImplementationType";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getLocation";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "eval";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "smartStepInto";
                break;
            }
            case 20: 
            case 21: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "handleStepIn";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "tryStepIn";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "stepOutAndRepeat";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "finishStepInto";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 10, 14, 15, 17, 19, 22, 28, 30 -> new IllegalStateException(string);
        };
    }

    private final class SmartStepIntoContext {
        private final long myGoroutineId;
        private final List<DlvApi.Location> myInitialStack;
        private final DlvApi.Location myTopStackEntry;
        private final Set<String> myDesiredLocations;
        private final BigInteger myEntryPointAddress;
        private final int myMaxLine;

        /*
         * WARNING - void declaration
         */
        private SmartStepIntoContext(@NotNull long goroutineId, @NotNull List<DlvApi.Location> initialStack, @NotNull DlvApi.Location topStackEntry, @Nullable Set<String> desiredLocations, BigInteger entryPointAddress, int n) {
            void zeroBasedMaxLine;
            if (initialStack == null) {
                SmartStepIntoContext.$$$reportNull$$$0(0);
            }
            if (topStackEntry == null) {
                SmartStepIntoContext.$$$reportNull$$$0(1);
            }
            if (desiredLocations == null) {
                SmartStepIntoContext.$$$reportNull$$$0(2);
            }
            this.myGoroutineId = goroutineId;
            this.myInitialStack = initialStack;
            this.myTopStackEntry = topStackEntry;
            this.myDesiredLocations = desiredLocations;
            this.myEntryPointAddress = entryPointAddress;
            this.myMaxLine = zeroBasedMaxLine + true;
        }

        @NotNull
        Promise<Boolean> isSteppedIn(@NotNull DlvApi.DebuggerState s) {
            if (s == null) {
                SmartStepIntoContext.$$$reportNull$$$0(3);
            }
            String currentName = DlvUtil.currentFunctionName(s);
            return !this.myTopStackEntry.name().equals(currentName) ? Promises.resolvedPromise((Object)true) : this.stackHasGrown();
        }

        boolean canStepIn(@NotNull DlvApi.DebuggerState s) {
            if (s == null) {
                SmartStepIntoContext.$$$reportNull$$$0(4);
            }
            String currentName = DlvUtil.currentFunctionName(s);
            DlvApi.Goroutine goroutine = s.currentGoroutine;
            int line = goroutine != null ? goroutine.currentLoc.line : Integer.MAX_VALUE;
            return this.myTopStackEntry.name().equals(currentName) && line < this.myMaxLine;
        }

        @NotNull
        Promise<Boolean> isInsideSelectedCall(@NotNull DlvApi.DebuggerState s) {
            if (s == null) {
                SmartStepIntoContext.$$$reportNull$$$0(5);
            }
            if (this.myEntryPointAddress != null) {
                Promise promise = DlvSmartStepInto.this.myProcess.send(new DlvRequest.Stacktrace((int)this.myGoroutineId)).thenAsync(stack -> {
                    boolean stackGrown;
                    boolean bl = stackGrown = stack.size() > this.myInitialStack.size();
                    if (stackGrown) {
                        boolean topFrameChecked = false;
                        for (DlvApi.Location frame : stack) {
                            if (topFrameChecked && !DlvUtil.isAutogenerated(frame)) break;
                            DlvApi.Function func = frame.function;
                            if (func != null && this.myEntryPointAddress.equals(func.value)) {
                                return Promises.resolvedPromise((Object)true);
                            }
                            topFrameChecked = true;
                        }
                    }
                    return Promises.resolvedPromise((Object)false);
                });
                if (promise == null) {
                    SmartStepIntoContext.$$$reportNull$$$0(6);
                }
                return promise;
            }
            return !this.myDesiredLocations.contains(DlvUtil.currentFunctionName(s)) ? Promises.resolvedPromise((Object)false) : this.stackHasGrown();
        }

        @NotNull
        private Promise<Boolean> stackHasGrown() {
            Promise promise = DlvSmartStepInto.this.myProcess.send(new DlvRequest.Stacktrace((int)this.myGoroutineId)).thenAsync(stack -> Promises.resolvedPromise((Object)(stack.size() > this.myInitialStack.size() ? 1 : 0)));
            if (promise == null) {
                SmartStepIntoContext.$$$reportNull$$$0(7);
            }
            return promise;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initialStack";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topStackEntry";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "desiredLocations";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "s";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/dlv/DlvSmartStepInto$SmartStepIntoContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/dlv/DlvSmartStepInto$SmartStepIntoContext";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "isInsideSelectedCall";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "stackHasGrown";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isSteppedIn";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "canStepIn";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isInsideSelectedCall";
                    break;
                }
                case 6: 
                case 7: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6, 7 -> new IllegalStateException(string);
            };
        }
    }
}

