/*
 * Decompiled with CFR 0.152.
 */
package com.goide.dlv.attach;

import com.goide.execution.GoBuildingRunner;
import com.goide.execution.GoConfigurationFactoryBase;
import com.goide.execution.GoRunConfigurationBase;
import com.goide.execution.GoRunUtil;
import com.goide.execution.GoRunningState;
import com.goide.execution.GoWslUtil;
import com.goide.execution.application.GoApplicationConfiguration;
import com.goide.execution.application.GoApplicationRunConfigurationType;
import com.goide.sdk.GoSdkService;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.net.NetUtils;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public abstract class DlvDebugSessionStarter {
    private final Project myProject;

    protected DlvDebugSessionStarter(@NotNull Project project) {
        if (project == null) {
            DlvDebugSessionStarter.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public void start() throws ExecutionException {
        InetSocketAddress address;
        FileDocumentManager.getInstance().saveAllDocuments();
        GoConfigurationFactoryBase factory = GoApplicationRunConfigurationType.getInstance().getFactory();
        GoApplicationConfiguration configuration = (GoApplicationConfiguration)factory.createTemplateConfiguration(this.myProject);
        configuration.setDefaultTargetName(null);
        Executor executor = DefaultDebugExecutor.getDebugExecutorInstance();
        ExecutionEnvironment env = ExecutionEnvironmentBuilder.create((Project)this.myProject, (Executor)executor, (RunProfile)configuration).build();
        GoBuildingRunner runner = Objects.requireNonNull((GoBuildingRunner)((Object)ProgramRunner.PROGRAM_RUNNER_EP.findExtension(GoBuildingRunner.class)));
        try {
            boolean preferIpv6 = Registry.is((String)"go.debugger.prefer.ipv6.for.wsl.run.target") && GoWslUtil.isInWsl(GoSdkService.getInstance(this.myProject).getSdk(null));
            InetAddress localHost = GoRunUtil.resolveLocalAddress(preferIpv6);
            address = new InetSocketAddress(localHost, NetUtils.findAvailableSocketPort());
        }
        catch (IOException e) {
            throw new ExecutionException((Throwable)e);
        }
        GoRunUtil.executeOnPooledThread(() -> {
            GoRunningState<GoRunConfigurationBase<?>> state = this.createState(address, env, configuration);
            state.prepareStateInBGT();
            return state.execute(env.getExecutor(), (ProgramRunner)runner);
        }).onSuccess(execResult -> {
            XDebugProcessStarter starter = this.createDebugProcessStarter(address, (ExecutionResult)execResult);
            ApplicationManager.getApplication().invokeLater(() -> {
                try {
                    XDebugSession session = XDebuggerManager.getInstance((Project)env.getProject()).startSessionAndShowTab(this.getSessionName(), env.getContentToReuse(), starter);
                    this.customizeDebugSession(session);
                }
                catch (Exception e) {
                    ExecutionUtil.handleExecutionError((Project)this.myProject, (String)"Debug", (String)e.getMessage(), (Throwable)e);
                }
            });
        }).onError(t -> ExecutionUtil.handleExecutionError((Project)this.myProject, (String)"Debug", (String)this.getSessionName(), (Throwable)t));
    }

    @NotNull
    protected abstract GoRunningState<GoRunConfigurationBase<?>> createState(@NotNull InetSocketAddress var1, @NotNull ExecutionEnvironment var2, @NotNull GoApplicationConfiguration var3);

    @NotNull
    @Nls
    protected abstract String getSessionName();

    @NotNull
    protected abstract XDebugProcessStarter createDebugProcessStarter(@NotNull InetSocketAddress var1, @NotNull ExecutionResult var2);

    protected void customizeDebugSession(@NotNull XDebugSession session) {
        if (session == null) {
            DlvDebugSessionStarter.$$$reportNull$$$0(1);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        objectArray2[1] = "com/goide/dlv/attach/DlvDebugSessionStarter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "customizeDebugSession";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

