/*
 * Decompiled with CFR 0.152.
 */
package com.goide.dlv.location;

import com.goide.dlv.DlvVm;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DlvPositionConverter {
    @Nullable
    public String toRemotePath(@NotNull VirtualFile var1);

    @Nullable
    public VirtualFile toLocalFile(@NotNull String var1);

    public static class Caching
    implements DlvPositionConverter {
        private final DlvPositionConverter myDelegate;
        private final ReadWriteLock myLock;
        private final Map<VirtualFile, Ref<String>> myLocalToRemote;
        private final Map<String, Ref<VirtualFile>> myRemoteToLocal;

        public Caching(@NotNull DlvPositionConverter delegate) {
            if (delegate == null) {
                Caching.$$$reportNull$$$0(0);
            }
            this.myLock = new ReentrantReadWriteLock();
            this.myLocalToRemote = new HashMap<VirtualFile, Ref<String>>();
            this.myRemoteToLocal = new HashMap<String, Ref<VirtualFile>>();
            this.myDelegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public String toRemotePath(@NotNull VirtualFile localFile) {
            Ref<String> result;
            if (localFile == null) {
                Caching.$$$reportNull$$$0(1);
            }
            this.myLock.readLock().lock();
            try {
                result = this.myLocalToRemote.get(localFile);
                if (result != null) {
                    String string = (String)result.get();
                    return string;
                }
            }
            finally {
                this.myLock.readLock().unlock();
            }
            this.myLock.writeLock().lock();
            try {
                result = this.myLocalToRemote.get(localFile);
                if (result != null) {
                    String string = (String)result.get();
                    return string;
                }
                String localPath = localFile.getPath();
                DlvVm.LOG.debug("Find remote path for " + localPath);
                String remotePath = this.myDelegate.toRemotePath(localFile);
                this.myLocalToRemote.put(localFile, (Ref<String>)Ref.create((Object)remotePath));
                if (remotePath != null) {
                    VirtualFile existing;
                    Ref<VirtualFile> backRef = this.myRemoteToLocal.get(remotePath);
                    if (backRef != null && !localFile.equals(existing = (VirtualFile)backRef.get())) {
                        DlvVm.LOG.debug("Remap remote path " + remotePath + " from " + (existing != null ? existing.getPath() : null) + " to " + localPath);
                    }
                    this.myRemoteToLocal.put(remotePath, (Ref<VirtualFile>)Ref.create((Object)localFile));
                }
                DlvVm.LOG.debug("Map path local: " + localPath + ", remote: " + remotePath);
                String string = remotePath;
                return string;
            }
            finally {
                this.myLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public VirtualFile toLocalFile(@NotNull String remotePath) {
            Ref<VirtualFile> result;
            if (remotePath == null) {
                Caching.$$$reportNull$$$0(2);
            }
            this.myLock.readLock().lock();
            try {
                result = this.myRemoteToLocal.get(remotePath);
                if (result != null) {
                    VirtualFile virtualFile = (VirtualFile)result.get();
                    return virtualFile;
                }
            }
            finally {
                this.myLock.readLock().unlock();
            }
            this.myLock.writeLock().lock();
            try {
                Ref<String> backRef;
                result = this.myRemoteToLocal.get(remotePath);
                if (result != null) {
                    VirtualFile virtualFile = (VirtualFile)result.get();
                    return virtualFile;
                }
                DlvVm.LOG.debug("Find local path for " + remotePath);
                VirtualFile localFile = this.myDelegate.toLocalFile(remotePath);
                this.myRemoteToLocal.put(remotePath, (Ref<VirtualFile>)Ref.create((Object)localFile));
                if (localFile != null && (backRef = this.myLocalToRemote.get(localFile)) != null) {
                    String existing = (String)backRef.get();
                    if (remotePath.equals(existing)) {
                        DlvVm.LOG.debug("Remap local path " + String.valueOf(localFile) + " from " + existing + " to " + remotePath);
                    }
                    this.myLocalToRemote.put(localFile, (Ref<String>)Ref.create((Object)remotePath));
                }
                DlvVm.LOG.debug("Map path local: " + (localFile != null ? localFile.getPath() : null) + ", remote: " + remotePath);
                VirtualFile virtualFile = localFile;
                return virtualFile;
            }
            finally {
                this.myLock.writeLock().unlock();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localFile";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "remotePath";
                    break;
                }
            }
            objectArray2[1] = "com/goide/dlv/location/DlvPositionConverter$Caching";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "toRemotePath";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "toLocalFile";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

