/*
 * Decompiled with CFR 0.152.
 */
package com.goide.dlv.protocol;

import com.goide.i18n.GoBundle;
import com.google.gson.annotations.SerializedName;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DlvApi {
    private static final Logger LOG = Logger.getInstance(DlvApi.class);
    @NonNls
    public static final String CONTINUE = "continue";
    @NonNls
    public static final String STEP = "step";
    @NonNls
    public static final String STEP_OUT = "stepOut";
    @NonNls
    public static final String STEP_INSTRUCTION = "stepInstruction";
    @NonNls
    public static final String NEXT = "next";
    @NonNls
    public static final String SWITCH_THREAD = "switchThread";
    @NonNls
    public static final String HALT = "halt";
    @NonNls
    public static final String SWITCH_GOROUTINE = "switchGoroutine";
    @NonNls
    public static final String REWIND = "rewind";

    public static class ListGoroutinesOut {
        public List<Goroutine> Goroutines;
        public int Nextg;
    }

    public static class Recorded {
        public boolean Recorded;
        public String TraceDirectory;
    }

    public static class GetVersion {
        public String DelveVersion;
        public int APIVersion;
        public String Backend;
        public String TargetGoVersion;
        public String MinSupportedVersionOfGo;
        public String MaxSupportedVersionOfGo;
    }

    public static class BreakpointInfo {
        public List<Location> stacktrace;
        @Nullable
        public Goroutine goroutine;
        public List<Variable> variables;
        public List<Variable> arguments;
        public List<Variable> locals;
    }

    public static class Goroutine {
        public long id;
        public BigInteger pc;
        public String file;
        public int line;
        public Location currentLoc;
        public Location userCurrentLoc;
        public Location goStatementLoc;
        public long threadID;
        public Map<String, String> labels;
    }

    public static class Variable {
        public static final int SHADOWED_FLAG_MASK = 2;
        @NonNls
        public String name;
        @NonNls
        public String type;
        public BigInteger addr;
        public boolean onlyAddr;
        @NonNls
        public String realType;
        public int flags;
        public int kind;
        @NonNls
        public String value;
        public long len;
        public long cap;
        public Variable[] children;
        public BigInteger base;
        public String unreadable;
        public String locationExpression;
        @SerializedName(value="DeclLine")
        @Nullable
        @NonNls
        public BigInteger declLine;

        @NotNull
        private Kind getKind() {
            Kind kind;
            try {
                kind = Kind.values()[this.kind];
            }
            catch (Exception e) {
                LOG.warn("Unknown kind '" + this.kind + "' of variable '" + this.name + "'");
                Kind kind2 = Kind.Invalid;
                if (kind2 == null) {
                    Variable.$$$reportNull$$$0(1);
                }
                return kind2;
            }
            if (kind == null) {
                Variable.$$$reportNull$$$0(0);
            }
            return kind;
        }

        public boolean isSlice() {
            return this.getKind() == Kind.Slice;
        }

        public boolean isArray() {
            return this.getKind() == Kind.Array;
        }

        public boolean isNumber() {
            return this.getKind().isNumber();
        }

        public boolean isInteger() {
            return this.getKind().isInteger();
        }

        public boolean isString() {
            return this.getKind() == Kind.String;
        }

        public boolean isBool() {
            return this.getKind() == Kind.Bool;
        }

        public boolean isStructure() {
            return this.getKind() == Kind.Struct;
        }

        public boolean isInterface() {
            return this.getKind() == Kind.Interface;
        }

        public boolean isChan() {
            return this.getKind() == Kind.Chan;
        }

        public boolean isFunction() {
            return this.getKind() == Kind.Func;
        }

        public boolean isPtr() {
            return this.getKind() == Kind.Ptr;
        }

        public boolean isMap() {
            return this.getKind() == Kind.Map;
        }

        public boolean isUint8() {
            return this.realType.equals("uint8");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/goide/dlv/protocol/DlvApi$Variable", "getKind"));
        }

        private static enum Kind {
            Invalid,
            Bool,
            Int,
            Int8,
            Int16,
            Int32,
            Int64,
            Uint,
            Uint8,
            Uint16,
            Uint32,
            Uint64,
            Uintptr,
            Float32,
            Float64,
            Complex64,
            Complex128,
            Array,
            Chan,
            Func,
            Interface,
            Map,
            Ptr,
            Slice,
            String,
            Struct,
            UnsafePointer;


            private boolean isNumber() {
                return this.compareTo(Int) >= 0 && this.compareTo(Complex128) <= 0;
            }

            private boolean isInteger() {
                return this.compareTo(Int) >= 0 && this.compareTo(Uintptr) <= 0;
            }
        }
    }

    public static class Function {
        public String name;
        public BigInteger value;
        public byte type;
        public int goclass;
        public List<Variable> args;
        public List<Variable> locals;
    }

    public static class Location {
        public BigInteger pc;
        @Nullable
        @NlsSafe
        public String file;
        public int line;
        @Nullable
        public Function function;

        public Location(BigInteger pc, @Nullable @NlsSafe String file2, int line, @Nullable Function function) {
            this.pc = pc;
            this.file = file2;
            this.line = line;
            this.function = function;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Location)) {
                return false;
            }
            Location location = (Location)o;
            if (this.line != location.line) {
                return false;
            }
            if (!Objects.equals(this.pc, location.pc)) {
                return false;
            }
            return Objects.equals(this.file, location.file);
        }

        public int hashCode() {
            int result = this.pc != null ? this.pc.hashCode() : 0;
            result = 31 * result + (this.file != null ? this.file.hashCode() : 0);
            result = 31 * result + this.line;
            return result;
        }

        @NlsSafe
        public String name() {
            return this.function != null ? this.function.name : GoBundle.message((String)"go.debugger.missing.function.name", (Object[])new Object[0]);
        }
    }

    public static class Thread {
        public long id;
        public BigInteger pc;
        public String file;
        public int line;
        @Nullable
        public Function function;
        public long goroutineID;
        @Nullable
        public Breakpoint breakPoint;
        @Nullable
        public BreakpointInfo breakPointInfo;
        @SerializedName(value="ReturnValues")
        @NonNls
        public List<Variable> returnValues;
    }

    public static class Breakpoint {
        public int id;
        @Nullable
        public String name;
        public BigInteger addr;
        public String file;
        public int line;
        @Nullable
        public String functionName;
        public String Cond;
        @SerializedName(value="continue")
        @NonNls
        public boolean tracepoint;
        public int stacktrace;
        public boolean goroutine;
        @Nullable
        public List<String> variables;
        public Object hitCount;
        public long totalHitCount;
    }

    public static class DebuggerState {
        @SerializedName(value="Pid")
        @NonNls
        public int pid;
        public Breakpoint breakPoint;
        @Nullable
        public Thread currentThread;
        @SerializedName(value="Threads")
        @NonNls
        public List<Thread> threads;
        @SerializedName(value="NextInProgress")
        @NonNls
        public boolean nextInProgress;
        @Nullable
        public Goroutine currentGoroutine;
        public BreakpointInfo breakPointInfo;
        public boolean exited;
        public long exitStatus;
        public String err;
        @SerializedName(value="Running")
        @NonNls
        public boolean running;
        @SerializedName(value="Recording")
        @NonNls
        public boolean recording;
    }
}

