/*
 * Decompiled with CFR 0.152.
 */
package com.goide.dlv.renderer;

import com.goide.dlv.DlvUtil;
import com.goide.dlv.DlvXValue;
import com.goide.dlv.protocol.DlvApi;
import com.goide.dlv.renderer.DlvIpMaskValueRendererKt;
import com.goide.dlv.renderer.DlvIpValueRendererKt;
import com.goide.dlv.renderer.DlvRegularValuePresentation;
import com.goide.dlv.renderer.DlvValueRenderer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/goide/dlv/renderer/DlvIpNetValueRenderer;", "Lcom/goide/dlv/renderer/DlvValueRenderer;", "<init>", "()V", "getPresentation", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/xdebugger/frame/presentation/XValuePresentation;", "node", "Lcom/intellij/xdebugger/frame/XValueNode;", "value", "Lcom/goide/dlv/DlvXValue;", "formatMask", "", "variable", "Lcom/goide/dlv/protocol/DlvApi$Variable;", "intellij.go.impl"})
public final class DlvIpNetValueRenderer
implements DlvValueRenderer {
    @Override
    @NotNull
    public Promise<XValuePresentation> getPresentation(@NotNull XValueNode node2, @NotNull DlvXValue value2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        Intrinsics.checkNotNullParameter((Object)((Object)value2), (String)"value");
        Promise promise = value2.getTypePresentationAsync(node2).then(arg_0 -> DlvIpNetValueRenderer.getPresentation$lambda$1(arg_0 -> DlvIpNetValueRenderer.getPresentation$lambda$0(this, value2, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"then(...)");
        return promise;
    }

    private final String formatMask(DlvApi.Variable variable) {
        String string;
        int maskLength;
        DlvApi.Variable[] children = variable.children;
        DlvApi.Variable variable2 = DlvUtil.getByName(children, "IP");
        if (variable2 == null) {
            return "";
        }
        DlvApi.Variable ipField = variable2;
        DlvApi.Variable variable3 = DlvUtil.getByName(children, "Mask");
        if (variable3 == null) {
            return "";
        }
        DlvApi.Variable maskField = variable3;
        byte[] byArray = DlvUtil.readBytes(ipField);
        if (byArray == null) {
            return "";
        }
        byte[] ipBytes = byArray;
        byte[] byArray2 = DlvUtil.readBytes(maskField);
        if (byArray2 == null) {
            return "";
        }
        byte[] maskBytes = byArray2;
        if (ipBytes.length == 0 && maskBytes.length == 0) {
            return "<nil>";
        }
        String ip = DlvIpValueRendererKt.formatValidAddress(ipBytes);
        if (ip == null || StringsKt.contains$default((CharSequence)ip, (CharSequence)":", (boolean)false, (int)2, null) && maskBytes.length != 16) {
            return "";
        }
        if (!StringsKt.contains$default((CharSequence)ip, (CharSequence)":", (boolean)false, (int)2, null) && maskBytes.length == 16) {
            byte[] byArray3 = new byte[]{maskBytes[12], maskBytes[13], maskBytes[14], maskBytes[15]};
            maskBytes = byArray3;
        }
        if ((maskLength = DlvIpMaskValueRendererKt.getSimpleMaskLength(maskBytes)) != -1) {
            string = String.valueOf(maskLength);
        } else {
            String string2 = StringUtil.toHexString((byte[])maskBytes);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toHexString(...)");
        }
        String mask = string;
        return ip + "/" + mask;
    }

    private static final XValuePresentation getPresentation$lambda$0(DlvIpNetValueRenderer this$0, DlvXValue $value, String type) {
        DlvApi.Variable variable = $value.getVariable();
        Intrinsics.checkNotNullExpressionValue((Object)variable, (String)"getVariable(...)");
        return (XValuePresentation)new DlvRegularValuePresentation(this$0.formatMask(variable), type);
    }

    private static final XValuePresentation getPresentation$lambda$1(Function1 $tmp0, Object p0) {
        return (XValuePresentation)$tmp0.invoke(p0);
    }
}

