/*
 * Decompiled with CFR 0.152.
 */
package com.goide.editor;

import com.goide.GoParserDefinition;
import com.goide.codeInsight.GoCodeInsightSettings;
import com.goide.formatter.GoFormatterUtil;
import com.goide.i18n.GoBundle;
import com.goide.intentions.GoGenerateTypeFromJsonIntention;
import com.goide.intentions.GoJsonTypeGenerator;
import com.goide.psi.GoFieldDeclaration;
import com.goide.psi.GoFile;
import com.goide.psi.GoStructType;
import com.goide.psi.GoTypeDeclaration;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.statistics.GoGenerateTypeFromJsonUsageCollector;
import com.intellij.codeInsight.editorActions.CopyPastePostProcessor;
import com.intellij.codeInsight.editorActions.TextBlockTransferableData;
import com.intellij.json.JsonLanguage;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoConvertJsonCopyPasteProcessor
extends CopyPastePostProcessor<TextBlockTransferableData> {
    private static final DataFlavor DATA_FLAVOR = new DataFlavor(GoConvertJsonCopyPasteProcessor.class, "Data for the JSON-to-Go-type converter");

    @NotNull
    public List<TextBlockTransferableData> collectTransferableData(@NotNull PsiFile file2, @NotNull Editor editor, int @NotNull [] startOffsets, int @NotNull [] endOffsets) {
        if (file2 == null) {
            GoConvertJsonCopyPasteProcessor.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            GoConvertJsonCopyPasteProcessor.$$$reportNull$$$0(1);
        }
        if (startOffsets == null) {
            GoConvertJsonCopyPasteProcessor.$$$reportNull$$$0(2);
        }
        if (endOffsets == null) {
            GoConvertJsonCopyPasteProcessor.$$$reportNull$$$0(3);
        }
        List<TextBlockTransferableData> list = Collections.emptyList();
        if (list == null) {
            GoConvertJsonCopyPasteProcessor.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public List<TextBlockTransferableData> extractTransferableData(@NotNull Transferable content2) {
        block7: {
            List<TextBlockTransferableData> list;
            if (content2 == null) {
                GoConvertJsonCopyPasteProcessor.$$$reportNull$$$0(5);
            }
            if (GoCodeInsightSettings.getInstance().getConvertJsonOnPaste() == ThreeState.NO) {
                List<TextBlockTransferableData> list2 = Collections.emptyList();
                if (list2 == null) {
                    GoConvertJsonCopyPasteProcessor.$$$reportNull$$$0(6);
                }
                return list2;
            }
            try {
                String text = (String)ObjectUtils.tryCast((Object)content2.getTransferData(DataFlavor.stringFlavor), String.class);
                if (text == null) break block7;
                list = Collections.singletonList(new Data(text));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (list == null) {
                GoConvertJsonCopyPasteProcessor.$$$reportNull$$$0(7);
            }
            return list;
        }
        List<TextBlockTransferableData> list = Collections.emptyList();
        if (list == null) {
            GoConvertJsonCopyPasteProcessor.$$$reportNull$$$0(8);
        }
        return list;
    }

    public void processTransferableData(@NotNull Project project, @NotNull Editor editor, @NotNull RangeMarker bounds, int caretOffset, @NotNull Ref<? super Boolean> indented, @NotNull List<? extends TextBlockTransferableData> values2) {
        int secondQuoteIndex;
        PsiElement at;
        Data data;
        if (project == null) {
            GoConvertJsonCopyPasteProcessor.$$$reportNull$$$0(9);
        }
        if (editor == null) {
            GoConvertJsonCopyPasteProcessor.$$$reportNull$$$0(10);
        }
        if (bounds == null) {
            GoConvertJsonCopyPasteProcessor.$$$reportNull$$$0(11);
        }
        if (indented == null) {
            GoConvertJsonCopyPasteProcessor.$$$reportNull$$$0(12);
        }
        if (values2 == null) {
            GoConvertJsonCopyPasteProcessor.$$$reportNull$$$0(13);
        }
        if ((data = (Data)ContainerUtil.findInstance(values2, Data.class)) == null) {
            return;
        }
        Document document = editor.getDocument();
        if (!(PsiDocumentManager.getInstance((Project)project).getPsiFile(document) instanceof GoFile)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        GoFile file2 = (GoFile)((Object)ObjectUtils.tryCast((Object)PsiDocumentManager.getInstance((Project)project).getPsiFile(document), GoFile.class));
        PsiElement psiElement = at = file2 != null ? file2.findElementAt(caretOffset) : null;
        if (at == null || at instanceof PsiComment || !data.myText.startsWith("\"") && GoParserDefinition.Lazy.STRING_LITERALS.contains(at.getNode().getElementType())) {
            return;
        }
        boolean sequenceOfJsonProperties = false;
        Object text = StringUtil.trimTrailing((String)StringUtil.trimLeading((String)data.myText));
        if (((String)text).startsWith("\"") && (secondQuoteIndex = ((String)text).indexOf("\"", 1)) < ((String)text).length() - 1 && ((String)text).charAt(secondQuoteIndex + 1) == ':') {
            text = "{\n" + StringUtil.trimEnd((String)text, (String)",") + "\n}";
            sequenceOfJsonProperties = true;
        }
        if (((String)text).startsWith("{") && ((String)text).endsWith("}") || ((String)text).startsWith("[") && ((String)text).endsWith("]")) {
            boolean pasteOnFileLevel = GoPsiImplUtil.getTopLevelDeclaration(at) == null;
            GoStructType struct = pasteOnFileLevel ? null : (GoStructType)PsiTreeUtil.getParentOfType((PsiElement)at, GoStructType.class);
            GoTypeDeclaration typeDecl = (GoTypeDeclaration)PsiTreeUtil.getParentOfType((PsiElement)struct, GoTypeDeclaration.class);
            GoFieldDeclaration fieldDecl = (GoFieldDeclaration)PsiTreeUtil.getParentOfType((PsiElement)struct, GoFieldDeclaration.class);
            if (!pasteOnFileLevel && typeDecl == null && fieldDecl == null) {
                return;
            }
            GoGenerateTypeFromJsonUsageCollector.logJsonLikeTextPasted();
            JsonFile jsonFile = (JsonFile)ObjectUtils.tryCast((Object)PsiFileFactory.getInstance((Project)project).createFileFromText("paste.json", (Language)JsonLanguage.INSTANCE, (CharSequence)text), JsonFile.class);
            if (jsonFile == null || PsiTreeUtil.findChildOfType((PsiElement)jsonFile, PsiErrorElement.class) != null) {
                return;
            }
            JsonValue topLevelValue = (JsonValue)ContainerUtil.getOnlyItem((Collection)jsonFile.getAllTopLevelValues());
            if (topLevelValue == null) {
                return;
            }
            GoJsonTypeGenerator generator = new GoJsonTypeGenerator((PsiElement)file2);
            String goCode = generator.generate(topLevelValue);
            GoFile goFile = GoElementFactory.createFileFromText(project, goCode);
            GoTypeSpec generatedType = (GoTypeSpec)ContainerUtil.getFirstItem(goFile.getTypes());
            if (generatedType == null) {
                return;
            }
            GoGenerateTypeFromJsonUsageCollector.logPastedJsonConvertedToType();
            if (pasteOnFileLevel) {
                GoConvertJsonCopyPasteProcessor.generateType(editor, bounds, file2, generatedType, sequenceOfJsonProperties);
            } else {
                GoStructType generatedStruct = (GoStructType)ObjectUtils.tryCast((Object)generatedType.getSpecType().getType(), GoStructType.class);
                if (generatedStruct != null) {
                    GoConvertJsonCopyPasteProcessor.generateFields(document, file2, bounds, struct, generatedStruct, sequenceOfJsonProperties);
                }
            }
        }
    }

    private static void generateType(@NotNull Editor editor, @NotNull RangeMarker bounds, @NotNull GoFile file2, @NotNull GoTypeSpec generatedType, boolean sequenceOfJsonProperties) {
        if (editor == null) {
            GoConvertJsonCopyPasteProcessor.$$$reportNull$$$0(14);
        }
        if (bounds == null) {
            GoConvertJsonCopyPasteProcessor.$$$reportNull$$$0(15);
        }
        if (file2 == null) {
            GoConvertJsonCopyPasteProcessor.$$$reportNull$$$0(16);
        }
        if (generatedType == null) {
            GoConvertJsonCopyPasteProcessor.$$$reportNull$$$0(17);
        }
        MessageDialogBuilder.YesNo dialog = (MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)GoBundle.message((String)"go.generate.type.from.json.on.paste.dialog.title", (Object[])new Object[0]), (String)(sequenceOfJsonProperties ? GoBundle.message((String)"go.generate.type.from.json.properties.on.paste.type.message", (Object[])new Object[0]) : GoBundle.message((String)"go.generate.type.from.json.on.paste.type.message", (Object[])new Object[0]))).doNotAsk((DoNotAskOption)GoConvertJsonCopyPasteProcessor.getDoNotAskOption());
        boolean accepted = GoCodeInsightSettings.getInstance().getConvertJsonOnPaste() == ThreeState.YES || dialog.ask(editor.getProject());
        GoGenerateTypeFromJsonUsageCollector.logGenerateTypeOnPaste(accepted);
        if (accepted) {
            ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().runWriteAction(() -> {
                TextRange jsonRange = bounds.getTextRange();
                GoGenerateTypeFromJsonIntention.runGenerateTypeTemplate(editor, file2, generatedType, jsonRange, bounds.getStartOffset());
            }));
        }
    }

    private static void generateFields(@NotNull Document document, @NotNull GoFile file2, @NotNull RangeMarker bounds, @NotNull GoStructType targetStruct, @NotNull GoStructType generatedStruct, boolean sequenceOfJsonProperties) {
        if (document == null) {
            GoConvertJsonCopyPasteProcessor.$$$reportNull$$$0(18);
        }
        if (file2 == null) {
            GoConvertJsonCopyPasteProcessor.$$$reportNull$$$0(19);
        }
        if (bounds == null) {
            GoConvertJsonCopyPasteProcessor.$$$reportNull$$$0(20);
        }
        if (targetStruct == null) {
            GoConvertJsonCopyPasteProcessor.$$$reportNull$$$0(21);
        }
        if (generatedStruct == null) {
            GoConvertJsonCopyPasteProcessor.$$$reportNull$$$0(22);
        }
        Project project = file2.getProject();
        MessageDialogBuilder.YesNo dialog = (MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)GoBundle.message((String)"go.generate.type.from.json.on.paste.dialog.title", (Object[])new Object[0]), (String)(sequenceOfJsonProperties ? GoBundle.message((String)"go.generate.type.from.json.properties.on.paste.struct.fields.message", (Object[])new Object[0]) : GoBundle.message((String)"go.generate.type.from.json.on.paste.struct.fields.message", (Object[])new Object[0]))).doNotAsk((DoNotAskOption)GoConvertJsonCopyPasteProcessor.getDoNotAskOption());
        boolean accepted = GoCodeInsightSettings.getInstance().getConvertJsonOnPaste() == ThreeState.YES || dialog.ask(project);
        GoGenerateTypeFromJsonUsageCollector.logGenerateFieldsOnPaste(accepted);
        if (accepted) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                int start = Objects.requireNonNull(generatedStruct.getLbrace()).getTextRange().getStartOffset() + 1;
                int end = Objects.requireNonNull(generatedStruct.getRbrace()).getTextRange().getStartOffset();
                if (targetStruct.getLbrace() != null && targetStruct.getLbrace().getTextRange().getStartOffset() == bounds.getStartOffset()) {
                    --start;
                    ++end;
                }
                String replacement = generatedStruct.getContainingFile().getText().substring(start, end);
                document.replaceString(bounds.getStartOffset(), bounds.getEndOffset(), (CharSequence)replacement);
                PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                GoStructType updatedStruct = (GoStructType)PsiTreeUtil.getParentOfType((PsiElement)file2.findElementAt(bounds.getStartOffset()), GoStructType.class);
                if (updatedStruct != null) {
                    GoFormatterUtil.reformat(updatedStruct);
                }
            });
        }
    }

    @NotNull
    private static DoNotAskOption.Adapter getDoNotAskOption() {
        return new DoNotAskOption.Adapter(){

            public void rememberChoice(boolean isSelected, int exitCode) {
                if (isSelected) {
                    GoCodeInsightSettings.getInstance().setConvertJsonOnPaste(ThreeState.fromBoolean((exitCode == 0 ? 1 : 0) != 0));
                }
            }

            public boolean shouldSaveOptionsOnCancel() {
                return true;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startOffsets";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endOffsets";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/editor/GoConvertJsonCopyPasteProcessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indented";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatedType";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetStruct";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatedStruct";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/editor/GoConvertJsonCopyPasteProcessor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTransferableData";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "extractTransferableData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectTransferableData";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "extractTransferableData";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processTransferableData";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "generateType";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "generateFields";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 7, 8 -> new IllegalStateException(string);
        };
    }

    private static class Data
    implements TextBlockTransferableData {
        private final String myText;

        private Data(@NotNull String text) {
            if (text == null) {
                Data.$$$reportNull$$$0(0);
            }
            this.myText = text;
        }

        @Nullable
        public DataFlavor getFlavor() {
            return DATA_FLAVOR;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/goide/editor/GoConvertJsonCopyPasteProcessor$Data", "<init>"));
        }
    }
}

