/*
 * Decompiled with CFR 0.152.
 */
package com.goide.editor;

import com.goide.GoTypes;
import com.goide.codeInsight.GoCodeInsightSettings;
import com.goide.documentation.GoDocumentationProvider;
import com.goide.editor.GoParameterInfoUtil;
import com.goide.psi.GoArgumentList;
import com.goide.psi.GoBuiltinCallExpr;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoFunctionType;
import com.goide.psi.GoParamDefinition;
import com.goide.psi.GoParameterDeclaration;
import com.goide.psi.GoParameters;
import com.goide.psi.GoSignature;
import com.goide.psi.GoSignatureOwner;
import com.goide.psi.GoType;
import com.goide.psi.impl.GoPsiImplUtil;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.lang.ASTNode;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoHandlerWithTabActionSupport;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.ParameterInfoUtils;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoParameterInfoHandler
implements ParameterInfoHandlerWithTabActionSupport<GoArgumentList, Object, GoExpression>,
DumbAware {
    static final JBColor HIGHLIGHTED_COLOR = JBColor.namedColor((String)"ParameterInfo.currentParameterForeground", (Color)new JBColor(0x1D1D1D, 0xE8E8E8));
    private static final int PARAMETER_INFO_TEXT_WIDTH_PX = 400;
    private static final String PARAMETER_INFO_GODOC_DIV_STYLE = "border-bottom: 1px solid #%s; padding-bottom: 6px; margin-bottom: 3px; width:%dpx\n".formatted(ColorUtil.toHex((Color)new JBColor(0xCCCCCC, 0xBBBBBB)), 400).trim();
    private static final String PARAMETER_INFO_PARAMETERS_DIV_STYLE = "width:%dpx".formatted(400);

    public GoExpression @NotNull [] getActualParameters(@NotNull GoArgumentList o) {
        if (o == null) {
            GoParameterInfoHandler.$$$reportNull$$$0(0);
        }
        GoExpression[] goExpressionArray = o.getExpressionList().toArray(new GoExpression[0]);
        if (goExpressionArray == null) {
            GoParameterInfoHandler.$$$reportNull$$$0(1);
        }
        return goExpressionArray;
    }

    @NotNull
    public IElementType getActualParameterDelimiterType() {
        IElementType iElementType = GoTypes.COMMA;
        if (iElementType == null) {
            GoParameterInfoHandler.$$$reportNull$$$0(2);
        }
        return iElementType;
    }

    @NotNull
    public IElementType getActualParametersRBraceType() {
        IElementType iElementType = GoTypes.RPAREN;
        if (iElementType == null) {
            GoParameterInfoHandler.$$$reportNull$$$0(3);
        }
        return iElementType;
    }

    @NotNull
    public Set<Class<?>> getArgumentListAllowedParentClasses() {
        return new HashSet();
    }

    @NotNull
    public Set<? extends Class<?>> getArgListStopSearchClasses() {
        return new HashSet();
    }

    @NotNull
    public Class<GoArgumentList> getArgumentListClass() {
        return GoArgumentList.class;
    }

    @Nullable
    public GoArgumentList findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        GoArgumentList argList;
        if (context == null) {
            GoParameterInfoHandler.$$$reportNull$$$0(4);
        }
        if ((argList = GoParameterInfoUtil.findGoArgumentListForParameterInfo((ParameterInfoContext)context)) == null) {
            return null;
        }
        PsiElement parent = argList.getParent();
        GoExpression expression = parent instanceof GoCallExpr ? ((GoCallExpr)parent).getExpression() : (parent instanceof GoBuiltinCallExpr ? ((GoBuiltinCallExpr)parent).getExpression() : null);
        GoFunctionType type = GoParameterInfoHandler.findFunctionType(expression);
        if (type != null) {
            context.setItemsToShow(new Object[]{type});
        }
        return argList;
    }

    public void showParameterInfo(@NotNull GoArgumentList argList, @NotNull CreateParameterInfoContext context) {
        if (argList == null) {
            GoParameterInfoHandler.$$$reportNull$$$0(5);
        }
        if (context == null) {
            GoParameterInfoHandler.$$$reportNull$$$0(6);
        }
        if (!ArrayUtil.isEmpty((Object[])context.getItemsToShow())) {
            context.showHint((PsiElement)argList, argList.getTextRange().getStartOffset(), (ParameterInfoHandler)this);
        }
    }

    @Nullable
    public static GoFunctionType findCallType(@NotNull GoCallExpr call) {
        if (call == null) {
            GoParameterInfoHandler.$$$reportNull$$$0(7);
        }
        return GoParameterInfoHandler.findFunctionType(call.getExpression());
    }

    @Nullable
    private static GoFunctionType findFunctionType(@Nullable GoExpression expression) {
        GoType type;
        GoType goType = type = expression != null ? expression.getGoType(null) : null;
        if (type == null) {
            return null;
        }
        if (type instanceof GoFunctionType) {
            return (GoFunctionType)type;
        }
        GoType base = type.getUnderlyingType(expression);
        return (GoFunctionType)ObjectUtils.tryCast((Object)base, GoFunctionType.class);
    }

    @Nullable
    public GoArgumentList findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        if (context == null) {
            GoParameterInfoHandler.$$$reportNull$$$0(8);
        }
        return GoParameterInfoUtil.findGoArgumentListForParameterInfo((ParameterInfoContext)context);
    }

    public void updateParameterInfo(@NotNull GoArgumentList list, @NotNull UpdateParameterInfoContext context) {
        if (list == null) {
            GoParameterInfoHandler.$$$reportNull$$$0(9);
        }
        if (context == null) {
            GoParameterInfoHandler.$$$reportNull$$$0(10);
        }
        context.setCurrentParameter(ParameterInfoUtils.getCurrentParameterIndex((ASTNode)list.getNode(), (int)context.getOffset(), (IElementType)GoTypes.COMMA));
    }

    public void updateUI(@Nullable Object p, @NotNull ParameterInfoUIContext context) {
        GoSignature signature;
        if (context == null) {
            GoParameterInfoHandler.$$$reportNull$$$0(11);
        }
        if (p == null) {
            context.setUIComponentEnabled(false);
            return;
        }
        GoSignature goSignature = signature = p instanceof GoSignatureOwner ? ((GoSignatureOwner)p).getSignature() : null;
        if (signature == null || !signature.isValid()) {
            return;
        }
        GoParameters parameters = signature.getParameters();
        List<String> parametersPresentations = GoParameterInfoHandler.getParameterPresentations(parameters, GoPsiImplUtil::getPresentationText);
        int selectedParameter = parameters.isVariadic() ? Math.min(context.getCurrentParameterIndex(), parametersPresentations.size() - 1) : context.getCurrentParameterIndex();
        String goDoc = GoParameterInfoHandler.getGoDoc(signature);
        if (goDoc != null) {
            GoParameterInfoHandler.showParametersWithGoDoc(goDoc, parametersPresentations, selectedParameter, context);
        } else {
            GoParameterInfoHandler.showParametersWithoutGoDoc(parametersPresentations, selectedParameter, context);
        }
    }

    private static void showParametersWithGoDoc(@NotNull String goDoc, @NotNull List<String> parametersPresentations, int selectedParameter, @NotNull ParameterInfoUIContext context) {
        if (goDoc == null) {
            GoParameterInfoHandler.$$$reportNull$$$0(12);
        }
        if (parametersPresentations == null) {
            GoParameterInfoHandler.$$$reportNull$$$0(13);
        }
        if (context == null) {
            GoParameterInfoHandler.$$$reportNull$$$0(14);
        }
        @NlsContexts.Label StringBuilder builder = new StringBuilder();
        builder.append("<div style='%s'>%s</div>".formatted(PARAMETER_INFO_GODOC_DIV_STYLE, goDoc));
        if (!parametersPresentations.isEmpty()) {
            builder.append("<div style='%s'>".formatted(PARAMETER_INFO_PARAMETERS_DIV_STYLE));
            for (int i = 0; i < parametersPresentations.size(); ++i) {
                if (i != 0) {
                    builder.append(", ");
                }
                String parameter = XmlStringUtil.escapeString((String)parametersPresentations.get(i));
                if (i == selectedParameter) {
                    builder.append("<b color='#%s'>".formatted(ColorUtil.toHex((Color)HIGHLIGHTED_COLOR)));
                }
                builder.append(parameter);
                if (i != selectedParameter) continue;
                builder.append("</b>");
            }
            builder.append("</div>");
        } else {
            builder.append(XmlStringUtil.escapeString((String)CodeInsightBundle.message((String)"parameter.info.no.parameters", (Object[])new Object[0])));
        }
        context.setupRawUIComponentPresentation(builder.toString());
    }

    private static void showParametersWithoutGoDoc(@NotNull List<String> parametersPresentations, int selectedParameter, @NotNull ParameterInfoUIContext context) {
        if (parametersPresentations == null) {
            GoParameterInfoHandler.$$$reportNull$$$0(15);
        }
        if (context == null) {
            GoParameterInfoHandler.$$$reportNull$$$0(16);
        }
        int highlightOffsetStart = 0;
        int highlightOffsetEnd = 0;
        @NlsContexts.Label StringBuilder builder = new StringBuilder();
        if (!parametersPresentations.isEmpty()) {
            for (int i = 0; i < parametersPresentations.size(); ++i) {
                if (i != 0) {
                    builder.append(", ");
                }
                if (i == selectedParameter) {
                    highlightOffsetStart = builder.length();
                }
                builder.append(parametersPresentations.get(i));
                if (i != selectedParameter) continue;
                highlightOffsetEnd = builder.length();
            }
        } else {
            builder.append(CodeInsightBundle.message((String)"parameter.info.no.parameters", (Object[])new Object[0]));
        }
        context.setupUIComponentPresentation(builder.toString(), highlightOffsetStart, highlightOffsetEnd, false, false, false, context.getDefaultParameterColor());
    }

    @Contract(pure=true)
    @Nullable
    private static String getGoDoc(@NotNull GoSignature signature) {
        if (signature == null) {
            GoParameterInfoHandler.$$$reportNull$$$0(17);
        }
        if (!GoCodeInsightSettings.getInstance().isShowDocumentationInParameterPopup()) {
            return null;
        }
        GoFunctionOrMethodDeclaration function = (GoFunctionOrMethodDeclaration)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)signature, GoFunctionOrMethodDeclaration.class);
        if (function == null) {
            return null;
        }
        String goDoc = GoDocumentationProvider.getCommentText(GoDocumentationProvider.getCommentsForElement(function), true);
        return StringUtil.isNotEmpty((String)goDoc) ? goDoc : null;
    }

    @NotNull
    public static List<String> getParameterPresentations(@NotNull GoParameters parameters, @NotNull Function<? super GoType, String> typePresentationFunction) {
        if (parameters == null) {
            GoParameterInfoHandler.$$$reportNull$$$0(18);
        }
        if (typePresentationFunction == null) {
            GoParameterInfoHandler.$$$reportNull$$$0(19);
        }
        return GoParameterInfoHandler.getParameterPresentations(parameters, typePresentationFunction, false);
    }

    @NotNull
    public static List<String> getParameterPresentations(@NotNull GoParameters parameters, @NotNull Function<? super GoType, String> typePresentationFunction, boolean withoutNames) {
        if (parameters == null) {
            GoParameterInfoHandler.$$$reportNull$$$0(20);
        }
        if (typePresentationFunction == null) {
            GoParameterInfoHandler.$$$reportNull$$$0(21);
        }
        List<GoParameterDeclaration> paramDeclarations = parameters.getParameterDeclarationList();
        ArrayList<String> paramPresentations = new ArrayList<String>(2 * paramDeclarations.size());
        for (GoParameterDeclaration paramDeclaration : paramDeclarations) {
            boolean isVariadic = paramDeclaration.isVariadic();
            List<GoParamDefinition> paramDefinitionList = paramDeclaration.getParamDefinitionList();
            String variadic = isVariadic ? "..." : "";
            String rawType = typePresentationFunction.apply(paramDeclaration.getType());
            String separator = rawType.isEmpty() ? "" : " ";
            String type = variadic + rawType;
            for (GoParamDefinition paramDefinition : paramDefinitionList) {
                String name = StringUtil.notNullize((String)paramDefinition.getName());
                paramPresentations.add(withoutNames || name.isEmpty() ? type : name + separator + type);
            }
            if (!paramDefinitionList.isEmpty()) continue;
            paramPresentations.add(type);
        }
        ArrayList<String> arrayList = paramPresentations;
        if (arrayList == null) {
            GoParameterInfoHandler.$$$reportNull$$$0(22);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/editor/GoParameterInfoHandler";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argList";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goDoc";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametersPresentations";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typePresentationFunction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/editor/GoParameterInfoHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParameters";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParameterDelimiterType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParametersRBraceType";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterPresentations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getActualParameters";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 22: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findElementForParameterInfo";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showParameterInfo";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findCallType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findElementForUpdatingParameterInfo";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "updateParameterInfo";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateUI";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "showParametersWithGoDoc";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "showParametersWithoutGoDoc";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getGoDoc";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getParameterPresentations";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 22 -> new IllegalStateException(string);
        };
    }
}

