/*
 * Decompiled with CFR 0.152.
 */
package com.goide.execution;

import com.goide.execution.DefaultTargetEnvironmentProvider;
import com.goide.execution.target.GoLanguageRuntimeConfiguration;
import com.goide.sdk.GoSdk;
import com.goide.sdk.GoSdkService;
import com.goide.sdk.GoSdkUtil;
import com.intellij.execution.target.LanguageRuntimeConfiguration;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslPath;
import com.intellij.execution.wsl.target.WslTargetEnvironmentConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoDefaultTargetEnvironmentProvider
implements DefaultTargetEnvironmentProvider {
    @Override
    @Nullable
    public TargetEnvironmentConfiguration getTargetEnvironment(@NotNull Project project, @Nullable Module module) {
        WslPath wslPath;
        if (project == null) {
            GoDefaultTargetEnvironmentProvider.$$$reportNull$$$0(0);
        }
        if (!SystemInfo.isWindows) {
            return null;
        }
        GoSdk sdk = GoSdkService.getInstance(project).getSdk(module);
        VirtualFile executable = sdk.getExecutable();
        if (executable != null && (wslPath = WslPath.parseWindowsUncPath((String)executable.getPath())) != null) {
            return GoDefaultTargetEnvironmentProvider.createWslConfiguration(project, module, wslPath);
        }
        return null;
    }

    @NotNull
    private static WslTargetEnvironmentConfiguration createWslConfiguration(@NotNull Project project, @Nullable Module module, @NotNull WslPath goExecutablePath) {
        if (project == null) {
            GoDefaultTargetEnvironmentProvider.$$$reportNull$$$0(1);
        }
        if (goExecutablePath == null) {
            GoDefaultTargetEnvironmentProvider.$$$reportNull$$$0(2);
        }
        WSLDistribution wsl = goExecutablePath.getDistribution();
        WslTargetEnvironmentConfiguration result = new WslTargetEnvironmentConfiguration(wsl);
        GoLanguageRuntimeConfiguration goRuntime = new GoLanguageRuntimeConfiguration();
        goRuntime.setGoBinaryPath(goExecutablePath.getLinuxPath());
        ArrayList<Object> goPathEntries = new ArrayList<Object>();
        for (VirtualFile entry : GoSdkUtil.getGoPathRoots(project, module)) {
            WslPath wslRootPath = WslPath.parseWindowsUncPath((String)entry.getPath());
            if (wslRootPath == null || !wslRootPath.getDistributionId().equals(goExecutablePath.getDistributionId())) continue;
            goPathEntries.add(wslRootPath.getLinuxPath());
        }
        if (goPathEntries.isEmpty()) {
            goPathEntries.add(wsl.getUserHome() + "/go");
        }
        goRuntime.setGoPath(StringUtil.join(goPathEntries, (String)":"));
        result.addLanguageRuntime((LanguageRuntimeConfiguration)goRuntime);
        WslTargetEnvironmentConfiguration wslTargetEnvironmentConfiguration = result;
        if (wslTargetEnvironmentConfiguration == null) {
            GoDefaultTargetEnvironmentProvider.$$$reportNull$$$0(3);
        }
        return wslTargetEnvironmentConfiguration;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goExecutablePath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/execution/GoDefaultTargetEnvironmentProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/execution/GoDefaultTargetEnvironmentProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createWslConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTargetEnvironment";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createWslConfiguration";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

