/*
 * Decompiled with CFR 0.152.
 */
package com.goide.execution;

import com.goide.GoConstants;
import com.goide.GoNotifications;
import com.goide.GoOsManager;
import com.goide.dlv.DlvDebugProcess;
import com.goide.dlv.DlvDisconnectOption;
import com.goide.dlv.DlvRemoteVmConnection;
import com.goide.execution.GoRunConfigurationBase;
import com.goide.execution.target.GoLanguageRuntimeConfiguration;
import com.goide.execution.testing.GoTestFinder;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoPsiTreeUtil;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoType;
import com.goide.util.GoCacheUtilKt;
import com.goide.util.GoLocalEnvironmentRequest;
import com.goide.util.GoUtil;
import com.goide.util.Value;
import com.goide.vgo.configuration.VgoEnvironmentVariable;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Platform;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetPlatform;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextComponentAccessors;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.ui.SystemNotifications;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.fields.ExpandableTextField;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.TreeTraversal;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.File;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.swing.JTextField;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.connection.VmConnection;

public final class GoRunUtil {
    public static final Function<String, List<String>> PATHS_SPLITTER = s -> StringUtil.split((String)s, (String)"|");
    public static final Function<List<String>, String> PATHS_JOINER = s -> StringUtil.join((Collection)s, (String)"|");

    private GoRunUtil() {
    }

    @Contract(value="null -> false")
    public static boolean isMainGoFile(@Nullable PsiFile psiFile) {
        if (!GoTestFinder.isTestFile(psiFile) && psiFile instanceof GoFile && psiFile.isValid()) {
            return "main".equals(((GoFile)psiFile).getPackageName()) && ((GoFile)psiFile).hasMainFunction();
        }
        return false;
    }

    public static void installDirectoryChooser(@Nullable Project project, @NotNull TextFieldWithBrowseButton field) {
        if (field == null) {
            GoRunUtil.$$$reportNull$$$0(0);
        }
        GoRunUtil.installFileChooser(project, field, true, null, FileChooserDescriptorFactory.createSingleFolderDescriptor());
    }

    public static void installFileChooser(@Nullable Project project, @NotNull TextFieldWithBrowseButton field) {
        if (field == null) {
            GoRunUtil.$$$reportNull$$$0(1);
        }
        GoRunUtil.installFileChooser(project, field, true, null, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
    }

    public static void installFileChooser(@NotNull Project project, @NotNull TextFieldWithHistoryWithBrowseButton field) {
        if (project == null) {
            GoRunUtil.$$$reportNull$$$0(2);
        }
        if (field == null) {
            GoRunUtil.$$$reportNull$$$0(3);
        }
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withTitle(UIBundle.message((String)"file.chooser.default.title", (Object[])new Object[0]));
        field.addBrowseFolderListener(project, descriptor, TextComponentAccessors.TEXT_FIELD_WITH_HISTORY_WHOLE_TEXT);
    }

    public static void installDirectoryChooser(@NotNull Project project, @NotNull TextFieldWithHistoryWithBrowseButton field) {
        if (project == null) {
            GoRunUtil.$$$reportNull$$$0(4);
        }
        if (field == null) {
            GoRunUtil.$$$reportNull$$$0(5);
        }
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(UIBundle.message((String)"file.chooser.default.title", (Object[])new Object[0]));
        field.addBrowseFolderListener(project, descriptor, TextComponentAccessors.TEXT_FIELD_WITH_HISTORY_WHOLE_TEXT);
    }

    private static void installProjectFileChooser(Project project, TextFieldWithBrowseButton field, @Nullable Consumer<VirtualFile> onFileChosen) {
        GoRunUtil.installFileChooser(project, field, project.isDefault(), onFileChosen, FileChooserDescriptorFactory.createSingleFileDescriptor((String)"go").withTitle(UIBundle.message((String)"file.chooser.default.title", (Object[])new Object[0])));
    }

    private static void installFileChooser(@Nullable Project project, @NotNull TextFieldWithBrowseButton field, boolean showFileSystemRoots, final @Nullable Consumer<VirtualFile> onFileChosen, @NotNull FileChooserDescriptor chooserDescriptor) {
        if (field == null) {
            GoRunUtil.$$$reportNull$$$0(6);
        }
        if (chooserDescriptor == null) {
            GoRunUtil.$$$reportNull$$$0(7);
        }
        if (!showFileSystemRoots) {
            if (project == null) {
                throw new RuntimeException("Cannot install non-system roots as chooser roots for null project");
            }
            SmartList roots = new SmartList();
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                Collections.addAll(roots, ModuleRootManager.getInstance((Module)module).getContentRoots());
            }
            roots.add(ProjectUtil.guessProjectDir((Project)project));
            chooserDescriptor.setRoots((List)roots);
        }
        chooserDescriptor.withShowFileSystemRoots(showFileSystemRoots);
        field.addBrowseFolderListener(new TextBrowseFolderListener(chooserDescriptor, project){

            protected void onFileChosen(@NotNull VirtualFile chosenFile) {
                if (chosenFile == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (onFileChosen != null) {
                    onFileChosen.accept(chosenFile);
                } else {
                    super.onFileChosen(chosenFile);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chosenFile", "com/goide/execution/GoRunUtil$1", "onFileChosen"));
            }
        });
    }

    @NotNull
    public static TextFieldWithBrowseButton createMultipleFileField(@NotNull Project project) {
        if (project == null) {
            GoRunUtil.$$$reportNull$$$0(8);
        }
        ExpandableTextField expandableTextField = new ExpandableTextField(PATHS_SPLITTER::apply, PATHS_JOINER::apply);
        expandableTextField.setMonospaced(false);
        TextFieldWithBrowseButton field = new TextFieldWithBrowseButton((JTextField)expandableTextField);
        field.setButtonIcon(IconUtil.getAddIcon());
        GoRunUtil.installProjectFileChooser(project, field, file2 -> {
            String text;
            field.setText(text + (!(text = field.getText()).isEmpty() ? "|" : "") + file2.getPresentableUrl());
        });
        TextFieldWithBrowseButton textFieldWithBrowseButton = field;
        if (textFieldWithBrowseButton == null) {
            GoRunUtil.$$$reportNull$$$0(9);
        }
        return textFieldWithBrowseButton;
    }

    public static void printGoEnvVariables(@NotNull Project project, @NotNull Map<String, String> environment, @NotNull ProcessHandler handler) {
        if (project == null) {
            GoRunUtil.$$$reportNull$$$0(10);
        }
        if (environment == null) {
            GoRunUtil.$$$reportNull$$$0(11);
        }
        if (handler == null) {
            GoRunUtil.$$$reportNull$$$0(12);
        }
        Stream.concat(Stream.of("GOROOT", "GOPATH", "GOEXPERIMENT"), VgoEnvironmentVariable.getKnownVariableNames(project).stream()).filter(environment::containsKey).map(it -> it + "=" + (String)environment.get(it) + " #gosetup\n").forEach(it -> handler.notifyTextAvailable(it, ProcessOutputTypes.SYSTEM));
    }

    @NotNull
    public static Map<GoCallExpr, String> getSubTests(@NotNull GoFunctionOrMethodDeclaration function) {
        if (function == null) {
            GoRunUtil.$$$reportNull$$$0(13);
        }
        Map map = (Map)CachedValuesManager.getCachedValue((PsiElement)function, () -> GoCacheUtilKt.createStubIndexDependentResult(function.getProject(), (Map)DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> GoRunUtil.getSubTestsInner(function)), function));
        if (map == null) {
            GoRunUtil.$$$reportNull$$$0(14);
        }
        return map;
    }

    public static boolean isRunTestCall(@NotNull PsiElement expr) {
        GoReferenceExpression referenceExpression;
        if (expr == null) {
            GoRunUtil.$$$reportNull$$$0(15);
        }
        if (!(expr instanceof GoCallExpr)) {
            return false;
        }
        GoCallExpr callExpr = (GoCallExpr)expr;
        GoExpression innerExpression = callExpr.getExpression();
        if (innerExpression instanceof GoReferenceExpression && (referenceExpression = (GoReferenceExpression)innerExpression).getIdentifier().textMatches((CharSequence)"Run")) {
            PsiElement resolve = referenceExpression.resolve();
            if (resolve == null && DumbService.isDumb((Project)expr.getProject())) {
                return referenceExpression.getRawQualifier() != null;
            }
            if (resolve instanceof GoMethodDeclaration) {
                GoMethodDeclaration methodDeclaration = (GoMethodDeclaration)resolve;
                GoFile file2 = methodDeclaration.getContainingFile();
                String importPath = file2.getImportPath(true);
                if ("testing".equals(importPath)) {
                    GoType receiverType = methodDeclaration.getReceiverType();
                    return receiverType != null && (receiverType.textMatches("*T") || receiverType.textMatches("*B"));
                }
                if ("github.com/stretchr/testify/suite".equals(importPath)) {
                    GoType receiverType = methodDeclaration.getReceiverType();
                    return receiverType != null && receiverType.textMatches("*Suite");
                }
            }
        }
        return false;
    }

    @NotNull
    private static Map<GoCallExpr, String> getSubTestsInner(@NotNull GoFunctionOrMethodDeclaration function) {
        if (function == null) {
            GoRunUtil.$$$reportNull$$$0(16);
        }
        HashMap<GoCallExpr, String> result = new HashMap<GoCallExpr, String>();
        Object2IntOpenHashMap testIndices = new Object2IntOpenHashMap();
        TreeTraversal.TracingIt iterator = (TreeTraversal.TracingIt)((SyntaxTraverser)((SyntaxTraverser)GoPsiTreeUtil.goTraverser().regard(GoRunUtil::isRunTestCall)).withRoot((Object)function)).traverse(TreeTraversal.PRE_ORDER_DFS).typedIterator();
        while (iterator.hasNext()) {
            GoCallExpr parent;
            String parentPath;
            GoCallExpr expression = (GoCallExpr)ObjectUtils.tryCast((Object)iterator.next(), GoCallExpr.class);
            if (expression == null || (parentPath = (parent = (GoCallExpr)ObjectUtils.tryCast((Object)iterator.parent(), GoCallExpr.class)) != null ? (String)result.get(parent) : function.getName()) == null) continue;
            String testName = GoRunUtil.uniqueTestName(GoRunUtil.sanitizeTestName(GoRunUtil.calculateTestName(expression)), parentPath, (Object2IntMap<String>)testIndices);
            ContainerUtil.putIfNotNull((Object)expression, (Object)testName, result);
        }
        HashMap<GoCallExpr, String> hashMap = result;
        if (hashMap == null) {
            GoRunUtil.$$$reportNull$$$0(17);
        }
        return hashMap;
    }

    @Contract(value="null,_,_->null; !null,_,_->!null")
    @Nullable
    public static String uniqueTestName(@Nullable String name, @NotNull String path, @NotNull Object2IntMap<String> testIndices) {
        if (path == null) {
            GoRunUtil.$$$reportNull$$$0(18);
        }
        if (testIndices == null) {
            GoRunUtil.$$$reportNull$$$0(19);
        }
        if (name == null) {
            return null;
        }
        boolean empty2 = name.isEmpty();
        Object fullName = path + "/" + name;
        while (empty2 || testIndices.containsKey(fullName)) {
            int index = testIndices.getInt(fullName);
            testIndices.put(fullName, index + 1);
            fullName = String.format("%s#%02d", fullName, index);
            empty2 = false;
        }
        testIndices.put(fullName, 1);
        return fullName;
    }

    @Nullable
    public static String calculateTestName(@NotNull GoCallExpr expression) {
        GoExpression firstArgument;
        if (expression == null) {
            GoRunUtil.$$$reportNull$$$0(20);
        }
        Value firstArgumentValue = (firstArgument = (GoExpression)ContainerUtil.getFirstItem(expression.getArgumentList().getExpressionList())) != null ? firstArgument.getValue() : null;
        return firstArgumentValue != null ? firstArgumentValue.getString() : null;
    }

    @Contract(value="!null->!null")
    @Nullable
    public static String sanitizeTestName(@Nullable String string) {
        if (string != null) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                builder.append(GoRunUtil.isWhitespace(c) ? (char)'_' : (char)c);
            }
            return builder.toString();
        }
        return null;
    }

    private static boolean isWhitespace(char c) {
        return Character.isWhitespace(c) || c == '\u0085' || c == '\u00a0' || c == '\u1680';
    }

    public static boolean hasTagsParameter(@NotNull List<String> parametersList) {
        if (parametersList == null) {
            GoRunUtil.$$$reportNull$$$0(21);
        }
        return GoRunUtil.hasParameter(parametersList, "tags");
    }

    public static boolean hasParameter(@NotNull List<String> parametersList, @NotNull String parameterName) {
        if (parametersList == null) {
            GoRunUtil.$$$reportNull$$$0(22);
        }
        if (parameterName == null) {
            GoRunUtil.$$$reportNull$$$0(23);
        }
        return ContainerUtil.find(parametersList, s -> s.startsWith("-" + parameterName + "=") || ("-" + parameterName).equals(s)) != null;
    }

    public static boolean hasParameter(@NotNull String params, @NotNull String parameterName) {
        if (params == null) {
            GoRunUtil.$$$reportNull$$$0(24);
        }
        if (parameterName == null) {
            GoRunUtil.$$$reportNull$$$0(25);
        }
        return GoRunUtil.hasParameter(ParametersListUtil.parse((String)params, (boolean)false, (boolean)true), parameterName);
    }

    @NotNull
    public static String filterOutInstallParameter(@NotNull String params) {
        if (params == null) {
            GoRunUtil.$$$reportNull$$$0(26);
        }
        return GoRunUtil.filterOutParameter(params, (Condition<String>)((Condition)p -> "-i".equals(p)));
    }

    @NotNull
    public static String filterOutInstallParameter(@NotNull List<String> parametersList) {
        if (parametersList == null) {
            GoRunUtil.$$$reportNull$$$0(27);
        }
        String string = GoRunUtil.filterOutParameter(parametersList, (Condition<String>)((Condition)p -> "-i".equals(p)));
        if (string == null) {
            GoRunUtil.$$$reportNull$$$0(28);
        }
        return string;
    }

    @NotNull
    public static String filterOutParameter(@NotNull String params, @NotNull Condition<String> filterOutCondition) {
        if (params == null) {
            GoRunUtil.$$$reportNull$$$0(29);
        }
        if (filterOutCondition == null) {
            GoRunUtil.$$$reportNull$$$0(30);
        }
        String string = GoRunUtil.filterOutParameter(ParametersListUtil.parse((String)params, (boolean)false, (boolean)true), filterOutCondition);
        if (string == null) {
            GoRunUtil.$$$reportNull$$$0(31);
        }
        return string;
    }

    public static String findParam(@NotNull String params, @NotNull Condition<? super String> paramCondition) {
        if (params == null) {
            GoRunUtil.$$$reportNull$$$0(32);
        }
        if (paramCondition == null) {
            GoRunUtil.$$$reportNull$$$0(33);
        }
        return (String)ContainerUtil.find((Iterable)ParametersListUtil.parse((String)params, (boolean)false, (boolean)true), paramCondition);
    }

    private static String filterOutParameter(@NotNull List<String> parametersList, @NotNull Condition<String> filterOutCondition) {
        if (parametersList == null) {
            GoRunUtil.$$$reportNull$$$0(34);
        }
        if (filterOutCondition == null) {
            GoRunUtil.$$$reportNull$$$0(35);
        }
        return ParametersListUtil.join((List)ContainerUtil.filter(parametersList, (Condition)Conditions.not(filterOutCondition)));
    }

    @Nullable
    public static String getRunConfigurationGOOS(@NotNull GoRunConfigurationBase<?> configuration) {
        if (configuration == null) {
            GoRunUtil.$$$reportNull$$$0(36);
        }
        return GoRunUtil.getEnvironmentVariable(configuration, "GOOS");
    }

    @Nullable
    public static String getEnvironmentVariable(@NotNull GoRunConfigurationBase<?> configuration, @NotNull String variableName) {
        if (configuration == null) {
            GoRunUtil.$$$reportNull$$$0(37);
        }
        if (variableName == null) {
            GoRunUtil.$$$reportNull$$$0(38);
        }
        Map<String, String> customEnvironment = configuration.getCustomEnvironment();
        String defaultValue = configuration.isPassParentEnvironment() ? (String)EnvironmentUtil.getEnvironmentMap().get(variableName) : null;
        return customEnvironment.getOrDefault(variableName, defaultValue);
    }

    public static boolean equalPaths(@NotNull List<VirtualFile> contextFiles, @NotNull List<String> filePaths) {
        if (contextFiles == null) {
            GoRunUtil.$$$reportNull$$$0(39);
        }
        if (filePaths == null) {
            GoRunUtil.$$$reportNull$$$0(40);
        }
        Set canonicalFilePaths = ContainerUtil.map2Set(filePaths, FileUtil::toCanonicalPath);
        return canonicalFilePaths.equals(ContainerUtil.map2Set(contextFiles, file2 -> FileUtil.toCanonicalPath((String)file2.getPresentableUrl())));
    }

    @NotNull
    public static XDebugProcessStarter createDelveXDebugStarter(final @Nullable InetSocketAddress socketAddress, final @Nullable ExecutionResult executionResult, final @NotNull DlvDisconnectOption disconnectOption, final boolean remote) {
        if (disconnectOption == null) {
            GoRunUtil.$$$reportNull$$$0(41);
        }
        return new XDebugProcessStarter(){

            @NotNull
            public XDebugProcess start(@NotNull XDebugSession session) {
                if (session == null) {
                    2.$$$reportNull$$$0(0);
                }
                XDebugProcess xDebugProcess = GoRunUtil.createDlvDebugProcess(session, executionResult, socketAddress, remote, disconnectOption);
                if (xDebugProcess == null) {
                    2.$$$reportNull$$$0(1);
                }
                return xDebugProcess;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "session";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/goide/execution/GoRunUtil$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/goide/execution/GoRunUtil$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "start";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "start";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
    }

    @NotNull
    public static XDebugProcess createDlvDebugProcess(@NotNull XDebugSession session, @Nullable ExecutionResult executionResult, @Nullable InetSocketAddress socketAddress, boolean remote, @NotNull DlvDisconnectOption disconnectOption) {
        if (session == null) {
            GoRunUtil.$$$reportNull$$$0(42);
        }
        if (disconnectOption == null) {
            GoRunUtil.$$$reportNull$$$0(43);
        }
        return GoRunUtil.createDlvDebugProcess(session, executionResult, socketAddress, remote, new DlvRemoteVmConnection(disconnectOption));
    }

    @NotNull
    public static XDebugProcess createDlvDebugProcess(@NotNull XDebugSession session, @Nullable ExecutionResult executionResult, @Nullable InetSocketAddress socketAddress, boolean remote, @NotNull DlvRemoteVmConnection connection) {
        if (session == null) {
            GoRunUtil.$$$reportNull$$$0(44);
        }
        if (connection == null) {
            GoRunUtil.$$$reportNull$$$0(45);
        }
        DlvDebugProcess process = new DlvDebugProcess(session, (VmConnection<?>)connection, executionResult, remote);
        if (socketAddress != null) {
            process.connect(socketAddress);
        }
        DlvDebugProcess dlvDebugProcess = process;
        if (dlvDebugProcess == null) {
            GoRunUtil.$$$reportNull$$$0(46);
        }
        return dlvDebugProcess;
    }

    @NotNull
    public static File localDlv() {
        return GoRunUtil.dlv(null);
    }

    @NotNull
    public static File dlv(@Nullable TargetEnvironmentRequest environmentRequest) {
        String dlvPath = System.getProperty("dlv.path");
        if (StringUtil.isNotEmpty((String)dlvPath)) {
            File dlv = new File(dlvPath);
            File file2 = dlv.isDirectory() ? GoRunUtil.dlv(dlv, environmentRequest) : dlv;
            if (file2 == null) {
                GoRunUtil.$$$reportNull$$$0(47);
            }
            return file2;
        }
        File bundledDelve = GoRunUtil.getBundledDlv(environmentRequest);
        if (bundledDelve != null) {
            File file3 = bundledDelve;
            if (file3 == null) {
                GoRunUtil.$$$reportNull$$$0(48);
            }
            return file3;
        }
        return new File(PathManager.getBinPath(), GoRunUtil.dlvExecutable(GoOsManager.isWindows()));
    }

    @Nullable
    public static File getBundledDlv(@Nullable TargetEnvironmentRequest environmentRequest) {
        IdeaPluginDescriptor plugin = GoUtil.getPlugin();
        return plugin != null ? GoRunUtil.dlv(plugin.getPluginPath().resolve("lib/dlv/").toFile(), environmentRequest) : null;
    }

    public static void showNotification(@NlsContexts.NotificationTitle @NotNull String title, @NlsContexts.NotificationContent @NotNull String text, @NotNull NotificationType type, @NotNull NotificationGroup notificationGroup, @NotNull Project project) {
        if (title == null) {
            GoRunUtil.$$$reportNull$$$0(49);
        }
        if (text == null) {
            GoRunUtil.$$$reportNull$$$0(50);
        }
        if (type == null) {
            GoRunUtil.$$$reportNull$$$0(51);
        }
        if (notificationGroup == null) {
            GoRunUtil.$$$reportNull$$$0(52);
        }
        if (project == null) {
            GoRunUtil.$$$reportNull$$$0(53);
        }
        if (project.isDisposed()) {
            return;
        }
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
        ToolWindow toolWindow = toolWindowManager.getToolWindow(notificationGroup.getToolWindowId());
        if (toolWindow != null && !toolWindow.isVisible()) {
            notificationGroup.createNotification(title, text, type).notify(project);
        }
        GoNotifications.getBuildGroup().createNotification(title, text, type).notify(project);
        SystemNotifications.getInstance().notify(notificationGroup.getDisplayId(), title, text);
    }

    @Nullable
    public static String getTargetPlatform(@Nullable TargetEnvironmentRequest executionTarget) {
        if (executionTarget != null && !(executionTarget instanceof GoLocalEnvironmentRequest)) {
            TargetPlatform platform = executionTarget.getTargetPlatform();
            return platform.getPlatform() == Platform.WINDOWS ? "windows" : "linux";
        }
        return GoRunUtil.getLocalTargetPlatform();
    }

    @Nullable
    public static String getTargetArch(@Nullable TargetEnvironmentRequest executionTarget) {
        if (executionTarget != null && !(executionTarget instanceof GoLocalEnvironmentRequest)) {
            return Optional.ofNullable(executionTarget.getConfiguration()).map(targetConfig -> (GoLanguageRuntimeConfiguration)targetConfig.getRuntimes().findByType(GoLanguageRuntimeConfiguration.class)).map(goConfig -> goConfig.getGoVersion()).map(goVersion -> (String)ContainerUtil.getLastItem((List)StringUtil.split((String)goVersion, (String)" "))).map(osAndArch -> (String)ContainerUtil.getLastItem((List)StringUtil.split((String)osAndArch, (String)"/"))).filter(arch -> GoConstants.KNOWN_ARCH.contains(arch)).orElse(null);
        }
        return GoUtil.systemArch();
    }

    public static boolean isTargetMuslBased(@Nullable TargetEnvironmentRequest executionTarget) {
        if (executionTarget != null && !(executionTarget instanceof GoLocalEnvironmentRequest)) {
            return Optional.ofNullable(executionTarget.getConfiguration()).map(targetConfig -> (GoLanguageRuntimeConfiguration)targetConfig.getRuntimes().findByType(GoLanguageRuntimeConfiguration.class)).map(GoLanguageRuntimeConfiguration::isMusl).orElse(false);
        }
        return false;
    }

    @Nullable
    public static String getLocalTargetPlatform() {
        if (GoOsManager.isWindows()) {
            return "windows";
        }
        if (GoOsManager.isMac()) {
            return "darwin";
        }
        if (GoOsManager.isLinux()) {
            return "linux";
        }
        return null;
    }

    @NotNull
    private static File dlv(@NotNull File directory, @Nullable TargetEnvironmentRequest environmentRequest) {
        Object directoryName;
        if (directory == null) {
            GoRunUtil.$$$reportNull$$$0(54);
        }
        String targetPlatform = GoRunUtil.getTargetPlatform(environmentRequest);
        String targetArch = GoRunUtil.getTargetArch(environmentRequest);
        boolean targetMuslBased = GoRunUtil.isTargetMuslBased(environmentRequest);
        if ("darwin".equalsIgnoreCase(targetPlatform)) {
            directoryName = "arm64".equals(targetArch) ? "macarm" : "mac";
        } else if ("linux".equalsIgnoreCase(targetPlatform)) {
            Object object = directoryName = "arm64".equals(targetArch) ? "linuxarm" : "linux";
            if (targetMuslBased) {
                directoryName = (String)directoryName + "musl";
            }
        } else {
            directoryName = "windows".equalsIgnoreCase(targetPlatform) ? ("arm64".equals(targetArch) ? "windowsarm" : "windows") : "linux";
        }
        return new File(directory, (String)directoryName + "/" + GoRunUtil.dlvExecutable("windows".equalsIgnoreCase(targetPlatform)));
    }

    @NotNull
    @NonNls
    private static String dlvExecutable(boolean windows) {
        String string = "dlv" + (windows ? ".exe" : "");
        if (string == null) {
            GoRunUtil.$$$reportNull$$$0(55);
        }
        return string;
    }

    public static InetAddress resolveLocalAddress(boolean preferIpv6) throws UnknownHostException {
        Object[] addresses = InetAddress.getAllByName("localhost");
        InetAddress firstAddress = addresses[0];
        if (addresses.length == 1 || !preferIpv6) {
            return firstAddress;
        }
        return StreamEx.of((Object[])addresses).findFirst(Inet6Address.class::isInstance).orElse(firstAddress);
    }

    @NotNull
    public static <T> Promise<T> executeOnPooledThread(@NotNull Callable<? extends T> c) {
        if (c == null) {
            GoRunUtil.$$$reportNull$$$0(56);
        }
        AsyncPromise result = new AsyncPromise();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                result.setResult(c.call());
            }
            catch (Throwable t) {
                result.setError(t);
            }
        });
        AsyncPromise asyncPromise = result;
        if (asyncPromise == null) {
            GoRunUtil.$$$reportNull$$$0(57);
        }
        return asyncPromise;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 14, 17, 28, 31, 46, 47, 48, 55, 57 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 10: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chooserDescriptor";
                break;
            }
            case 9: 
            case 14: 
            case 17: 
            case 28: 
            case 31: 
            case 46: 
            case 47: 
            case 48: 
            case 55: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/execution/GoRunUtil";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testIndices";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 21: 
            case 22: 
            case 27: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametersList";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterName";
                break;
            }
            case 24: 
            case 26: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 30: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterOutCondition";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramCondition";
                break;
            }
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableName";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFiles";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
            case 41: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disconnectOption";
                break;
            }
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationGroup";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/execution/GoRunUtil";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createMultipleFileField";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubTests";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubTestsInner";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "filterOutInstallParameter";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "filterOutParameter";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "createDlvDebugProcess";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "dlv";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "dlvExecutable";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "executeOnPooledThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "installDirectoryChooser";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "installFileChooser";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createMultipleFileField";
                break;
            }
            case 9: 
            case 14: 
            case 17: 
            case 28: 
            case 31: 
            case 46: 
            case 47: 
            case 48: 
            case 55: 
            case 57: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "printGoEnvVariables";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSubTests";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isRunTestCall";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getSubTestsInner";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "uniqueTestName";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "calculateTestName";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "hasTagsParameter";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "hasParameter";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "filterOutInstallParameter";
                break;
            }
            case 29: 
            case 30: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "filterOutParameter";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "findParam";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getRunConfigurationGOOS";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getEnvironmentVariable";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "equalPaths";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "createDelveXDebugStarter";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "createDlvDebugProcess";
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "showNotification";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "dlv";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "executeOnPooledThread";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 14, 17, 28, 31, 46, 47, 48, 55, 57 -> new IllegalStateException(string);
        };
    }
}

