/*
 * Decompiled with CFR 0.152.
 */
package com.goide.execution;

import com.goide.statistics.errors.GoProgrammingErrorsStatisticsCollector;
import com.google.common.collect.EvictingQueue;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GoRuntimeErrorsListener
extends ProcessAdapter {
    private final OutputQueue myOutput;
    private final Project myProject;

    public GoRuntimeErrorsListener(@NotNull Project project, boolean onlyStderr) {
        if (project == null) {
            GoRuntimeErrorsListener.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myOutput = new OutputQueue(onlyStderr);
    }

    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
        if (event == null) {
            GoRuntimeErrorsListener.$$$reportNull$$$0(1);
        }
        if (outputType == null) {
            GoRuntimeErrorsListener.$$$reportNull$$$0(2);
        }
        this.myOutput.push(event, outputType);
    }

    public void processTerminated(@NotNull ProcessEvent event) {
        if (event == null) {
            GoRuntimeErrorsListener.$$$reportNull$$$0(3);
        }
        if (event.getExitCode() == 0 || this.myProject.isDisposed()) {
            return;
        }
        GoProgrammingErrorsStatisticsCollector.reportRuntimeErrors(this.myProject, this.myOutput.popAll());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
        }
        objectArray2[1] = "com/goide/execution/GoRuntimeErrorsListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "onTextAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processTerminated";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class OutputQueue {
        private final EvictingQueue<String> myOutput = EvictingQueue.create((int)100);
        private final Object myLock = new Object();
        private final boolean myOnlyStderr;

        OutputQueue(boolean onlyStderr) {
            this.myOnlyStderr = onlyStderr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void push(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
            String text;
            if (event == null) {
                OutputQueue.$$$reportNull$$$0(0);
            }
            if (outputType == null) {
                OutputQueue.$$$reportNull$$$0(1);
            }
            if (!((text = event.getText()) == null || this.myOnlyStderr && outputType != ProcessOutputTypes.STDERR)) {
                Object object = this.myLock;
                synchronized (object) {
                    this.myOutput.add((Object)text);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        List<String> popAll() {
            ArrayList<String> output2;
            Object object = this.myLock;
            synchronized (object) {
                output2 = new ArrayList<String>((Collection<String>)this.myOutput);
                this.myOutput.clear();
            }
            ArrayList<String> arrayList = output2;
            if (arrayList == null) {
                OutputQueue.$$$reportNull$$$0(2);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/execution/GoRuntimeErrorsListener$OutputQueue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/execution/GoRuntimeErrorsListener$OutputQueue";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "popAll";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "push";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

