/*
 * Decompiled with CFR 0.152.
 */
package com.goide.execution;

import com.goide.i18n.GoBundle;
import com.goide.project.GoBuildTargetSettings;
import com.goide.sdk.GoSdk;
import com.goide.sdk.download.GoBasedDownloadingSdk;
import com.intellij.execution.Platform;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslPath;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoWslUtil {
    @Nullable
    public static WSLDistribution getWsl(@Nullable GoSdk sdk) {
        VirtualFile sdkRoot = sdk != null ? sdk.getSdkRoot() : null;
        return sdkRoot != null ? WslPath.getDistributionByWindowsUncPath((String)sdkRoot.getPath()) : null;
    }

    public static boolean isInWsl(@NotNull GoSdk sdk) {
        if (sdk == null) {
            GoWslUtil.$$$reportNull$$$0(0);
        }
        return GoWslUtil.isInWsl(sdk.getSdkRoot());
    }

    public static boolean isInWsl(@Nullable VirtualFile file2) {
        return file2 != null && WslPath.isWslUncPath((String)file2.getPath());
    }

    public static boolean hasSourcesInWsl(@NotNull Module module) {
        VirtualFile[] contentRoots;
        if (module == null) {
            GoWslUtil.$$$reportNull$$$0(1);
        }
        if (module.isDisposed()) {
            return false;
        }
        for (VirtualFile root : contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            if (!GoWslUtil.isInWsl(root)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static WSLDistribution getWsl(@Nullable Project project) {
        return project != null ? GoWslUtil.getWsl(project.getBasePath()) : null;
    }

    @Nullable
    public static WSLDistribution getWsl(@Nullable String path) {
        return path != null ? WslPath.getDistributionByWindowsUncPath((String)path) : null;
    }

    @Nullable
    public static WSLDistribution getWsl(@Nullable Module module) {
        VirtualFile[] contentRoots;
        if (module == null || module.isDisposed()) {
            return null;
        }
        HashSet result = new HashSet();
        for (VirtualFile root : contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            WSLDistribution wsl = WslPath.getDistributionByWindowsUncPath((String)root.getPath());
            ContainerUtil.addIfNotNull(result, (Object)wsl);
        }
        return (WSLDistribution)ContainerUtil.getOnlyItem(result);
    }

    @NotNull
    public static List<String> getGoPathUrls(@NotNull WSLDistribution wsl) {
        String userHome;
        Map environment;
        if (wsl == null) {
            GoWslUtil.$$$reportNull$$$0(2);
        }
        String wslGoPath = (String)ObjectUtils.notNull((environment = wsl.getEnvironment()) != null ? (String)environment.get("GOPATH") : null, (Object)"");
        ArrayList<String> result = new ArrayList<String>();
        for (String entry : StringUtil.split((String)wslGoPath, (String)":")) {
            result.add(GoWslUtil.getWindowsURL(wsl, entry));
        }
        if (result.isEmpty() && (userHome = wsl.getUserHome()) != null) {
            result.add(GoWslUtil.getWindowsURL(wsl, userHome + "/go"));
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            GoWslUtil.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    private static String getWindowsURL(@NotNull WSLDistribution wsl, @NotNull String pathInWsl) {
        if (wsl == null) {
            GoWslUtil.$$$reportNull$$$0(4);
        }
        if (pathInWsl == null) {
            GoWslUtil.$$$reportNull$$$0(5);
        }
        String string = VfsUtilCore.pathToUrl((String)wsl.getWindowsPath(pathInWsl));
        if (string == null) {
            GoWslUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public static GoBuildTargetSettings getWslBuildTargetSettings() {
        GoBuildTargetSettings result = new GoBuildTargetSettings();
        result.os = "linux";
        GoBuildTargetSettings goBuildTargetSettings = result;
        if (goBuildTargetSettings == null) {
            GoWslUtil.$$$reportNull$$$0(7);
        }
        return goBuildTargetSettings;
    }

    @Nullable
    @Nls
    public static String getWslValidationError(@Nullable GoSdk sdk, @Nullable Project project) {
        return GoWslUtil.getWslValidationError(sdk, project != null ? project.getBasePath() : null);
    }

    @Nullable
    @Nls
    public static String getWslValidationError(@Nullable GoSdk sdk, @Nullable String projectPath) {
        WSLDistribution sdkWsl;
        if (!SystemInfo.isWindows || projectPath == null || sdk == null || !sdk.isValid() || sdk instanceof GoBasedDownloadingSdk) {
            return null;
        }
        WSLDistribution projectWsl = GoWslUtil.getWsl(projectPath);
        if (Objects.equals(projectWsl, sdkWsl = GoWslUtil.getWsl(sdk))) {
            return null;
        }
        if (sdkWsl == null) {
            return GoBundle.message((String)"go.error.wsl.project.requires.wsl.sdk", (Object[])new Object[0]);
        }
        if (projectWsl == null) {
            return GoBundle.message((String)"go.error.wsl.sdk.cannot.be.used.for.windows.project", (Object[])new Object[0]);
        }
        return GoBundle.message((String)"go.error.wsl.project.requires.wsl.sdk.from.same.instance", (Object[])new Object[0]);
    }

    @Nullable
    public static String computeWslUserHomeWithProgress(final @Nullable WSLDistribution wsl) {
        String title = GoBundle.message((String)"go.wsl.resolving.user.home", (Object[])new Object[0]);
        return wsl != null ? (String)ProgressManager.getInstance().run((Task.WithResult)new Task.WithResult<String, RuntimeException>(null, title, true){

            @Nullable
            protected String compute(@NotNull ProgressIndicator indicator) throws RuntimeException {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                return wsl.getUserHome();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/goide/execution/GoWslUtil$1", "compute"));
            }
        }) : null;
    }

    public static boolean isAbsoluteWslPath(@Nullable String path) {
        return path != null && path.startsWith(String.valueOf(Platform.UNIX.fileSeparator));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wsl";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/execution/GoWslUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathInWsl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/execution/GoWslUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGoPathUrls";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getWindowsURL";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getWslBuildTargetSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isInWsl";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasSourcesInWsl";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getGoPathUrls";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getWindowsURL";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 6, 7 -> new IllegalStateException(string);
        };
    }
}

