/*
 * Decompiled with CFR 0.152.
 */
package com.goide.execution.application;

import com.goide.execution.GoBuildingRunConfiguration;
import com.goide.execution.GoConfigurationFactoryBase;
import com.goide.execution.GoRunConfigurationProducerBase;
import com.goide.execution.GoRunUtil;
import com.goide.execution.application.GoApplicationConfiguration;
import com.goide.execution.application.GoApplicationRunConfigurationType;
import com.goide.execution.testing.GoTestFinder;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionDeclaration;
import com.goide.sdk.GoPackageUtil;
import com.goide.sdk.GoSdkService;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoApplicationRunConfigurationProducer
extends GoRunConfigurationProducerBase<GoApplicationConfiguration>
implements DumbAware {
    protected boolean setupConfigurationFromContext(@NotNull GoApplicationConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        PsiElement contextElement;
        PsiFile contextFile;
        List<VirtualFile> files;
        if (configuration == null) {
            GoApplicationRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        if (context == null) {
            GoApplicationRunConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (sourceElement == null) {
            GoApplicationRunConfigurationProducer.$$$reportNull$$$0(2);
        }
        if ((files = this.getFilesFromContext(context, contextFile = (contextElement = this.getContextElement(context)) != null ? contextElement.getContainingFile() : null)).size() <= 1 && GoTestFinder.isTestFile(contextFile)) {
            return false;
        }
        Module module = this.findModule(contextFile, context);
        if (module == null) {
            return false;
        }
        this.prepareConfigurationFromContext(configuration, module);
        String importPath = GoApplicationRunConfigurationProducer.getImportPathFromContext(contextElement);
        configuration.setFilePaths(ContainerUtil.map(files, VirtualFile::getPath));
        if (StringUtil.isNotEmpty((String)importPath)) {
            configuration.setKind(GoBuildingRunConfiguration.Kind.PACKAGE);
            configuration.setPackage(importPath);
            configuration.setGeneratedName();
            return true;
        }
        if (contextElement instanceof PsiDirectory) {
            VirtualFile file2 = ((PsiDirectory)contextElement).getVirtualFile();
            configuration.setKind(GoBuildingRunConfiguration.Kind.DIRECTORY);
            configuration.setDirectoryPath(file2.getPath());
            configuration.setGeneratedName();
            return true;
        }
        if (!files.isEmpty() && GoSdkService.getInstance(context.getProject()).isGoModule(module)) {
            configuration.setModule(module);
            configuration.setKind(GoBuildingRunConfiguration.Kind.FILE);
            configuration.setGeneratedName();
            return true;
        }
        return false;
    }

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        GoConfigurationFactoryBase goConfigurationFactoryBase = GoApplicationRunConfigurationType.getInstance().getFactory();
        if (goConfigurationFactoryBase == null) {
            GoApplicationRunConfigurationProducer.$$$reportNull$$$0(3);
        }
        return goConfigurationFactoryBase;
    }

    @Nullable
    private static String getImportPathFromContext(@Nullable PsiElement contextElement) {
        if (contextElement == null) {
            return null;
        }
        if (GoApplicationRunConfigurationProducer.isPackageContext(contextElement) || GoApplicationRunConfigurationProducer.isMainFunctionContext(contextElement)) {
            PsiFile file2 = contextElement.getContainingFile();
            if (file2 instanceof GoFile) {
                return ((GoFile)file2).getImportPath(false);
            }
        } else if (contextElement instanceof PsiDirectory) {
            return GoPackageUtil.findFirstImportPath((PsiDirectory)contextElement, false);
        }
        return null;
    }

    private static boolean isMainFunctionContext(@Nullable PsiElement contextElement) {
        if (contextElement == null) {
            return false;
        }
        PsiFile file2 = contextElement.getContainingFile();
        if (!(file2 instanceof GoFile) || !file2.isValid() || ScratchUtil.isScratch((VirtualFile)file2.getVirtualFile()) || GoTestFinder.isTestFile(file2)) {
            return false;
        }
        if (!"main".equals(((GoFile)file2).getPackageName())) {
            return false;
        }
        GoFunctionDeclaration function = (GoFunctionDeclaration)PsiTreeUtil.getNonStrictParentOfType((PsiElement)contextElement, (Class[])new Class[]{GoFunctionDeclaration.class});
        return function != null && "main".equals(function.getName());
    }

    public boolean isConfigurationFromContext(@NotNull GoApplicationConfiguration configuration, @NotNull ConfigurationContext context) {
        PsiElement contextElement;
        if (configuration == null) {
            GoApplicationRunConfigurationProducer.$$$reportNull$$$0(4);
        }
        if (context == null) {
            GoApplicationRunConfigurationProducer.$$$reportNull$$$0(5);
        }
        if (!this.isConfigurationFromTheSameModule(configuration, contextElement = this.getContextElement(context))) {
            return false;
        }
        return switch (configuration.getKind()) {
            default -> throw new MatchException(null, null);
            case GoBuildingRunConfiguration.Kind.PACKAGE -> configuration.getPackage().equals(GoApplicationRunConfigurationProducer.getImportPathFromContext(contextElement));
            case GoBuildingRunConfiguration.Kind.DIRECTORY -> {
                if (contextElement instanceof PsiDirectory && FileUtil.pathsEqual((String)configuration.getDirectoryPath(), (String)((PsiDirectory)contextElement).getVirtualFile().getPath())) {
                    yield true;
                }
                yield false;
            }
            case GoBuildingRunConfiguration.Kind.FILE -> {
                List<VirtualFile> contextFilePaths = this.getFilesFromContext(context, contextElement.getContainingFile());
                if (contextFilePaths.isEmpty()) {
                    yield false;
                }
                yield GoRunUtil.equalPaths(contextFilePaths, configuration.getFilePaths());
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/execution/application/GoApplicationRunConfigurationProducer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/execution/application/GoApplicationRunConfigurationProducer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromContext";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationFromContext";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

