/*
 * Decompiled with CFR 0.152.
 */
package com.goide.execution.testing;

import com.goide.execution.GoBuildingRunConfiguration;
import com.goide.execution.GoRunConfigurationProducerBase;
import com.goide.execution.GoRunUtil;
import com.goide.execution.testing.GoTestConfigurationFactoryBase;
import com.goide.execution.testing.GoTestFinder;
import com.goide.execution.testing.GoTestFramework;
import com.goide.execution.testing.GoTestFunctionType;
import com.goide.execution.testing.GoTestRunConfiguration;
import com.goide.execution.testing.GoTestRunConfigurationType;
import com.goide.execution.testing.GoTestRunningState;
import com.goide.execution.testing.frameworks.gofuzz.GoFuzzFramework;
import com.goide.execution.testing.frameworks.gofuzz.GoFuzzTestDataDirectoryHierarchy;
import com.goide.execution.testing.frameworks.gofuzz.corpus.GoFuzzCorpusFile;
import com.goide.execution.testing.table.GoTableTestUtil;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionDeclaration;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.impl.GoPackage;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GoTestRunConfigurationProducerBase
extends GoRunConfigurationProducerBase<GoTestRunConfiguration> {
    @NotNull
    private final GoTestFramework myFramework;

    protected GoTestRunConfigurationProducerBase(@NotNull GoTestFramework framework) {
        if (framework == null) {
            GoTestRunConfigurationProducerBase.$$$reportNull$$$0(0);
        }
        this.myFramework = framework;
    }

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        GoTestConfigurationFactoryBase goTestConfigurationFactoryBase = GoTestRunConfigurationType.getInstance().getFactory();
        if (goTestConfigurationFactoryBase == null) {
            GoTestRunConfigurationProducerBase.$$$reportNull$$$0(1);
        }
        return goTestConfigurationFactoryBase;
    }

    @Nullable
    public static List<String> getTestPathFromContext(@NotNull ConfigurationContext context) {
        SMTestProxy test;
        if (context == null) {
            GoTestRunConfigurationProducerBase.$$$reportNull$$$0(2);
        }
        if ((test = (SMTestProxy)ObjectUtils.tryCast((Object)context.getDataContext().getData(AbstractTestProxy.DATA_KEY), SMTestProxy.class)) == null || test.getName() == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add(test.getName());
        for (SMTestProxy parent = test.getParent(); parent != null && !(parent instanceof SMTestProxy.SMRootTestProxy) && !parent.isSuite(); parent = parent.getParent()) {
            result.add(parent.getName());
        }
        Collections.reverse(result);
        return result;
    }

    @Nullable
    protected String getTestPatternFromContext(@NotNull ConfigurationContext context) {
        if (context == null) {
            GoTestRunConfigurationProducerBase.$$$reportNull$$$0(3);
        }
        return null;
    }

    protected boolean setupConfigurationFromContext(@NotNull GoTestRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref sourceElement) {
        PsiElement contextElement;
        if (configuration == null) {
            GoTestRunConfigurationProducerBase.$$$reportNull$$$0(4);
        }
        if (context == null) {
            GoTestRunConfigurationProducerBase.$$$reportNull$$$0(5);
        }
        if (sourceElement == null) {
            GoTestRunConfigurationProducerBase.$$$reportNull$$$0(6);
        }
        if ((contextElement = this.getContextElement(context)) == null) {
            return false;
        }
        PsiFile file2 = contextElement.getContainingFile();
        Module module = this.findModule(file2, context);
        if (module == null || !this.myFramework.isAvailable(module)) {
            return false;
        }
        List<VirtualFile> files = this.getFilesFromContext(context, contextElement.getContainingFile());
        this.prepareConfigurationFromContext(configuration, module);
        configuration.setTestFramework(this.myFramework);
        if (files.isEmpty() && contextElement instanceof PsiDirectory) {
            configuration.setKind(GoBuildingRunConfiguration.Kind.DIRECTORY);
            String directoryPath = ((PsiDirectory)contextElement).getVirtualFile().getPath();
            configuration.setDirectoryPath(directoryPath);
            configuration.setWorkingDirectory(directoryPath);
            configuration.setGoToolParams(GoRunUtil.filterOutInstallParameter(configuration.getGoToolParams()));
            configuration.setGeneratedName();
            return true;
        }
        Project project = contextElement.getProject();
        if (file2 instanceof GoFile && this.isAvailableOnFiles(project, files)) {
            String importPath = ((GoFile)file2).getImportPath(false);
            VirtualFile parent = file2.getVirtualFile().getParent();
            if (parent != null) {
                configuration.setWorkingDirectory(parent.getPath());
            }
            if (this.doSetupConfigurationFromContext(configuration, context, contextElement)) {
                return true;
            }
            if (files.size() <= 1 && GoTestRunConfigurationProducerBase.isPackageContext(contextElement) && StringUtil.isNotEmpty((String)importPath) && this.myFramework != GoFuzzFramework.INSTANCE) {
                configuration.setKind(GoBuildingRunConfiguration.Kind.PACKAGE);
                configuration.setPackage(importPath);
                configuration.setGeneratedName();
                return true;
            }
            GoFunctionOrMethodDeclaration function = GoTestFinder.findTestFunctionInContext(contextElement);
            if (function != null) {
                String functionName = function.getName();
                if (GoTestRunConfigurationProducerBase.isExampleWithoutOutput(function)) {
                    return false;
                }
                if (this.myFramework.isAvailableOnFunction(function) && functionName != null) {
                    String pattern = this.getTestPatternFromContext(context);
                    if (pattern != null) {
                        configuration.setPattern(pattern);
                    } else {
                        String subTestName = GoTestRunConfigurationProducerBase.findSubTestInContext(contextElement, function);
                        if (subTestName != null) {
                            configuration.setPattern(GoTestRunConfigurationProducerBase.createPatternFromFullTestName(subTestName));
                        } else {
                            configuration.setTestNamePrefix(this.getTestNamePrefix(function, file2.getName()));
                            configuration.setPattern(GoTestRunConfigurationProducerBase.createPatternFromFullTestName(functionName));
                        }
                    }
                    if (this.myFramework == GoFuzzFramework.INSTANCE && StringUtil.isNotEmpty((String)importPath) && parent != null && !ScratchUtil.isScratch((VirtualFile)file2.getVirtualFile())) {
                        configuration.setKind(GoBuildingRunConfiguration.Kind.DIRECTORY);
                        configuration.setPackage(importPath);
                        configuration.setDirectoryPath(parent.getPath());
                    } else if (StringUtil.isNotEmpty((String)importPath)) {
                        configuration.setKind(GoBuildingRunConfiguration.Kind.PACKAGE);
                        configuration.setPackage(importPath);
                    } else if (Registry.is((String)"go.enforce.directory.run.kind.for.tests.enabled") && parent != null && !ScratchUtil.isScratch((VirtualFile)file2.getVirtualFile())) {
                        configuration.setKind(GoBuildingRunConfiguration.Kind.DIRECTORY);
                        configuration.setDirectoryPath(parent.getPath());
                    } else {
                        configuration.setKind(GoBuildingRunConfiguration.Kind.FILE);
                        configuration.setFilePaths(ContainerUtil.map(files, VirtualFile::getPath));
                    }
                    configuration.setGeneratedName();
                    return true;
                }
            } else if (this.hasSupportedFunctions(project, files) && this.myFramework != GoFuzzFramework.INSTANCE) {
                configuration.setKind(GoBuildingRunConfiguration.Kind.FILE);
                configuration.setFilePaths(ContainerUtil.map(files, VirtualFile::getPath));
                configuration.setGeneratedName();
                return true;
            }
        }
        if (file2 instanceof GoFuzzCorpusFile && this.isAvailableOnFiles(project, files)) {
            VirtualFile corpusFile = file2.getVirtualFile();
            GoFuzzTestDataDirectoryHierarchy hierarchy = GoFuzzTestDataDirectoryHierarchy.create(corpusFile);
            if (hierarchy == null) {
                return false;
            }
            configuration.setPattern(hierarchy.getFuzzFuncNameDir().getName() + "/" + corpusFile.getName());
            String packageDirPath = hierarchy.getPackageDir().getPath();
            String packageName = GoTestRunConfigurationProducerBase.getPackageNameForTestFunction(project, hierarchy.getPackageDir(), hierarchy.getFuzzFuncNameDir().getName());
            if (packageName != null) {
                configuration.setKind(GoBuildingRunConfiguration.Kind.PACKAGE);
                configuration.setPackage(packageName);
            } else {
                configuration.setKind(GoBuildingRunConfiguration.Kind.DIRECTORY);
                configuration.setDirectoryPath(packageDirPath);
            }
            configuration.setWorkingDirectory(packageDirPath);
            configuration.setGoToolParams(GoRunUtil.filterOutInstallParameter(configuration.getGoToolParams()));
            configuration.setGeneratedName();
            return true;
        }
        return false;
    }

    @Nullable
    private static String getPackageNameForTestFunction(@NotNull Project project, @NotNull VirtualFile packageDir, @NotNull String fuzzFuncName) {
        if (project == null) {
            GoTestRunConfigurationProducerBase.$$$reportNull$$$0(7);
        }
        if (packageDir == null) {
            GoTestRunConfigurationProducerBase.$$$reportNull$$$0(8);
        }
        if (fuzzFuncName == null) {
            GoTestRunConfigurationProducerBase.$$$reportNull$$$0(9);
        }
        for (GoPackage pkg : GoPackage.in(PsiManager.getInstance((Project)project).findDirectory(packageDir))) {
            for (PsiFile file2 : pkg.files()) {
                GoFile goFile;
                if (!GoTestFinder.isTestFile(file2) || (goFile = (GoFile)file2).getFunctions(fuzzFuncName).isEmpty()) continue;
                return pkg.getImportPath(false);
            }
        }
        return null;
    }

    protected boolean doSetupConfigurationFromContext(@NotNull GoTestRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull PsiElement contextElement) {
        if (configuration == null) {
            GoTestRunConfigurationProducerBase.$$$reportNull$$$0(10);
        }
        if (context == null) {
            GoTestRunConfigurationProducerBase.$$$reportNull$$$0(11);
        }
        if (contextElement == null) {
            GoTestRunConfigurationProducerBase.$$$reportNull$$$0(12);
        }
        return false;
    }

    private boolean isAvailableOnFiles(@NotNull Project project, @NotNull List<VirtualFile> filesFromContext) {
        if (project == null) {
            GoTestRunConfigurationProducerBase.$$$reportNull$$$0(13);
        }
        if (filesFromContext == null) {
            GoTestRunConfigurationProducerBase.$$$reportNull$$$0(14);
        }
        PsiManager manager = PsiManager.getInstance((Project)project);
        for (VirtualFile file2 : filesFromContext) {
            PsiFile psiFile = manager.findFile(file2);
            if (!this.myFramework.isAvailableOnFile(psiFile)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected String getTestNamePrefix(@NotNull GoFunctionOrMethodDeclaration function, @NotNull String fileName) {
        if (function == null) {
            GoTestRunConfigurationProducerBase.$$$reportNull$$$0(15);
        }
        if (fileName == null) {
            GoTestRunConfigurationProducerBase.$$$reportNull$$$0(16);
        }
        return "";
    }

    public boolean isConfigurationFromContext(@NotNull GoTestRunConfiguration configuration, @NotNull ConfigurationContext context) {
        VirtualFile parent;
        PsiElement contextElement;
        if (configuration == null) {
            GoTestRunConfigurationProducerBase.$$$reportNull$$$0(17);
        }
        if (context == null) {
            GoTestRunConfigurationProducerBase.$$$reportNull$$$0(18);
        }
        if (!this.isConfigurationFromTheSameModule(configuration, contextElement = this.getContextElement(context))) {
            return false;
        }
        if (!Comparing.equal((Object)this.myFramework, (Object)configuration.getTestFramework())) {
            return false;
        }
        PsiFile file2 = contextElement.getContainingFile();
        if (file2 != null && !this.isAvailableOnFile(file2)) {
            return false;
        }
        List<VirtualFile> filesFromContext = this.getFilesFromContext(context, file2);
        VirtualFile virtualFile = file2 == null ? null : file2.getVirtualFile();
        VirtualFile virtualFile2 = parent = virtualFile != null ? virtualFile.getParent() : null;
        if (filesFromContext.size() > 1) {
            return this.isFileTypeConfigurationFromContext(configuration, contextElement, filesFromContext, file2, parent, context);
        }
        switch (configuration.getKind()) {
            case DIRECTORY: {
                if (contextElement instanceof PsiDirectory) {
                    if (!configuration.getPattern().isEmpty()) {
                        return this.isConfigurationFromContext(configuration, contextElement, context, true);
                    }
                    String directoryPath = ((PsiDirectory)contextElement).getVirtualFile().getPath();
                    return FileUtil.pathsEqual((String)configuration.getDirectoryPath(), (String)directoryPath) && FileUtil.pathsEqual((String)configuration.getWorkingDirectory(), (String)directoryPath);
                }
            }
            case PACKAGE: {
                return this.isPackageTypeConfigurationFromContext(configuration, contextElement, file2, parent, context);
            }
            case FILE: {
                return this.isFileTypeConfigurationFromContext(configuration, contextElement, filesFromContext, file2, parent, context);
            }
        }
        return false;
    }

    private boolean isPackageTypeConfigurationFromContext(@NotNull GoTestRunConfiguration configuration, @NotNull PsiElement contextElement, @Nullable PsiFile file2, @Nullable VirtualFile parent, @NotNull ConfigurationContext context) {
        if (configuration == null) {
            GoTestRunConfigurationProducerBase.$$$reportNull$$$0(19);
        }
        if (contextElement == null) {
            GoTestRunConfigurationProducerBase.$$$reportNull$$$0(20);
        }
        if (context == null) {
            GoTestRunConfigurationProducerBase.$$$reportNull$$$0(21);
        }
        if (!GoTestFinder.isTestFile(file2)) {
            return false;
        }
        if (!configuration.getPackage().equals(((GoFile)file2).getImportPath(false))) {
            return false;
        }
        if (parent != null && !parent.getPath().equals(configuration.getWorkingDirectory())) {
            return false;
        }
        if (GoTestRunConfigurationProducerBase.isPackageContext(contextElement) && this.isConfigurationWithoutContext(configuration)) {
            return true;
        }
        return this.isConfigurationFromContext(configuration, contextElement, context, true);
    }

    protected boolean isConfigurationWithoutContext(@NotNull GoTestRunConfiguration configuration) {
        if (configuration == null) {
            GoTestRunConfigurationProducerBase.$$$reportNull$$$0(22);
        }
        return configuration.getPattern().isEmpty();
    }

    private boolean isFileTypeConfigurationFromContext(@NotNull GoTestRunConfiguration configuration, @NotNull PsiElement contextElement, @NotNull List<VirtualFile> filesFromContext, @Nullable PsiFile file2, @Nullable VirtualFile parent, @NotNull ConfigurationContext context) {
        if (configuration == null) {
            GoTestRunConfigurationProducerBase.$$$reportNull$$$0(23);
        }
        if (contextElement == null) {
            GoTestRunConfigurationProducerBase.$$$reportNull$$$0(24);
        }
        if (filesFromContext == null) {
            GoTestRunConfigurationProducerBase.$$$reportNull$$$0(25);
        }
        if (context == null) {
            GoTestRunConfigurationProducerBase.$$$reportNull$$$0(26);
        }
        if (file2 == null) {
            return false;
        }
        if (parent != null && !configuration.getWorkingDirectory().equals(GoTestRunConfigurationProducerBase.getWorkingDirectory(file2, parent))) {
            return false;
        }
        if (!GoRunUtil.equalPaths(filesFromContext, configuration.getFilePaths())) {
            return false;
        }
        return this.isConfigurationFromContext(configuration, contextElement, context, false);
    }

    @Nullable
    private static String getWorkingDirectory(@NotNull PsiFile file2, @NotNull VirtualFile parent) {
        if (file2 == null) {
            GoTestRunConfigurationProducerBase.$$$reportNull$$$0(27);
        }
        if (parent == null) {
            GoTestRunConfigurationProducerBase.$$$reportNull$$$0(28);
        }
        if (file2 instanceof GoFuzzCorpusFile) {
            GoFuzzTestDataDirectoryHierarchy hierarchy = GoFuzzTestDataDirectoryHierarchy.create(file2.getVirtualFile());
            return hierarchy != null ? hierarchy.getPackageDir().getPath() : null;
        }
        return parent.getPath();
    }

    protected boolean isConfigurationFromContext(@NotNull GoTestRunConfiguration configuration, @NotNull PsiElement contextElement, @NotNull ConfigurationContext context, boolean requireContext) {
        GoFunctionOrMethodDeclaration contextTestFunction;
        if (configuration == null) {
            GoTestRunConfigurationProducerBase.$$$reportNull$$$0(29);
        }
        if (contextElement == null) {
            GoTestRunConfigurationProducerBase.$$$reportNull$$$0(30);
        }
        if (context == null) {
            GoTestRunConfigurationProducerBase.$$$reportNull$$$0(31);
        }
        if (GoTestRunConfigurationProducerBase.isExampleWithoutOutput(contextTestFunction = GoTestFinder.findTestFunctionInContext(contextElement))) {
            return false;
        }
        if (!requireContext && contextTestFunction == null && this.myFramework.isAvailableOnFile(contextElement.getContainingFile()) || this.myFramework.isAvailableOnFunction(contextTestFunction)) {
            return GoTestRunConfigurationProducerBase.matchFunctionPattern(configuration, contextElement, contextTestFunction);
        }
        return false;
    }

    private static boolean matchFunctionPattern(@NotNull GoTestRunConfiguration configuration, @NotNull PsiElement contextElement, @Nullable GoFunctionOrMethodDeclaration contextFunction) {
        if (configuration == null) {
            GoTestRunConfigurationProducerBase.$$$reportNull$$$0(32);
        }
        if (contextElement == null) {
            GoTestRunConfigurationProducerBase.$$$reportNull$$$0(33);
        }
        if (contextFunction == null) {
            return configuration.getPattern().isEmpty();
        }
        String functionName = contextFunction.getName();
        if (functionName == null || !(contextFunction instanceof GoFunctionDeclaration)) {
            return false;
        }
        String subTestName = GoTestRunConfigurationProducerBase.findSubTestInContext(contextElement, contextFunction);
        String pattern = GoTestRunConfigurationProducerBase.createPatternFromFullTestName(subTestName != null ? subTestName : functionName);
        return configuration.getPattern().equals(pattern);
    }

    @NotNull
    public static String createPatternFromFullTestName(@NotNull String fullTestName) {
        if (fullTestName == null) {
            GoTestRunConfigurationProducerBase.$$$reportNull$$$0(34);
        }
        String string = "^" + StringUtil.join((Object[])fullTestName.split("/"), GoTestRunningState::escapePattern, (String)"$/^") + "$";
        if (string == null) {
            GoTestRunConfigurationProducerBase.$$$reportNull$$$0(35);
        }
        return string;
    }

    @Nullable
    public static String findSubTestInContext(PsiElement element, @NotNull GoFunctionOrMethodDeclaration function) {
        String tableTestName;
        if (function == null) {
            GoTestRunConfigurationProducerBase.$$$reportNull$$$0(36);
        }
        if ((tableTestName = GoTableTestUtil.getTableTestName(function, element)) != null) {
            return tableTestName;
        }
        Map<GoCallExpr, String> subTests = GoRunUtil.getSubTests(function);
        if (subTests.isEmpty()) {
            return null;
        }
        GoCallExpr call = (GoCallExpr)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{GoCallExpr.class});
        while (call != null) {
            String testName = subTests.get(call);
            if (testName != null) {
                return testName;
            }
            call = (GoCallExpr)PsiTreeUtil.getParentOfType((PsiElement)call, GoCallExpr.class);
        }
        return null;
    }

    private boolean hasSupportedFunctions(@NotNull Project project, @NotNull List<VirtualFile> files) {
        if (project == null) {
            GoTestRunConfigurationProducerBase.$$$reportNull$$$0(37);
        }
        if (files == null) {
            GoTestRunConfigurationProducerBase.$$$reportNull$$$0(38);
        }
        PsiManager manager = PsiManager.getInstance((Project)project);
        for (VirtualFile file2 : files) {
            GoFile psiFile = (GoFile)((Object)ObjectUtils.tryCast((Object)manager.findFile(file2), GoFile.class));
            if (psiFile == null) continue;
            for (GoFunctionDeclaration goFunctionDeclaration : psiFile.getFunctions()) {
                if (!this.myFramework.isAvailableOnFunction(goFunctionDeclaration)) continue;
                return true;
            }
            for (GoMethodDeclaration goMethodDeclaration : psiFile.getMethods()) {
                if (!this.myFramework.isAvailableOnFunction(goMethodDeclaration)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isExampleWithoutOutput(@Nullable GoFunctionOrMethodDeclaration fun) {
        boolean isExample = fun instanceof GoFunctionDeclaration && GoTestFunctionType.fromName(fun.getName()) == GoTestFunctionType.EXAMPLE;
        return isExample && ((GoFunctionDeclaration)fun).getExampleOutput() == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 35 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "framework";
                break;
            }
            case 1: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/execution/testing/GoTestRunConfigurationProducerBase";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 11: 
            case 18: 
            case 21: 
            case 26: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 10: 
            case 17: 
            case 19: 
            case 22: 
            case 23: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 7: 
            case 13: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageDir";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fuzzFuncName";
                break;
            }
            case 12: 
            case 20: 
            case 24: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
            case 14: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesFromContext";
                break;
            }
            case 15: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullTestName";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/execution/testing/GoTestRunConfigurationProducerBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "createPatternFromFullTestName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 35: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTestPathFromContext";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTestPatternFromContext";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromContext";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPackageNameForTestFunction";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doSetupConfigurationFromContext";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableOnFiles";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getTestNamePrefix";
                break;
            }
            case 17: 
            case 18: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationFromContext";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isPackageTypeConfigurationFromContext";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationWithoutContext";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isFileTypeConfigurationFromContext";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getWorkingDirectory";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "matchFunctionPattern";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createPatternFromFullTestName";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "findSubTestInContext";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "hasSupportedFunctions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 35 -> new IllegalStateException(string);
        };
    }
}

