/*
 * Decompiled with CFR 0.152.
 */
package com.goide.execution.testing.coverage;

import com.goide.execution.testing.coverage.GoCoverageEngine;
import com.goide.execution.testing.coverage.GoCoverageProjectData;
import com.goide.i18n.GoBundle;
import com.goide.sdk.GoPackageUtil;
import com.intellij.coverage.BaseCoverageSuite;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageLoadErrorReporter;
import com.intellij.coverage.CoverageLoadingResult;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.DummyCoverageLoadErrorReporter;
import com.intellij.coverage.FailedCoverageLoadingResult;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.util.Processor;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoCoverageRunner
extends CoverageRunner {
    private static final Logger LOG = Logger.getInstance(GoCoverageRunner.class);
    @NonNls
    private static final String ID = "GoCoverage";
    @NonNls
    private static final String DATA_FILE_EXTENSION = "out";

    @NotNull
    public CoverageLoadingResult loadCoverageData(@NotNull File sessionDataFile, @Nullable CoverageSuite baseCoverageSuite, @NotNull CoverageLoadErrorReporter reporter) {
        Module module;
        if (sessionDataFile == null) {
            GoCoverageRunner.$$$reportNull$$$0(0);
        }
        if (reporter == null) {
            GoCoverageRunner.$$$reportNull$$$0(1);
        }
        if (!(baseCoverageSuite instanceof BaseCoverageSuite)) {
            String message = "Expected Go coverage suite, got " + (baseCoverageSuite == null ? "null" : baseCoverageSuite.getClass().getName()) + " instead";
            LOG.warn(message);
            return new FailedCoverageLoadingResult(message);
        }
        Project project = baseCoverageSuite.getProject();
        if (project == null) {
            String message = "Got null as a project";
            LOG.warn(message);
            return new FailedCoverageLoadingResult(message);
        }
        RunConfigurationBase configuration = ((BaseCoverageSuite)baseCoverageSuite).getConfiguration();
        Module module2 = module = configuration instanceof ModuleBasedConfiguration ? ((ModuleBasedConfiguration)configuration).getConfigurationModule().getModule() : null;
        if (ApplicationManager.getApplication().isDispatchThread()) {
            Ref projectDataRef = new Ref();
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> projectDataRef.set((Object)GoCoverageRunner.doLoadCoverageData(sessionDataFile, project, module, reporter)), GoBundle.message((String)"go.execution.coverage.loading.coverage.data", (Object[])new Object[0]), true, baseCoverageSuite.getProject());
            CoverageLoadingResult coverageLoadingResult = (CoverageLoadingResult)projectDataRef.get();
            if (coverageLoadingResult == null) {
                GoCoverageRunner.$$$reportNull$$$0(2);
            }
            return coverageLoadingResult;
        }
        return GoCoverageRunner.doLoadCoverageData(sessionDataFile, project, module, reporter);
    }

    /*
     * Exception decompiling
     */
    @NotNull
    private static CoverageLoadingResult doLoadCoverageData(@NotNull File sessionDataFile, Project project, Module module, @NotNull CoverageLoadErrorReporter reporter) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    public static GoCoverageProjectData parseCoverage(@NotNull BufferedReader dataReader, @NotNull Project project, @Nullable Module module) throws IOException {
        if (dataReader == null) {
            GoCoverageRunner.$$$reportNull$$$0(6);
        }
        if (project == null) {
            GoCoverageRunner.$$$reportNull$$$0(7);
        }
        return GoCoverageRunner.parseCoverage(dataReader, project, module, (CoverageLoadErrorReporter)new DummyCoverageLoadErrorReporter());
    }

    @NotNull
    private static GoCoverageProjectData parseCoverage(@NotNull BufferedReader dataReader, @NotNull Project project, @Nullable Module module, @NotNull CoverageLoadErrorReporter reporter) throws IOException {
        String line;
        if (dataReader == null) {
            GoCoverageRunner.$$$reportNull$$$0(8);
        }
        if (project == null) {
            GoCoverageRunner.$$$reportNull$$$0(9);
        }
        if (reporter == null) {
            GoCoverageRunner.$$$reportNull$$$0(10);
        }
        GoCoverageProjectData result = new GoCoverageProjectData();
        while ((line = dataReader.readLine()) != null) {
            ProgressManager.checkCanceled();
            if (line.isEmpty()) continue;
            Pair<VirtualFile, String> fileNameTail = GoCoverageRunner.extractFileName(line, project, module);
            if (fileNameTail == null) {
                String message = "Could not find file for line: " + line;
                LOG.warn(message);
                reporter.reportWarning(message, null);
                continue;
            }
            String filePath = ((VirtualFile)fileNameTail.first).getPath();
            List tailParts = StringUtil.split((String)((String)fileNameTail.second), (String)" ");
            if (tailParts.size() != 3) {
                String message = "Unexpected line format. Expected offsets, statements and hits separated by space, but got: " + line;
                LOG.warn(message);
                reporter.reportWarning(message, null);
                continue;
            }
            try {
                int statements = Integer.parseInt((String)tailParts.get(1));
                long hit = Long.parseLong((String)tailParts.get(2));
                String offsets = (String)tailParts.get(0);
                int firstDot = offsets.indexOf(46);
                int comma = offsets.indexOf(44, firstDot);
                int secondDot = offsets.indexOf(46, comma);
                if (firstDot == -1 || comma == -1 || secondDot == -1) {
                    String message = "Unexpected line format. Expected offsets in format line.column,line.column, but got: " + line;
                    LOG.warn(message);
                    reporter.reportWarning(message, null);
                    continue;
                }
                int lineStart = Integer.parseInt(offsets.substring(0, firstDot));
                int columnStart = Integer.parseInt(offsets.substring(firstDot + 1, comma));
                int lineEnd = Integer.parseInt(offsets.substring(comma + 1, secondDot));
                int columnEnd = Integer.parseInt(offsets.substring(secondDot + 1));
                result.addData(filePath, lineStart, columnStart, lineEnd, columnEnd, statements, hit);
            }
            catch (NumberFormatException e) {
                String message = "Parsing error in line: " + line;
                LOG.warn(message, (Throwable)e);
                reporter.reportWarning(message, (Exception)e);
            }
        }
        result.processFiles((Processor<? super GoCoverageProjectData.FileData>)((Processor)fileData2 -> {
            ClassData classData = result.getOrCreateClassData(fileData2.myFilePath);
            int max = -1;
            Int2ObjectOpenHashMap linesMap = new Int2ObjectOpenHashMap();
            for (GoCoverageProjectData.RangeData rangeData : fileData2.myRangesData.values()) {
                for (int i = rangeData.startLine; i <= rangeData.endLine; ++i) {
                    int hits;
                    LineData data = (LineData)linesMap.get(i);
                    int n = hits = rangeData.hits > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)rangeData.hits;
                    if (data == null) {
                        data = new LineData(i, null);
                        linesMap.put(i, (Object)data);
                    }
                    data.setHits(Math.max(data.getHits(), hits));
                    if (hits != 0) continue;
                    data.setFalseHits(0, 0);
                    data.setTrueHits(0, 0);
                }
                max = Math.max(max, rangeData.endLine);
            }
            LineData[] linesArray = new LineData[max + 1];
            for (LineData data : linesMap.values()) {
                data.fillArrays();
                linesArray[data.getLineNumber()] = data;
            }
            classData.setLines(linesArray);
            return true;
        }));
        GoCoverageProjectData goCoverageProjectData = result;
        if (goCoverageProjectData == null) {
            GoCoverageRunner.$$$reportNull$$$0(11);
        }
        return goCoverageProjectData;
    }

    @Nullable
    private static Pair<VirtualFile, String> extractFileName(@NotNull String line, @NotNull Project project, @Nullable Module module) {
        int pos;
        if (line == null) {
            GoCoverageRunner.$$$reportNull$$$0(12);
        }
        if (project == null) {
            GoCoverageRunner.$$$reportNull$$$0(13);
        }
        if ((pos = line.lastIndexOf(58)) == -1) {
            return null;
        }
        String fileName = line.substring(0, pos);
        VirtualFile file2 = (VirtualFile)ReadAction.compute(() -> FileUtil.isAbsolute((String)fileName) ? LocalFileSystem.getInstance().findFileByPath(fileName) : GoPackageUtil.findFileByImportPath(fileName, project, module));
        if (file2 == null) {
            return null;
        }
        return Pair.create((Object)file2, (Object)line.substring(pos + 1));
    }

    @NotNull
    public String getPresentableName() {
        String string = GoBundle.message((String)"go.execution.coverage.runner.name", (Object[])new Object[0]);
        if (string == null) {
            GoCoverageRunner.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public String getId() {
        return ID;
    }

    @NotNull
    public String getDataFileExtension() {
        return DATA_FILE_EXTENSION;
    }

    public boolean acceptsCoverageEngine(@NotNull CoverageEngine engine) {
        if (engine == null) {
            GoCoverageRunner.$$$reportNull$$$0(15);
        }
        return engine instanceof GoCoverageEngine;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 11, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionDataFile";
                break;
            }
            case 1: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 2: 
            case 5: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/execution/testing/coverage/GoCoverageRunner";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataReader";
                break;
            }
            case 7: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "engine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/execution/testing/coverage/GoCoverageRunner";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "loadCoverageData";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "doLoadCoverageData";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "parseCoverage";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadCoverageData";
                break;
            }
            case 2: 
            case 5: 
            case 11: 
            case 14: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doLoadCoverageData";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseCoverage";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "extractFileName";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "acceptsCoverageEngine";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 11, 14 -> new IllegalStateException(string);
        };
    }
}

