/*
 * Decompiled with CFR 0.152.
 */
package com.goide.execution.testing.creator;

import com.goide.execution.testing.creator.GoTestCreator;
import com.goide.i18n.GoBundle;
import com.goide.refactor.util.GoRefactoringUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.Nullable;

public final class GoFileTestCreator
extends GoTestCreator {
    public void createTest(Project project, Editor editor, PsiFile file2) {
        PsiDirectory directory = file2.getContainingDirectory();
        if (directory == null) {
            return;
        }
        String testFileName = FileUtil.getNameWithoutExtension((String)file2.getName()) + "_test.go";
        Object testFile = directory.findFile(testFileName);
        if (testFile == null) {
            testFile = GoRefactoringUtil.createFile(directory, testFileName, null, project);
        }
        if (testFile != null) {
            FileEditorManager.getInstance((Project)project).openFile(testFile.getVirtualFile(), true);
        }
    }

    @Override
    public boolean isAvailable(Project project, Editor editor, PsiFile file2) {
        if (!super.isAvailable(project, editor, file2)) {
            return false;
        }
        PsiDirectory directory = file2.getContainingDirectory();
        if (directory == null) {
            return false;
        }
        PsiFile testFile = directory.findFile(FileUtil.getNameWithoutExtension((String)file2.getName()) + "_test.go");
        return testFile == null;
    }

    @Nullable
    public String getPresentableText() {
        return GoBundle.message((String)"go.test.creator.empty.test.file.name", (Object[])new Object[0]);
    }
}

