/*
 * Decompiled with CFR 0.152.
 */
package com.goide.execution.testing.frameworks.gofuzz;

import com.goide.execution.testing.GoTestFinder;
import com.goide.execution.testing.GoTestRunConfiguration;
import com.goide.execution.testing.GoTestRunningState;
import com.goide.execution.testing.frameworks.gofuzz.GoFuzzFailingInputConsoleFilter;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionDeclaration;
import com.goide.util.GoExecutor;
import com.goide.util.GoUtil;
import com.intellij.execution.Executor;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0014J\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u000bH\u0014J\u0013\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0011\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014\u00a8\u0006\u001c"}, d2={"Lcom/goide/execution/testing/frameworks/gofuzz/GoFuzzRunningState;", "Lcom/goide/execution/testing/GoTestRunningState;", "env", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "module", "Lcom/intellij/openapi/module/Module;", "configuration", "Lcom/goide/execution/testing/GoTestRunConfiguration;", "<init>", "(Lcom/intellij/execution/runners/ExecutionEnvironment;Lcom/intellij/openapi/module/Module;Lcom/goide/execution/testing/GoTestRunConfiguration;)V", "buildFilterPatternForFiles", "", "files", "", "Lcom/goide/psi/GoFile;", "addFilterParameter", "", "executor", "Lcom/goide/util/GoExecutor;", "pattern", "getAdditionalBuildParams", "", "()[Ljava/lang/String;", "createConsoleInner", "Lcom/intellij/execution/ui/ConsoleView;", "Lcom/intellij/execution/Executor;", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "intellij.go.impl"})
public final class GoFuzzRunningState
extends GoTestRunningState {
    public GoFuzzRunningState(@NotNull ExecutionEnvironment env, @NotNull Module module, @NotNull GoTestRunConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        super(env, module, configuration);
    }

    @NotNull
    protected String buildFilterPatternForFiles(@NotNull List<? extends GoFile> files) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        return SequencesKt.joinToString$default((Sequence)SequencesKt.filter((Sequence)SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)files), GoFuzzRunningState::buildFilterPatternForFiles$lambda$0), GoFuzzRunningState::buildFilterPatternForFiles$lambda$1), (CharSequence)"|", (CharSequence)"^", (CharSequence)"$", (int)0, null, GoFuzzRunningState::buildFilterPatternForFiles$lambda$2, (int)24, null);
    }

    @Override
    protected void addFilterParameter(@NotNull GoExecutor executor, @Nullable String pattern) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        boolean buildableTest = this.isBuildable();
        String[] stringArray = new String[]{buildableTest ? "-test.fuzz" : "-fuzz", StringUtil.isEmpty((String)pattern) ? "." : pattern};
        executor.withParameters(stringArray);
        if (buildableTest) {
            stringArray = new String[]{"-test.fuzzcachedir", ((Object)GoUtil.getGoLandTempDirectory().resolve("fuzz/")).toString()};
            executor.withParameters(stringArray);
        }
        stringArray = new String[]{buildableTest ? "-test.run" : "-run", "^$"};
        executor.withParameters(stringArray);
    }

    @Override
    @NotNull
    public String[] getAdditionalBuildParams() {
        String[] stringArray = super.getAdditionalBuildParams();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getAdditionalBuildParams(...)");
        Object[] objectArray = new String[]{"-gcflags", "-d=libfuzzer"};
        return (String[])ArraysKt.plus((Object[])stringArray, (Object[])objectArray);
    }

    @Override
    @Nullable
    protected ConsoleView createConsoleInner(@NotNull Executor executor, @NotNull ProcessHandler processHandler) {
        ConsoleView consoleView;
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
        ConsoleView consoleView2 = super.createConsoleInner(executor, processHandler);
        if (consoleView2 != null) {
            ConsoleView consoleView3;
            ConsoleView $this$createConsoleInner_u24lambda_u240 = consoleView3 = consoleView2;
            boolean bl = false;
            Project project = ((GoTestRunConfiguration)this.myConfiguration).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            String string = ((GoTestRunConfiguration)this.myConfiguration).getWorkingDirectoryUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getWorkingDirectoryUrl(...)");
            $this$createConsoleInner_u24lambda_u240.addMessageFilter((Filter)new GoFuzzFailingInputConsoleFilter(project, string));
            consoleView = consoleView3;
        } else {
            consoleView = null;
        }
        return consoleView;
    }

    private static final Iterable buildFilterPatternForFiles$lambda$0(GoFile it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        Collection<? extends GoFunctionDeclaration> collection = it.getFunctions();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getFunctions(...)");
        return collection;
    }

    private static final boolean buildFilterPatternForFiles$lambda$1(GoFunctionDeclaration it) {
        return GoTestFinder.isFuzzingFunction(it);
    }

    private static final CharSequence buildFilterPatternForFiles$lambda$2(GoFunctionDeclaration it) {
        String string = GoTestRunningState.escapePattern(it.getName());
        Intrinsics.checkNotNull((Object)string);
        return string;
    }
}

