/*
 * Decompiled with CFR 0.152.
 */
package com.goide.execution.testing.frameworks.gotest;

import com.goide.execution.testing.GoTestEventsConverterBase;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.ServiceMessageBuilder;
import com.intellij.execution.testframework.sm.runner.OutputToGeneralTestEventsConverter;
import com.intellij.openapi.util.Key;
import java.text.ParseException;
import java.util.Objects;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessageVisitor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GoTestEventsConverterBaseImpl
extends OutputToGeneralTestEventsConverter
implements GoTestEventsConverterBase {
    @NotNull
    private final String myDefaultImportPath;
    @Nullable
    private ServiceMessageVisitor myVisitor;
    @Nullable
    private String myCurrentTestName;
    @Nullable
    private TestResult myCurrentTestResult;
    private long myCurrentTestStart;

    public GoTestEventsConverterBaseImpl(@NotNull @NonNls String testFrameworkName, @NotNull String defaultImportPath, @NotNull TestConsoleProperties consoleProperties) {
        if (testFrameworkName == null) {
            GoTestEventsConverterBaseImpl.$$$reportNull$$$0(0);
        }
        if (defaultImportPath == null) {
            GoTestEventsConverterBaseImpl.$$$reportNull$$$0(1);
        }
        if (consoleProperties == null) {
            GoTestEventsConverterBaseImpl.$$$reportNull$$$0(2);
        }
        super(testFrameworkName, consoleProperties);
        this.myDefaultImportPath = defaultImportPath;
    }

    protected abstract int processLine(@NotNull String var1, int var2, Key<?> var3, @NotNull ServiceMessageVisitor var4) throws ParseException;

    @Nullable
    protected String getCurrentTestName() {
        return this.myCurrentTestName;
    }

    @Override
    public final boolean processServiceMessages(@NotNull String text, @NotNull Key<?> outputType, @NotNull ServiceMessageVisitor visitor2) throws ParseException {
        if (text == null) {
            GoTestEventsConverterBaseImpl.$$$reportNull$$$0(3);
        }
        if (outputType == null) {
            GoTestEventsConverterBaseImpl.$$$reportNull$$$0(4);
        }
        if (visitor2 == null) {
            GoTestEventsConverterBaseImpl.$$$reportNull$$$0(5);
        }
        if (this.myVisitor == null) {
            this.myVisitor = visitor2;
        }
        if (text.isEmpty()) {
            return true;
        }
        int startOffset = 0;
        int newStartOffset = this.processLine(text, 0, outputType, visitor2);
        while (startOffset != newStartOffset && newStartOffset < text.length()) {
            startOffset = newStartOffset;
            newStartOffset = this.processLine(text, startOffset, outputType, visitor2);
        }
        if (newStartOffset < text.length()) {
            this.processOutput(text.substring(startOffset), outputType, visitor2);
        }
        return true;
    }

    protected void processOutput(@NotNull String text, Key<?> outputType, ServiceMessageVisitor visitor2) throws ParseException {
        if (text == null) {
            GoTestEventsConverterBaseImpl.$$$reportNull$$$0(6);
        }
        if (text.isEmpty()) {
            return;
        }
        boolean isErrorMessage = ProcessOutputType.isStderr(outputType);
        String name = this.myCurrentTestName;
        if (name != null) {
            ServiceMessageBuilder builder = isErrorMessage ? ServiceMessageBuilder.testStdErr((String)name) : ServiceMessageBuilder.testStdOut((String)name);
            builder.addAttribute("textAttributes", outputType.toString());
            builder.addAttribute("out", text);
            super.processServiceMessages(builder.toString(), outputType, visitor2);
            return;
        }
        this.getProcessor().onUncapturedOutput(text, outputType);
    }

    public void dispose() {
        this.myVisitor = null;
        super.dispose();
    }

    protected void startTest(@NotNull String testName, @NotNull Key<?> outputType, @NotNull ServiceMessageVisitor visitor2) throws ParseException {
        if (testName == null) {
            GoTestEventsConverterBaseImpl.$$$reportNull$$$0(7);
        }
        if (outputType == null) {
            GoTestEventsConverterBaseImpl.$$$reportNull$$$0(8);
        }
        if (visitor2 == null) {
            GoTestEventsConverterBaseImpl.$$$reportNull$$$0(9);
        }
        if (this.isCurrentlyRunningTest(testName)) {
            return;
        }
        this.finishDelayedTest(visitor2);
        this.myCurrentTestName = testName;
        this.myCurrentTestResult = null;
        this.myCurrentTestStart = System.currentTimeMillis();
        String testStartedMessage = ServiceMessageBuilder.testStarted((String)testName).addAttribute("locationHint", this.testUrl(testName)).toString();
        super.processServiceMessages(testStartedMessage, outputType, visitor2);
    }

    public void flushBufferOnProcessTermination(int exitCode) {
        try {
            if (!this.finishDelayedTest(Objects.requireNonNull(this.myVisitor)) && this.myCurrentTestName != null) {
                this.finishTestInner(this.myCurrentTestName, this.getDefaultUnfinishedTestResult(), this.myVisitor);
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this.myVisitor = null;
    }

    protected TestResult getDefaultUnfinishedTestResult() {
        return TestResult.FAILED;
    }

    protected void finishTest(@NotNull String name, @NotNull TestResult result, @NotNull ServiceMessageVisitor visitor2) throws ParseException {
        if (name == null) {
            GoTestEventsConverterBaseImpl.$$$reportNull$$$0(10);
        }
        if (result == null) {
            GoTestEventsConverterBaseImpl.$$$reportNull$$$0(11);
        }
        if (visitor2 == null) {
            GoTestEventsConverterBaseImpl.$$$reportNull$$$0(12);
        }
        if (this.isCurrentlyRunningTest(name)) {
            if (this.myCurrentTestResult == null) {
                this.myCurrentTestResult = result;
            }
            return;
        }
        this.finishTestInner(name, result, visitor2);
    }

    protected boolean finishDelayedTest(@NotNull ServiceMessageVisitor visitor2) throws ParseException {
        if (visitor2 == null) {
            GoTestEventsConverterBaseImpl.$$$reportNull$$$0(13);
        }
        if (this.myCurrentTestName != null && this.myCurrentTestResult != null) {
            this.finishTestInner(this.myCurrentTestName, this.myCurrentTestResult, visitor2);
            return true;
        }
        return false;
    }

    private boolean isCurrentlyRunningTest(@NotNull String testName) {
        if (testName == null) {
            GoTestEventsConverterBaseImpl.$$$reportNull$$$0(14);
        }
        return testName.equals(this.myCurrentTestName);
    }

    private void finishTestInner(@NotNull String name, @NotNull TestResult result, @NotNull ServiceMessageVisitor visitor2) throws ParseException {
        if (name == null) {
            GoTestEventsConverterBaseImpl.$$$reportNull$$$0(15);
        }
        if (result == null) {
            GoTestEventsConverterBaseImpl.$$$reportNull$$$0(16);
        }
        if (visitor2 == null) {
            GoTestEventsConverterBaseImpl.$$$reportNull$$$0(17);
        }
        if (this.isCurrentlyRunningTest(name)) {
            this.myCurrentTestName = null;
            this.myCurrentTestResult = null;
        }
        String duration = this.myCurrentTestStart > 0L ? Long.toString(System.currentTimeMillis() - this.myCurrentTestStart) : null;
        switch (result.ordinal()) {
            case 0: {
                break;
            }
            case 1: {
                String failedMessage = ServiceMessageBuilder.testFailed((String)name).addAttribute("message", "").toString();
                super.processServiceMessages(failedMessage, ProcessOutputTypes.SYSTEM, visitor2);
                break;
            }
            case 2: {
                String skipMessage = ServiceMessageBuilder.testIgnored((String)name).addAttribute("message", "").toString();
                super.processServiceMessages(skipMessage, ProcessOutputTypes.SYSTEM, visitor2);
            }
        }
        ServiceMessageBuilder finishedMessage = ServiceMessageBuilder.testFinished((String)name);
        if (duration != null) {
            finishedMessage.addAttribute("duration", duration);
        }
        super.processServiceMessages(finishedMessage.toString(), ProcessOutputTypes.SYSTEM, visitor2);
    }

    @NotNull
    private String testUrl(@NotNull String testName) {
        if (testName == null) {
            GoTestEventsConverterBaseImpl.$$$reportNull$$$0(18);
        }
        String string = "gotest://" + this.myDefaultImportPath + "#" + testName;
        if (string == null) {
            GoTestEventsConverterBaseImpl.$$$reportNull$$$0(19);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFrameworkName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultImportPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleProperties";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
            case 5: 
            case 9: 
            case 12: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 7: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testName";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/execution/testing/frameworks/gotest/GoTestEventsConverterBaseImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/execution/testing/frameworks/gotest/GoTestEventsConverterBaseImpl";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "testUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processServiceMessages";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processOutput";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "startTest";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "finishTest";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "finishDelayedTest";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isCurrentlyRunningTest";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "finishTestInner";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "testUrl";
                break;
            }
            case 19: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 19 -> new IllegalStateException(string);
        };
    }

    public static enum TestResult {
        PASSED,
        FAILED,
        SKIPPED;

    }
}

