/*
 * Decompiled with CFR 0.152.
 */
package com.goide.execution.ui;

import com.goide.GoOsManager;
import com.goide.execution.GoModuleBasedConfiguration;
import com.goide.execution.GoRunConfigurationBase;
import com.goide.execution.GoRunUtil;
import com.goide.i18n.GoBundle;
import com.goide.sdk.GoSdkService;
import com.intellij.DynamicBundle;
import com.intellij.application.options.ModulesComboBox;
import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.execution.ui.CommonParameterFragments;
import com.intellij.execution.ui.CommonProgramParametersPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.fields.ExpandableTextField;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoCommonSettingsPanel
extends JPanel
implements Disposable {
    private RawCommandLineEditor myGoToolParamsField;
    private RawCommandLineEditor myParamsField;
    private TextFieldWithBrowseButton myWorkingDirectoryField;
    private EnvironmentVariablesTextFieldWithBrowseButton myEnvironmentField;
    private ModulesComboBox myModulesComboBox;
    private JPanel myRoot;
    private JPanel myToolArgsLinkPanel;
    private JBCheckBox myUseCustomBuildTagsCheckBox;
    private JBCheckBox myRunWithSudoCheckBox;
    private Project myProject;

    public GoCommonSettingsPanel() {
        this.$$$setupUI$$$();
    }

    public void init(@NotNull Project project) {
        if (project == null) {
            GoCommonSettingsPanel.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        if (GoOsManager.isWindows()) {
            this.myRunWithSudoCheckBox.setText(UIUtil.replaceMnemonicAmpersand((String)GoBundle.message((String)"go.run.configuration.run.with.sudo.mnemonic", (Object[])new Object[0])));
        }
        GoRunUtil.installDirectoryChooser(project, this.myWorkingDirectoryField);
        this.addToolArgsLinkPanel();
        GoCommonSettingsPanel.setMonospacedAndAddMacroSupport(this.myGoToolParamsField.getEditorField());
        GoCommonSettingsPanel.setMonospacedAndAddMacroSupport(this.myParamsField.getEditorField());
    }

    private static void setMonospacedAndAddMacroSupport(ExpandableTextField field) {
        CommonParameterFragments.setMonospaced((Component)field);
        CommonProgramParametersPanel.addMacroSupport((ExtendableTextField)field);
    }

    private void addToolArgsLinkPanel() {
        Font font = UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL);
        String ldFlags = "-ldflags=\"-linkmode internal\"";
        ActionLink label = new ActionLink(ldFlags, e -> {
            String prev = this.myGoToolParamsField.getText();
            this.myGoToolParamsField.setText((String)(StringUtil.isEmptyOrSpaces((String)prev) ? ldFlags : prev + " " + ldFlags));
        });
        label.setFont(font);
        JBLabel add = new JBLabel(GoBundle.message((String)"go.run.configuration.add.go.tool.argument.label", (Object[])new Object[0]));
        add.setFont(font);
        this.myToolArgsLinkPanel.add((Component)add, "West");
        this.myToolArgsLinkPanel.add((Component)label, "Center");
        this.myToolArgsLinkPanel.setVisible(this.myProject != null && GoSdkService.getInstance(this.myProject).getSdk(null).requiresLdFlagsOnDebug());
        this.myModulesComboBox.addItemListener(e -> {
            Module module = (Module)ObjectUtils.tryCast((Object)e.getItem(), Module.class);
            this.myToolArgsLinkPanel.setVisible(this.myProject != null && GoSdkService.getInstance(this.myProject).getSdk(module).requiresLdFlagsOnDebug());
        });
    }

    public void resetEditorFrom(@NotNull GoRunConfigurationBase<?> configuration) {
        if (configuration == null) {
            GoCommonSettingsPanel.$$$reportNull$$$0(1);
        }
        this.myModulesComboBox.setModules(configuration.getValidModules());
        this.myModulesComboBox.setSelectedModule(((GoModuleBasedConfiguration)configuration.getConfigurationModule()).getModule());
        this.myGoToolParamsField.setText(configuration.getGoToolParams());
        this.myUseCustomBuildTagsCheckBox.setSelected(configuration.isUseCustomBuildTags());
        this.myRunWithSudoCheckBox.setSelected(configuration.isRunWithSudo());
        this.myParamsField.setText(configuration.getParams());
        this.myWorkingDirectoryField.setText(configuration.getWorkingDirectory());
        this.myEnvironmentField.setEnvs(configuration.getCustomEnvironment());
        this.myEnvironmentField.setPassParentEnvs(configuration.isPassParentEnvironment());
    }

    public void applyEditorTo(@NotNull GoRunConfigurationBase<?> configuration) {
        if (configuration == null) {
            GoCommonSettingsPanel.$$$reportNull$$$0(2);
        }
        configuration.setModule(this.myModulesComboBox.getSelectedModule());
        configuration.setGoToolParams(this.myGoToolParamsField.getText());
        configuration.setUseCustomBuildTags(this.myUseCustomBuildTagsCheckBox.isSelected());
        configuration.setRunWithSudo(this.myRunWithSudoCheckBox.isSelected());
        configuration.setParams(this.myParamsField.getText());
        configuration.setWorkingDirectory(this.myWorkingDirectoryField.getText());
        configuration.setCustomEnvironment(this.myEnvironmentField.getEnvs());
        configuration.setPassParentEnvironment(this.myEnvironmentField.isPassParentEnvs());
    }

    public void hideUnsupportedFieldsIfNeeded(boolean localTarget, boolean isElevationServiceAvailable) {
        this.myRunWithSudoCheckBox.setVisible(localTarget && isElevationServiceAvailable);
    }

    @Nullable
    public Module getSelectedModule() {
        return this.myModulesComboBox.getSelectedModule();
    }

    private void createUIComponents() {
        this.myToolArgsLinkPanel = new JPanel(new BorderLayout());
        this.myToolArgsLinkPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)3));
    }

    public void dispose() {
        for (ItemListener listener2 : this.myModulesComboBox.getItemListeners()) {
            this.myModulesComboBox.removeItemListener(listener2);
        }
        this.myProject = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        objectArray2[1] = "com/goide/execution/ui/GoCommonSettingsPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "init";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "resetEditorFrom";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "applyEditorTo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        RawCommandLineEditor rawCommandLineEditor;
        RawCommandLineEditor rawCommandLineEditor2;
        ModulesComboBox modulesComboBox;
        EnvironmentVariablesTextFieldWithBrowseButton environmentVariablesTextFieldWithBrowseButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.createUIComponents();
        this.myRoot = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(9, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(8, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/ExecutionBundle", GoCommonSettingsPanel.class).getString("run.configuration.working.directory.label"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myWorkingDirectoryField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/GoBundle", GoCommonSettingsPanel.class).getString("go.run.configuration.environment.label"));
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myEnvironmentField = environmentVariablesTextFieldWithBrowseButton = new EnvironmentVariablesTextFieldWithBrowseButton();
        jPanel.add((Component)environmentVariablesTextFieldWithBrowseButton, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setInheritsPopupMenu(true);
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/GoBundle", GoCommonSettingsPanel.class).getString("go.run.configuration.module.label"));
        jPanel.add((Component)jLabel3, new GridConstraints(7, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(1, 1), null));
        this.myModulesComboBox = modulesComboBox = new ModulesComboBox();
        jPanel.add((Component)modulesComboBox, new GridConstraints(7, 1, 1, 1, 1, 1, 3, 3, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle((String)"messages/GoBundle", GoCommonSettingsPanel.class).getString("go.run.configuration.program.arguments.label"));
        jPanel.add((Component)jLabel4, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myParamsField = rawCommandLineEditor2 = new RawCommandLineEditor();
        jPanel.add((Component)rawCommandLineEditor2, new GridConstraints(5, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myGoToolParamsField = rawCommandLineEditor = new RawCommandLineEditor();
        jPanel.add((Component)rawCommandLineEditor, new GridConstraints(2, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, DynamicBundle.getBundle((String)"messages/GoBundle", GoCommonSettingsPanel.class).getString("go.run.configuration.go.tool.arguments.label"));
        jPanel.add((Component)jLabel5, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel2 = this.myToolArgsLinkPanel;
        jPanel.add((Component)jPanel2, new GridConstraints(4, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myUseCustomBuildTagsCheckBox = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setHorizontalAlignment(2);
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/GoBundle", GoCommonSettingsPanel.class).getString("go.run.configuration.use.all.custom.build.tags.label"));
        jBCheckBox2.setToolTipText(DynamicBundle.getBundle((String)"messages/GoBundle", GoCommonSettingsPanel.class).getString("go.run.configuration.use.all.custom.build.tags.tooltip"));
        jPanel.add((Component)jBCheckBox2, new GridConstraints(3, 1, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myRunWithSudoCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setHorizontalAlignment(2);
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/GoBundle", GoCommonSettingsPanel.class).getString("go.run.configuration.run.with.sudo.label"));
        jBCheckBox.setToolTipText(DynamicBundle.getBundle((String)"messages/GoBundle", GoCommonSettingsPanel.class).getString("go.run.configuration.run.with.sudo.tooltip"));
        jPanel.add((Component)jBCheckBox, new GridConstraints(6, 1, 1, 1, 8, 0, 3, 3, null, null, null));
        jLabel.setLabelFor((Component)textFieldWithBrowseButton);
        jLabel2.setLabelFor((Component)environmentVariablesTextFieldWithBrowseButton);
        jLabel3.setLabelFor((Component)modulesComboBox);
        jLabel4.setLabelFor((Component)rawCommandLineEditor2);
        jLabel5.setLabelFor((Component)rawCommandLineEditor);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

