/*
 * Decompiled with CFR 0.152.
 */
package com.goide.formatter;

import com.goide.GoFileType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.status.LineSeparatorPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class GoLineEndingsAdapter
implements FileDocumentManagerListener {
    private boolean statusBarUpdated;

    GoLineEndingsAdapter() {
    }

    public void beforeAllDocumentsSaving() {
        this.statusBarUpdated = false;
    }

    public void beforeDocumentSaving(@NotNull Document document) {
        VirtualFile file2;
        if (document == null) {
            GoLineEndingsAdapter.$$$reportNull$$$0(0);
        }
        if ((file2 = FileDocumentManager.getInstance().getFile(document)) != null && FileTypeRegistry.getInstance().isFileOfType(file2, (FileType)GoFileType.INSTANCE)) {
            file2.setDetectedLineSeparator("\n");
            if (!this.statusBarUpdated) {
                this.statusBarUpdated = true;
                GoLineEndingsAdapter.updateStatusBar(ProjectUtil.guessProjectForContentFile((VirtualFile)file2));
            }
        }
    }

    private static void updateStatusBar(@Nullable Project project) {
        if (project == null) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            StatusBarWidget widget;
            IdeFrame frame = WindowManager.getInstance().getIdeFrame(project);
            StatusBar statusBar = frame != null ? frame.getStatusBar() : null;
            StatusBarWidget statusBarWidget = widget = statusBar != null ? statusBar.getWidget("LineSeparator") : null;
            if (widget instanceof LineSeparatorPanel) {
                ((LineSeparatorPanel)widget).selectionChanged(null);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/goide/formatter/GoLineEndingsAdapter", "beforeDocumentSaving"));
    }
}

