/*
 * Decompiled with CFR 0.152.
 */
package com.goide.formatter;

import com.goide.GoParserDefinition;
import com.goide.formatter.GoLineCommentBlock;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.GenericLineWrapPositionStrategy;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoLineWrapPositionStrategy
extends GenericLineWrapPositionStrategy {
    public GoLineWrapPositionStrategy() {
        this.addRule(new GenericLineWrapPositionStrategy.Rule('(', GenericLineWrapPositionStrategy.WrapCondition.AFTER));
        this.addRule(new GenericLineWrapPositionStrategy.Rule('.', GenericLineWrapPositionStrategy.WrapCondition.AFTER));
        this.addRule(new GenericLineWrapPositionStrategy.Rule(',', GenericLineWrapPositionStrategy.WrapCondition.AFTER, 16.0));
    }

    public int calculateWrapPosition(@NotNull Document document, @Nullable Project project, int startOffset, int endOffset, int maxPreferredOffset, boolean allowToBeyondMaxPreferredOffset, boolean isSoftWrap) {
        if (document == null) {
            GoLineWrapPositionStrategy.$$$reportNull$$$0(0);
        }
        int result = super.calculateWrapPosition(document, project, startOffset, endOffset, maxPreferredOffset, allowToBeyondMaxPreferredOffset, isSoftWrap);
        if (isSoftWrap) {
            return result;
        }
        if (GoLineWrapPositionStrategy.isInDirectiveComment(document, project, maxPreferredOffset)) {
            return -1;
        }
        return result;
    }

    private static boolean isInDirectiveComment(@NotNull Document document, @Nullable Project project, int offset) {
        PsiFile file2;
        if (document == null) {
            GoLineWrapPositionStrategy.$$$reportNull$$$0(1);
        }
        if (project == null || !GoLineWrapPositionStrategy.isAfterDoubleSlash(document.getImmutableCharSequence(), offset)) {
            return false;
        }
        PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)project);
        if (manager.isUncommited(document)) {
            manager.commitDocument(document);
        }
        PsiElement element = (file2 = manager.getPsiFile(document)) != null ? file2.findElementAt(offset) : null;
        IElementType type = element != null ? element.getNode().getElementType() : null;
        return type == GoParserDefinition.Lazy.LINE_COMMENT && GoLineCommentBlock.isDirectiveComment(StringUtil.trimStart((String)element.getText(), (String)"//"), null);
    }

    private static boolean isAfterDoubleSlash(@NotNull CharSequence text, int offset) {
        if (text == null) {
            GoLineWrapPositionStrategy.$$$reportNull$$$0(2);
        }
        for (int i = offset; i > 0; --i) {
            char c = text.charAt(i);
            if (c == '\n') {
                return false;
            }
            if (c != '/' || text.charAt(i - 1) != '/') continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/goide/formatter/GoLineWrapPositionStrategy";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateWrapPosition";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isInDirectiveComment";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isAfterDoubleSlash";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

