/*
 * Decompiled with CFR 0.152.
 */
package com.goide.hierarchy;

import com.goide.hierarchy.GoHierarchyUtil;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoMethodSpec;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeSpec;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.Navigatable;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoCallHierarchyNodeDescriptor
extends HierarchyNodeDescriptor
implements Navigatable {
    private final List<SmartPsiElementPointer<PsiElement>> myReferencePointers;

    protected GoCallHierarchyNodeDescriptor(@NotNull Project project, @Nullable NodeDescriptor parentDescriptor, @NotNull Collection<? extends PsiElement> references, @NotNull PsiElement function) {
        if (project == null) {
            GoCallHierarchyNodeDescriptor.$$$reportNull$$$0(0);
        }
        if (references == null) {
            GoCallHierarchyNodeDescriptor.$$$reportNull$$$0(1);
        }
        if (function == null) {
            GoCallHierarchyNodeDescriptor.$$$reportNull$$$0(2);
        }
        super(project, parentDescriptor, function, parentDescriptor == null);
        this.myReferencePointers = ContainerUtil.map(references, r -> SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer(r));
    }

    public void navigate(boolean requestFocus) {
        SmartPsiElementPointer first = (SmartPsiElementPointer)ContainerUtil.getFirstItem(this.myReferencePointers);
        if (first == null) {
            GoCallHierarchyNodeDescriptor.navigate(requestFocus, this.getPsiElement());
            return;
        }
        PsiElement element = first.getElement();
        if (element == null) {
            GoCallHierarchyNodeDescriptor.navigate(requestFocus, this.getPsiElement());
            return;
        }
        if (element instanceof Navigatable && ((Navigatable)element).canNavigate()) {
            ((Navigatable)element).navigate(requestFocus);
        } else {
            PsiFile psiFile = element.getContainingFile();
            if (psiFile == null || psiFile.getVirtualFile() == null) {
                return;
            }
            FileEditorManager.getInstance((Project)this.myProject).openFile(psiFile.getVirtualFile(), requestFocus);
        }
        this.highlightUsages(element);
    }

    private void highlightUsages(@NotNull PsiElement element) {
        Editor editor;
        if (element == null) {
            GoCallHierarchyNodeDescriptor.$$$reportNull$$$0(3);
        }
        if ((editor = PsiEditorUtil.findEditor((PsiElement)element)) == null) {
            return;
        }
        HighlightManager highlightManager = HighlightManager.getInstance((Project)this.myProject);
        SmartList highlighters = new SmartList();
        for (SmartPsiElementPointer<PsiElement> psiReference : this.myReferencePointers) {
            PsiElement eachElement = psiReference.getElement();
            PsiElement parent = eachElement == null ? null : eachElement.getParent();
            if (parent == null) continue;
            TextRange textRange = parent.getTextRange();
            highlightManager.addRangeHighlight(editor, textRange.getStartOffset(), textRange.getEndOffset(), EditorColors.SEARCH_RESULT_ATTRIBUTES, false, (Collection)highlighters);
        }
    }

    private static void navigate(boolean requestFocus, PsiElement element) {
        if (element instanceof Navigatable && ((Navigatable)element).canNavigate()) {
            ((Navigatable)element).navigate(requestFocus);
        }
    }

    public boolean update() {
        boolean changes = super.update();
        CompositeAppearance oldText = this.myHighlightedText;
        this.myHighlightedText = new CompositeAppearance();
        NavigatablePsiElement element = (NavigatablePsiElement)this.getPsiElement();
        if (element == null) {
            GoHierarchyUtil.setInvalidHighlightingText(this.myHighlightedText, GoCallHierarchyNodeDescriptor.getInvalidPrefixAttributes());
            return true;
        }
        ItemPresentation presentation2 = element.getPresentation();
        if (presentation2 != null) {
            GoType type;
            if (element instanceof GoMethodSpec) {
                String name;
                GoTypeSpec typeSpec = (GoTypeSpec)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)element, GoTypeSpec.class);
                String string = name = typeSpec != null ? typeSpec.getName() : null;
                if (name != null) {
                    this.myHighlightedText.getEnding().addText(name + ".");
                }
            } else if (element instanceof GoMethodDeclaration && (type = ((GoMethodDeclaration)element).getReceiverType()) != null) {
                @NlsSafe String presentationText = type.getPresentationText();
                this.myHighlightedText.getEnding().addText(presentationText + ".");
            }
            this.myHighlightedText.getEnding().addText(presentation2.getPresentableText());
            int count = this.myReferencePointers.size();
            if (count > 1) {
                String text = " " + IdeBundle.message((String)"node.call.hierarchy.N.usages", (Object[])new Object[]{count});
                this.myHighlightedText.getEnding().addText(text, HierarchyNodeDescriptor.getUsageCountPrefixAttributes());
            }
            this.myHighlightedText.getEnding().addText(" " + presentation2.getLocationString(), HierarchyNodeDescriptor.getPackageNameAttributes());
        }
        this.myName = this.myHighlightedText.getText();
        if (!Comparing.equal((Object)this.myHighlightedText, (Object)oldText)) {
            changes = true;
        }
        return changes;
    }

    public boolean canNavigate() {
        SmartPsiElementPointer first = (SmartPsiElementPointer)ContainerUtil.getFirstItem(this.myReferencePointers);
        if (first == null) {
            PsiElement element = this.getPsiElement();
            return element instanceof Navigatable && ((Navigatable)element).canNavigate();
        }
        PsiElement element = first.getElement();
        return element instanceof Navigatable && ((Navigatable)element).canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/goide/hierarchy/GoCallHierarchyNodeDescriptor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightUsages";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

