/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting;

import com.goide.codeInsight.imports.GoImportOptimizer;
import com.goide.codeInsight.imports.GoImportsSettings;
import com.goide.codeInsight.imports.GoManualImportDetector;
import com.goide.psi.GoCodeFragment;
import com.goide.psi.GoFile;
import com.goide.psi.GoImportList;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonListeners;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SilentChangeVetoer;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.testFramework.TestModeFlags;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;

public class GoOptimizeImportsHighlightingPass
extends TextEditorHighlightingPass {
    public static final Key<Boolean> TESTING_IMPORTS_OPTIMIZATION = Key.create((String)"GO_TESTING_IMPORTS_OPTIMIZATION");
    private final GoFile myFile;
    private final Editor myEditor;
    private volatile long myStamp;
    private volatile GoImportOptimizer.Task myOptimizeTask;
    private volatile boolean isInContent;
    private volatile ThreeState extensionsAllowToChangeFileSilently;

    GoOptimizeImportsHighlightingPass(@NotNull GoFile file2, @NotNull Editor editor) {
        if (file2 == null) {
            GoOptimizeImportsHighlightingPass.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            GoOptimizeImportsHighlightingPass.$$$reportNull$$$0(1);
        }
        super(file2.getProject(), editor.getDocument());
        this.myEditor = editor;
        this.myFile = file2;
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            GoOptimizeImportsHighlightingPass.$$$reportNull$$$0(2);
        }
        progress.checkCanceled();
        this.myStamp = this.myEditor.getDocument().getModificationStamp();
        this.myOptimizeTask = this.myFile.isWritable() && !this.myEditor.isDisposed() ? GoImportOptimizer.processFileForHighlightingPass((PsiFile)this.myFile) : null;
        VirtualFile virtualFile = this.myFile.getVirtualFile();
        this.isInContent = virtualFile != null && ModuleUtilCore.projectContainsFile((Project)this.myProject, (VirtualFile)virtualFile, (boolean)false);
        this.extensionsAllowToChangeFileSilently = virtualFile == null ? ThreeState.UNSURE : SilentChangeVetoer.extensionsAllowToChangeFileSilently((Project)this.myProject, (VirtualFile)virtualFile);
    }

    public void doApplyInformationToEditor() {
        boolean shouldOptimize;
        GoImportOptimizer.Task optimizeTask = this.myOptimizeTask;
        boolean bl = shouldOptimize = optimizeTask != null && (GoImportsSettings.getInstance(this.myProject).isOptimizeImportsOnTheFly() || this.myFile instanceof GoCodeFragment);
        if (!shouldOptimize) {
            return;
        }
        if (!UIUtil.hasFocus((Component)this.myEditor.getContentComponent())) {
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && !TestModeFlags.is(TESTING_IMPORTS_OPTIMIZATION)) {
            return;
        }
        if (this.myFile.isWritable() && this.myFile.isValid() && !GoOptimizeImportsHighlightingPass.hasErrorsPreventingOptimization(this.myProject, this.myFile, this.myEditor)) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (this.myEditor.getDocument().getModificationStamp() == this.myStamp && this.timeToOptimizeImportsOnTheFly(this.myProject, this.myFile, this.myEditor)) {
                    GoOptimizeImportsHighlightingPass.optimizeImportsOnTheFly(this.myEditor, this.myFile, optimizeTask);
                }
            }, ModalityState.defaultModalityState());
        }
    }

    private static boolean hasErrorsPreventingOptimization(@NotNull Project project, @NotNull GoFile file2, @NotNull Editor editor) {
        GoImportList importList;
        if (project == null) {
            GoOptimizeImportsHighlightingPass.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            GoOptimizeImportsHighlightingPass.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            GoOptimizeImportsHighlightingPass.$$$reportNull$$$0(5);
        }
        if ((importList = file2.getImportList()) == null || importList.getImportDeclarationList().isEmpty()) {
            return true;
        }
        DaemonCodeAnalyzerEx codeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx((Project)project);
        if (!codeAnalyzer.isHighlightingAvailable((PsiFile)file2)) {
            return true;
        }
        return GoOptimizeImportsHighlightingPass.containsErrorsPreventingOptimize(importList, editor.getDocument(), project);
    }

    private boolean timeToOptimizeImportsOnTheFly(@NotNull Project project, @NotNull GoFile file2, @NotNull Editor editor) {
        if (project == null) {
            GoOptimizeImportsHighlightingPass.$$$reportNull$$$0(6);
        }
        if (file2 == null) {
            GoOptimizeImportsHighlightingPass.$$$reportNull$$$0(7);
        }
        if (editor == null) {
            GoOptimizeImportsHighlightingPass.$$$reportNull$$$0(8);
        }
        if (project.isDisposed() || editor.isDisposed()) {
            return false;
        }
        UndoManager undoManager = UndoManager.getInstance((Project)project);
        if (undoManager.isUndoInProgress() || undoManager.isRedoInProgress()) {
            return false;
        }
        GoImportList importList = file2.getImportList();
        if (importList == null) {
            return false;
        }
        CaretModel caretModel = editor.getCaretModel();
        TextRange importsRange = importList.getTextRange();
        if (importsRange.contains(caretModel.getOffset()) || importsRange.contains(caretModel.getVisualLineStart())) {
            return false;
        }
        return DaemonListeners.canChangeFileSilently((PsiFileSystemItem)file2, (boolean)this.isInContent, (ThreeState)this.extensionsAllowToChangeFileSilently);
    }

    private static void optimizeImportsOnTheFly(@NotNull Editor editor, @NotNull GoFile file2, @NotNull GoImportOptimizer.Task task2) {
        if (editor == null) {
            GoOptimizeImportsHighlightingPass.$$$reportNull$$$0(9);
        }
        if (file2 == null) {
            GoOptimizeImportsHighlightingPass.$$$reportNull$$$0(10);
        }
        if (task2 == null) {
            GoOptimizeImportsHighlightingPass.$$$reportNull$$$0(11);
        }
        PsiDocumentManager.getInstance((Project)file2.getProject()).commitAllDocuments();
        if (task2 == GoImportOptimizer.RESET_MANUAL_IMPORTS_TASK) {
            GoManualImportDetector.resetManualImport((PsiFile)file2);
        } else if (task2 != GoImportOptimizer.EMPTY_TASK) {
            DocumentUtil.writeInRunUndoTransparentAction(() -> {
                task2.run();
                PsiDocumentManager.getInstance((Project)file2.getProject()).doPostponedOperationsAndUnblockDocument(editor.getDocument());
            });
        }
    }

    private static boolean containsErrorsPreventingOptimize(@NotNull GoImportList importList, @NotNull Document document, @NotNull Project project) {
        if (importList == null) {
            GoOptimizeImportsHighlightingPass.$$$reportNull$$$0(12);
        }
        if (document == null) {
            GoOptimizeImportsHighlightingPass.$$$reportNull$$$0(13);
        }
        if (project == null) {
            GoOptimizeImportsHighlightingPass.$$$reportNull$$$0(14);
        }
        TextRange importsRange = importList.getTextRange();
        return !DaemonCodeAnalyzerEx.processHighlights((Document)document, (Project)project, (HighlightSeverity)HighlightSeverity.ERROR, (int)0, (int)document.getTextLength(), error -> {
            int infoEnd;
            int infoStart = error.getActualStartOffset();
            return importsRange.containsRange(infoStart, infoEnd = error.getActualEndOffset()) && error.type.equals((Object)HighlightInfoType.ERROR);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 3: 
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importList";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        objectArray2[1] = "com/goide/highlighting/GoOptimizeImportsHighlightingPass";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doCollectInformation";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "hasErrorsPreventingOptimization";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "timeToOptimizeImportsOnTheFly";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "optimizeImportsOnTheFly";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "containsErrorsPreventingOptimize";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

