/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting.errors;

import com.goide.highlighting.GoAnnotationHolder;
import com.goide.highlighting.errors.GoSpecCheckerBase;
import com.goide.i18n.GoBundle;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoInspectionMessageWithI18n;
import com.goide.psi.GoLabelDefinition;
import com.goide.psi.GoLabeledStatement;
import com.goide.psi.GoReferencesSearch;
import com.goide.psi.GoStatement;
import com.goide.quickfix.GoRenameToBlankQuickFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoLabelScopesSpecChecker
extends GoSpecCheckerBase {
    public GoLabelScopesSpecChecker(@NotNull GoAnnotationHolder holder) {
        if (holder == null) {
            GoLabelScopesSpecChecker.$$$reportNull$$$0(0);
        }
        super(holder);
    }

    @Override
    public void visitLabelDefinition(@NotNull GoLabelDefinition o) {
        if (o == null) {
            GoLabelScopesSpecChecker.$$$reportNull$$$0(1);
        }
        if (o.isBlank()) {
            return;
        }
        if (GoReferencesSearch.search((PsiElement)o, o.getUseScope(), true).findFirst() == null) {
            GoInspectionMessageWithI18n message = GoInspectionMessageWithI18n.message("go.inspection.unused.label.message", GoLabelScopesSpecChecker.code(o));
            AnnotationBuilder annotation = this.myHolder.newErrorAnnotation(o, (GoInspectionMessage)message);
            annotation = GoLabelScopesSpecChecker.withQuickFix(annotation, (LocalQuickFix)new GoRenameToBlankQuickFix(o), o, message);
            annotation = GoLabelScopesSpecChecker.withQuickFix(annotation, new GoDeleteLabelStatementQuickFix(o.getName()), o, message);
            annotation.create();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        objectArray2[1] = "com/goide/highlighting/errors/GoLabelScopesSpecChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitLabelDefinition";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class GoDeleteLabelStatementQuickFix
    implements LocalQuickFix {
        private final String myLabelName;

        private GoDeleteLabelStatementQuickFix(@Nullable String labelName) {
            this.myLabelName = labelName;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            String string = this.myLabelName != null ? GoBundle.message((String)"go.fix.delete.text", (Object[])new Object[]{GoBundle.message((String)"go.terms.label", (Object[])new Object[0]), this.myLabelName}) : this.getFamilyName();
            if (string == null) {
                GoDeleteLabelStatementQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = GoBundle.message((String)"go.fix.delete.name", (Object[])new Object[]{GoBundle.message((String)"go.terms.label", (Object[])new Object[0])});
            if (string == null) {
                GoDeleteLabelStatementQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            GoStatement innerStatement;
            PsiElement parent;
            PsiElement element;
            if (project == null) {
                GoDeleteLabelStatementQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                GoDeleteLabelStatementQuickFix.$$$reportNull$$$0(3);
            }
            if ((element = descriptor.getPsiElement()) instanceof GoLabelDefinition && element.isValid() && (parent = element.getParent()) instanceof GoLabeledStatement && (innerStatement = ((GoLabeledStatement)parent).getStatement()) != null) {
                parent.replace((PsiElement)innerStatement);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/highlighting/errors/GoLabelScopesSpecChecker$GoDeleteLabelStatementQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/highlighting/errors/GoLabelScopesSpecChecker$GoDeleteLabelStatementQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

