/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections;

import com.goide.i18n.GoBundle;
import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoStringLiteral;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoElementFactory;
import com.goide.utils.GoStringUtil;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoConvertStringLiteralsInspection
extends GoInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(final @NotNull GoProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            GoConvertStringLiteralsInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            GoConvertStringLiteralsInspection.$$$reportNull$$$0(1);
        }
        return new GoVisitor(this){

            @Override
            public void visitStringLiteral(@NotNull GoStringLiteral o) {
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitStringLiteral(o);
                GoInspectionMessage problemDescription = GoConvertStringLiteralsInspection.message("go.inspection.problem.convert.string.literals");
                holder.registerProblem((PsiElement)o, problemDescription, new LocalQuickFix[]{new ConvertStringLiteralQuickFix(o)});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/goide/inspections/GoConvertStringLiteralsInspection$1", "visitStringLiteral"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/goide/inspections/GoConvertStringLiteralsInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ConvertStringLiteralQuickFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        @IntentionName
        private final String text;

        protected ConvertStringLiteralQuickFix(@NotNull GoStringLiteral element) {
            if (element == null) {
                ConvertStringLiteralQuickFix.$$$reportNull$$$0(0);
            }
            super((PsiElement)element);
            this.text = ConvertStringLiteralQuickFix.isDoubleQuotedString(element) ? GoBundle.message((String)"go.fix.convert.double.quoted.string.to.raw.string", (Object[])new Object[0]) : GoBundle.message((String)"go.fix.convert.raw.string.to.double.quoted.string", (Object[])new Object[0]);
        }

        @IntentionName
        @NotNull
        public String getText() {
            String string = this.text;
            if (string == null) {
                ConvertStringLiteralQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                ConvertStringLiteralQuickFix.$$$reportNull$$$0(2);
            }
            if (psiFile == null) {
                ConvertStringLiteralQuickFix.$$$reportNull$$$0(3);
            }
            if (startElement == null) {
                ConvertStringLiteralQuickFix.$$$reportNull$$$0(4);
            }
            if (endElement == null) {
                ConvertStringLiteralQuickFix.$$$reportNull$$$0(5);
            }
            GoStringLiteral stringLiteral = (GoStringLiteral)ObjectUtils.tryCast((Object)startElement, GoStringLiteral.class);
            assert (stringLiteral != null);
            Document document = stringLiteral.getContainingFile().getViewProvider().getDocument();
            ConvertStringLiteralQuickFix.replaceStringLiteral(project, document, stringLiteral);
        }

        private static void replaceStringLiteral(@NotNull Project project, @NotNull Document document, @NotNull GoStringLiteral stringLiteral) {
            if (project == null) {
                ConvertStringLiteralQuickFix.$$$reportNull$$$0(6);
            }
            if (document == null) {
                ConvertStringLiteralQuickFix.$$$reportNull$$$0(7);
            }
            if (stringLiteral == null) {
                ConvertStringLiteralQuickFix.$$$reportNull$$$0(8);
            }
            String text = stringLiteral.getText().substring(1, stringLiteral.getText().length() - 1);
            if (ConvertStringLiteralQuickFix.isDoubleQuotedString(stringLiteral)) {
                String unescapedText = GoStringUtil.decode((String)text).unescapedString.replaceAll("\r", "");
                if (text.contains("`")) {
                    int startOffset = stringLiteral.getTextOffset();
                    int endOffset = stringLiteral.getTextOffset() + stringLiteral.getTextLength();
                    document.replaceString(startOffset, endOffset, (CharSequence)("`" + unescapedText + "`"));
                    PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                } else {
                    ConvertStringLiteralQuickFix.replaceStringLiteral(project, stringLiteral, "`" + unescapedText + "`");
                }
            } else {
                String escapedText = GoStringUtil.escapeString(text);
                ConvertStringLiteralQuickFix.replaceStringLiteral(project, stringLiteral, "\"" + escapedText + "\"");
            }
        }

        private static boolean isDoubleQuotedString(@NotNull GoStringLiteral literal) {
            if (literal == null) {
                ConvertStringLiteralQuickFix.$$$reportNull$$$0(9);
            }
            return literal.getString() != null;
        }

        private static void replaceStringLiteral(@NotNull Project project, @NotNull GoStringLiteral stringLiteral, String newText) {
            if (project == null) {
                ConvertStringLiteralQuickFix.$$$reportNull$$$0(10);
            }
            if (stringLiteral == null) {
                ConvertStringLiteralQuickFix.$$$reportNull$$$0(11);
            }
            GoStringLiteral newLiteral = GoElementFactory.createStringLiteral(project, newText);
            stringLiteral.replace(newLiteral);
        }

        @NotNull
        public String getFamilyName() {
            String string = GoBundle.message((String)"go.inspection.convert.string.literals.display.name", (Object[])new Object[0]);
            if (string == null) {
                ConvertStringLiteralQuickFix.$$$reportNull$$$0(12);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 12 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/inspections/GoConvertStringLiteralsInspection$ConvertStringLiteralQuickFix";
                    break;
                }
                case 2: 
                case 6: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 8: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stringLiteral";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "literal";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/inspections/GoConvertStringLiteralsInspection$ConvertStringLiteralQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 12: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceStringLiteral";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "isDoubleQuotedString";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 12 -> new IllegalStateException(string);
            };
        }
    }
}

