/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections;

import com.goide.psi.GoStringLiteral;
import com.goide.util.GoStringLiteralEscaper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoDecodedStringLiteralRangeConverter {
    private static final Logger LOG = Logger.getInstance(GoDecodedStringLiteralRangeConverter.class);
    @NotNull
    private final GoStringLiteral myLiteral;
    private final boolean myIgnoreQuotes;
    @Nullable
    private TextRange myLiteralRange;
    @Nullable
    private GoStringLiteralEscaper myLiteralEscaper;

    public GoDecodedStringLiteralRangeConverter(@NotNull GoStringLiteral literal) {
        if (literal == null) {
            GoDecodedStringLiteralRangeConverter.$$$reportNull$$$0(0);
        }
        this(literal, true);
    }

    public GoDecodedStringLiteralRangeConverter(@NotNull GoStringLiteral literal, boolean ignoreQuotes) {
        if (literal == null) {
            GoDecodedStringLiteralRangeConverter.$$$reportNull$$$0(1);
        }
        this.myLiteral = literal;
        this.myIgnoreQuotes = ignoreQuotes;
    }

    @Nullable
    public TextRange computeRange(int rangeStartInDecodedString, int rangeEndInDecodedString) {
        if (this.myLiteralRange == null || this.myLiteralEscaper == null) {
            this.myLiteralRange = this.myIgnoreQuotes ? ElementManipulators.getManipulator((PsiElement)this.myLiteral).getRangeInElement((PsiElement)this.myLiteral) : TextRange.from((int)0, (int)this.myLiteral.getTextLength());
            this.myLiteralEscaper = this.myLiteral.createLiteralTextEscaper();
            this.myLiteralEscaper.decode(this.myLiteralRange, new StringBuilder());
        }
        int start = this.myLiteralEscaper.getOffsetInHost(rangeStartInDecodedString, this.myLiteralRange);
        int end = this.myLiteralEscaper.getOffsetInHost(rangeEndInDecodedString, this.myLiteralRange);
        if (start == -1 || end == -1) {
            return null;
        }
        if (start > end) {
            LOG.error(String.format("Bad text range, start: %s, end: %s, token start: %s, token end: %s, string literal: %s", start, end, rangeStartInDecodedString, rangeEndInDecodedString, this.myLiteral.getText()));
            return null;
        }
        return new TextRange(start, end);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "com/goide/inspections/GoDecodedStringLiteralRangeConverter", "<init>"));
    }
}

