/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections;

import com.goide.i18n.GoBundle;
import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoBuiltinCallExpr;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoDeferStatement;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFunctionType;
import com.goide.psi.GoGoStatement;
import com.goide.psi.GoStatement;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.quickfix.GoDeleteQuickFix;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoDeferGoInspection
extends GoInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(final @NotNull GoProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            GoDeferGoInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            GoDeferGoInspection.$$$reportNull$$$0(1);
        }
        return new GoVisitor(){

            @Override
            public void visitDeferStatement(@NotNull GoDeferStatement o) {
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitDeferStatement(o);
                GoExpression expression = o.getExpression();
                if (expression instanceof GoCallExpr) {
                    GoCallExpr callExpr = (GoCallExpr)expression;
                    if (GoPsiImplUtil.isPanic(callExpr)) {
                        holder.registerProblem((PsiElement)o, GoDeferGoInspection.message("go.inspection.defer.or.go.should.not.call.function.message", new Object[]{"defer", "panic()"}), GoDeferGoInspection.this.nonDefaultHighlightingType(ProblemHighlightType.WEAK_WARNING, o), GoDeleteQuickFix.Fixes.DELETE_DEFER_STATEMENT_FIX);
                        return;
                    }
                    if (GoPsiImplUtil.isRecover(callExpr)) {
                        holder.registerProblem((PsiElement)o, GoDeferGoInspection.message("go.inspection.defer.or.go.should.not.call.function.message", new Object[]{"defer", "recover()"}), GoDeferGoInspection.this.nonDefaultHighlightingType(ProblemHighlightType.WEAK_WARNING, o), new GoReplaceWithCorrectDeferRecoverQuickFix());
                    }
                }
            }

            @Override
            public void visitGoStatement(@NotNull GoGoStatement o) {
                if (o == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitGoStatement(o);
                GoExpression expression = o.getExpression();
                if (expression instanceof GoCallExpr) {
                    GoCallExpr callExpr = (GoCallExpr)expression;
                    if (GoPsiImplUtil.isPanic(callExpr)) {
                        holder.registerProblem((PsiElement)o, GoDeferGoInspection.message("go.inspection.defer.or.go.should.not.call.function.message", new Object[]{"go", "panic()"}), GoDeferGoInspection.this.nonDefaultHighlightingType(ProblemHighlightType.WEAK_WARNING, o), GoDeleteQuickFix.Fixes.DELETE_GO_STATEMENT_FIX);
                        return;
                    }
                    if (GoPsiImplUtil.isRecover(callExpr)) {
                        holder.registerProblem((PsiElement)o, GoDeferGoInspection.message("go.inspection.defer.or.go.should.not.call.function.message", new Object[]{"go", "recover()"}), GoDeferGoInspection.this.nonDefaultHighlightingType(ProblemHighlightType.WEAK_WARNING, o), GoDeleteQuickFix.Fixes.DELETE_GO_STATEMENT_FIX);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "o";
                objectArray2[1] = "com/goide/inspections/GoDeferGoInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitDeferStatement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitGoStatement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/goide/inspections/GoDeferGoInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class GoReplaceWithCorrectDeferRecoverQuickFix
    implements LocalQuickFix {
        private GoReplaceWithCorrectDeferRecoverQuickFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = GoBundle.message((String)"go.fix.replace.with.correct.defer.name", (Object[])new Object[0]);
            if (string == null) {
                GoReplaceWithCorrectDeferRecoverQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            if (project == null) {
                GoReplaceWithCorrectDeferRecoverQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                GoReplaceWithCorrectDeferRecoverQuickFix.$$$reportNull$$$0(2);
            }
            if ((element = descriptor.getPsiElement()) == null || !element.isValid()) {
                return;
            }
            if (element instanceof GoStatement) {
                element.replace((PsiElement)GoElementFactory.createDeferStatement(project, "func() {\n\tif r := recover(); r != nil {\n\t\t\n\t}\n\t}()}"));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/inspections/GoDeferGoInspection$GoReplaceWithCorrectDeferRecoverQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/inspections/GoDeferGoInspection$GoReplaceWithCorrectDeferRecoverQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class GoAddParensQuickFix
    implements LocalQuickFix {
        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = GoBundle.message((String)"go.fix.add.function.call.name", (Object[])new Object[0]);
            if (string == null) {
                GoAddParensQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                GoAddParensQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                GoAddParensQuickFix.$$$reportNull$$$0(2);
            }
            GoAddParensQuickFix.addParensIfNeeded(project, descriptor.getStartElement());
        }

        public static PsiElement addParensIfNeeded(@NotNull Project project, @Nullable PsiElement element) {
            if (project == null) {
                GoAddParensQuickFix.$$$reportNull$$$0(3);
            }
            if (element instanceof GoExpression && element.isValid() && !(element instanceof GoCallExpr) && !(element instanceof GoBuiltinCallExpr) && ((GoExpression)element).getGoType(null) instanceof GoFunctionType) {
                return element.replace((PsiElement)GoElementFactory.createExpression(project, element.getText() + "()"));
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/inspections/GoDeferGoInspection$GoAddParensQuickFix";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/inspections/GoDeferGoInspection$GoAddParensQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "addParensIfNeeded";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

