/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections;

import com.goide.GoTypes;
import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoAssignmentStatement;
import com.goide.psi.GoBinaryExpr;
import com.goide.psi.GoExpression;
import com.goide.psi.GoType;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.util.Value;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoDivisionByZeroInspection
extends GoInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(final @NotNull GoProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            GoDivisionByZeroInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            GoDivisionByZeroInspection.$$$reportNull$$$0(1);
        }
        return new GoVisitor(this){

            @Override
            public void visitBinaryExpr(@NotNull GoBinaryExpr binaryExpr) {
                boolean isDivisionByNumeric;
                IElementType operatorType;
                if (binaryExpr == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitBinaryExpr(binaryExpr);
                PsiElement operator = binaryExpr.getOperator();
                IElementType iElementType = operatorType = operator != null ? operator.getNode().getElementType() : null;
                if (operatorType != GoTypes.QUOTIENT && operatorType != GoTypes.REMAINDER) {
                    return;
                }
                GoExpression rightExpr = binaryExpr.getRight();
                GoType rightExprType = GoDivisionByZeroInspection.getGoType(rightExpr);
                boolean bl = isDivisionByNumeric = operatorType == GoTypes.QUOTIENT && GoTypeUtil.isNumericType(rightExprType, rightExpr) || operatorType == GoTypes.REMAINDER && GoTypeUtil.isIntegerType(rightExprType, rightExpr);
                if (isDivisionByNumeric) {
                    this.checkDivisorIsZero(rightExpr, binaryExpr);
                }
            }

            @Override
            public void visitAssignmentStatement(@NotNull GoAssignmentStatement assignmentStatement) {
                boolean isDivisionByNumeric;
                IElementType operatorType;
                if (assignmentStatement == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitAssignmentStatement(assignmentStatement);
                PsiElement operator = assignmentStatement.getAssignOp().getOperator();
                IElementType iElementType = operatorType = operator != null ? operator.getNode().getElementType() : null;
                if (operatorType != GoTypes.QUOTIENT_ASSIGN && operatorType != GoTypes.REMAINDER_ASSIGN) {
                    return;
                }
                List<GoExpression> rightExprs = assignmentStatement.getExpressionList();
                if (rightExprs.size() > 1) {
                    return;
                }
                GoExpression rightExpr = (GoExpression)ContainerUtil.getFirstItem(rightExprs);
                GoType rightExprType = GoDivisionByZeroInspection.getGoType(rightExpr);
                boolean bl = isDivisionByNumeric = operatorType == GoTypes.QUOTIENT_ASSIGN && GoTypeUtil.isNumericType(rightExprType, rightExpr) || operatorType == GoTypes.REMAINDER_ASSIGN && GoTypeUtil.isIntegerType(rightExprType, rightExpr);
                if (isDivisionByNumeric) {
                    this.checkDivisorIsZero(rightExpr, assignmentStatement);
                }
            }

            private void checkDivisorIsZero(GoExpression rightExpr, @NotNull PsiElement divisionExpr) {
                Double doubleValue;
                if (divisionExpr == null) {
                    1.$$$reportNull$$$0(2);
                }
                Value value2 = rightExpr != null ? rightExpr.getValue() : null;
                Double d = doubleValue = value2 != null ? value2.getDouble() : null;
                if (doubleValue != null && doubleValue == 0.0) {
                    holder.registerProblem(divisionExpr, GoDivisionByZeroInspection.message("go.inspection.problem.division.by.zero"), new LocalQuickFix[0]);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "binaryExpr";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "assignmentStatement";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "divisionExpr";
                        break;
                    }
                }
                objectArray2[1] = "com/goide/inspections/GoDivisionByZeroInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitBinaryExpr";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitAssignmentStatement";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkDivisorIsZero";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Nullable
    private static GoType getGoType(@Nullable GoExpression rightExpr) {
        return rightExpr != null ? rightExpr.getGoUnderlyingType(null) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/goide/inspections/GoDivisionByZeroInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

