/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections;

import com.goide.documentation.GoDocumentationProvider;
import com.goide.execution.testing.GoTestFinder;
import com.goide.i18n.GoBundle;
import com.goide.inspections.GoCommentStartInspection;
import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoTypeDeclaration;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.GoVarOrConstDeclaration;
import com.goide.psi.GoVarOrConstDefinition;
import com.goide.psi.GoVarOrConstSpec;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoPsiUtil;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoExportedElementShouldHaveCommentInspection
extends GoInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(final @NotNull GoProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            GoExportedElementShouldHaveCommentInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            GoExportedElementShouldHaveCommentInspection.$$$reportNull$$$0(1);
        }
        return new GoVisitor(this){

            @Override
            public void visitTypeSpec(@NotNull GoTypeSpec o) {
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitTypeSpec(o);
                if (GoExportedElementShouldHaveCommentInspection.isAvailable(o, holder.isOnTheFly())) {
                    this.registerProblem(o);
                }
            }

            @Override
            public void visitFunctionOrMethodDeclaration(@NotNull GoFunctionOrMethodDeclaration o) {
                if (o == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitFunctionOrMethodDeclaration(o);
                if (GoExportedElementShouldHaveCommentInspection.isAvailable(o, holder.isOnTheFly())) {
                    this.registerProblem(o);
                }
            }

            @Override
            public void visitVarOrConstDefinition(@NotNull GoVarOrConstDefinition o) {
                if (o == null) {
                    1.$$$reportNull$$$0(2);
                }
                super.visitVarOrConstDefinition(o);
                if (GoExportedElementShouldHaveCommentInspection.isAvailable(o, holder.isOnTheFly())) {
                    this.registerProblem(o);
                }
            }

            private void registerProblem(@NotNull GoNamedElement o) {
                PsiElement identifier;
                if (o == null) {
                    1.$$$reportNull$$$0(3);
                }
                if ((identifier = o.getIdentifier()) == null) {
                    return;
                }
                String description = UsageViewUtil.getType((PsiElement)o);
                GoInspectionMessage message = GoExportedElementShouldHaveCommentInspection.message("go.inspection.problem.exported.element.should.have.comment", new Object[]{description, REF});
                if (GoExportedElementShouldHaveCommentInspection.isCommonMethodOrPrivate(o)) {
                    holder.registerProblem(identifier, message, ProblemHighlightType.INFORMATION, new GoAddCommentQuickFix());
                } else {
                    holder.registerProblem(identifier, message, new GoAddCommentQuickFix());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "o";
                objectArray2[1] = "com/goide/inspections/GoExportedElementShouldHaveCommentInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitTypeSpec";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitFunctionOrMethodDeclaration";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitVarOrConstDefinition";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "registerProblem";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static boolean isCommonMethodOrPrivate(@NotNull GoNamedElement o) {
        if (o == null) {
            GoExportedElementShouldHaveCommentInspection.$$$reportNull$$$0(2);
        }
        return GoCommentStartInspection.isCommonMethod(o) || !o.isPublic();
    }

    private static boolean isAvailable(@NotNull GoTypeSpec o, boolean isOnTheFly) {
        if (o == null) {
            GoExportedElementShouldHaveCommentInspection.$$$reportNull$$$0(3);
        }
        if (!GoExportedElementShouldHaveCommentInspection.isAllowed(o, isOnTheFly)) {
            return false;
        }
        GoTypeDeclaration typeDeclaration = (GoTypeDeclaration)ObjectUtils.tryCast((Object)o.getParent(), GoTypeDeclaration.class);
        if (!GoPsiUtil.isTopLevelDeclaration(typeDeclaration)) {
            return false;
        }
        return GoDocumentationProvider.getUpperComments(o).isEmpty() && GoDocumentationProvider.getUpperComments(typeDeclaration).isEmpty();
    }

    private static boolean isAvailable(@NotNull GoFunctionOrMethodDeclaration o, boolean isOnTheFly) {
        if (o == null) {
            GoExportedElementShouldHaveCommentInspection.$$$reportNull$$$0(4);
        }
        if (!GoExportedElementShouldHaveCommentInspection.isAllowed(o, isOnTheFly)) {
            return false;
        }
        return GoDocumentationProvider.getUpperComments(o).isEmpty();
    }

    private static boolean isAvailable(@NotNull GoVarOrConstDefinition o, boolean isOnTheFly) {
        if (o == null) {
            GoExportedElementShouldHaveCommentInspection.$$$reportNull$$$0(5);
        }
        if (!GoExportedElementShouldHaveCommentInspection.isAllowed(o, isOnTheFly)) {
            return false;
        }
        GoVarOrConstSpec spec = (GoVarOrConstSpec)ObjectUtils.tryCast((Object)o.getParent(), GoVarOrConstSpec.class);
        GoVarOrConstDeclaration declaration = (GoVarOrConstDeclaration)PsiTreeUtil.getParentOfType((PsiElement)o, GoVarOrConstDeclaration.class);
        if (spec == null || !GoPsiUtil.isTopLevelDeclaration(declaration) || spec.getDefinitionList().size() > 1) {
            return false;
        }
        return GoDocumentationProvider.getUpperComments(spec).isEmpty() && !GoExportedElementShouldHaveCommentInspection.varOrConstDeclarationHasComment(spec);
    }

    private static boolean isAllowed(@NotNull GoNamedElement o, boolean isOnTheFly) {
        if (o == null) {
            GoExportedElementShouldHaveCommentInspection.$$$reportNull$$$0(6);
        }
        return !o.isBlank() && !GoTestFinder.isTestFile((PsiFile)o.getContainingFile()) && (!GoExportedElementShouldHaveCommentInspection.isCommonMethodOrPrivate(o) || isOnTheFly);
    }

    private static boolean varOrConstDeclarationHasComment(@NotNull GoVarOrConstSpec o) {
        GoVarOrConstDeclaration declaration;
        if (o == null) {
            GoExportedElementShouldHaveCommentInspection.$$$reportNull$$$0(7);
        }
        return (declaration = (GoVarOrConstDeclaration)ObjectUtils.tryCast((Object)o.getParent(), GoVarOrConstDeclaration.class)) != null && !GoDocumentationProvider.getUpperComments(declaration).isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        objectArray2[1] = "com/goide/inspections/GoExportedElementShouldHaveCommentInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isCommonMethodOrPrivate";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isAllowed";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "varOrConstDeclarationHasComment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class GoAddCommentQuickFix
    implements LocalQuickFix {
        private GoAddCommentQuickFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = GoBundle.message((String)"go.fix.add.comment.name", (Object[])new Object[0]);
            if (string == null) {
                GoAddCommentQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement comment;
            PsiElement element;
            if (project == null) {
                GoAddCommentQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                GoAddCommentQuickFix.$$$reportNull$$$0(2);
            }
            if ((element = descriptor.getPsiElement()) == null || !element.isValid()) {
                return;
            }
            PsiElement elementToComment = GoAddCommentQuickFix.getElementToComment(element);
            GoNamedElement o = (GoNamedElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)elementToComment, (Class[])new Class[]{GoNamedElement.class});
            PsiElement psiElement = comment = o != null ? GoAddCommentQuickFix.createComment(o, project) : null;
            if (comment == null) {
                return;
            }
            PsiElement anchor = GoAddCommentQuickFix.getAnchor(o);
            if (anchor == null) {
                return;
            }
            PsiElement inserted = GoAddCommentQuickFix.addBefore(comment, anchor);
            Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
            if (inserted != null && editor != null) {
                CaretModel caretModel = editor.getCaretModel();
                caretModel.moveToOffset(inserted.getTextRange().getStartOffset() + inserted.getTextLength());
            }
        }

        private static PsiElement getAnchor(GoNamedElement o) {
            if (o instanceof GoFunctionOrMethodDeclaration) {
                return o;
            }
            if (o instanceof GoTypeSpec) {
                GoTypeDeclaration declaration = (GoTypeDeclaration)ObjectUtils.tryCast((Object)o.getParent(), GoTypeDeclaration.class);
                if (declaration == null) {
                    return null;
                }
                return declaration.getTypeSpecList().size() == 1 && declaration.getLparen() == null ? declaration : o;
            }
            if (o instanceof GoVarOrConstDefinition) {
                GoVarOrConstDeclaration declaration = (GoVarOrConstDeclaration)PsiTreeUtil.getParentOfType((PsiElement)o.getParent(), GoVarOrConstDeclaration.class);
                if (declaration == null) {
                    return null;
                }
                return declaration.getSpecList().size() == 1 && declaration.getLparen() == null ? declaration : o;
            }
            return null;
        }

        private static PsiElement addBefore(@NotNull PsiElement element, @NotNull PsiElement anchor) {
            if (element == null) {
                GoAddCommentQuickFix.$$$reportNull$$$0(3);
            }
            if (anchor == null) {
                GoAddCommentQuickFix.$$$reportNull$$$0(4);
            }
            String indent = GoAddCommentQuickFix.getIndent(anchor);
            PsiElement inserted = anchor.getParent().addBefore(element, anchor);
            if (indent != null) {
                inserted.getNode().getTreeParent().addLeaf(TokenType.WHITE_SPACE, (CharSequence)("\n" + indent), inserted.getNextSibling().getNode());
            }
            return inserted;
        }

        private static String getIndent(PsiElement anchor) {
            PsiElement prevElement = PsiTreeUtil.prevLeaf((PsiElement)anchor);
            if (prevElement instanceof PsiWhiteSpace) {
                String text = prevElement.getText();
                return text.substring(text.lastIndexOf(10) + 1);
            }
            return null;
        }

        @Nullable
        private static PsiElement getElementToComment(@NotNull PsiElement element) {
            PsiElement parent;
            if (element == null) {
                GoAddCommentQuickFix.$$$reportNull$$$0(5);
            }
            if ((parent = element.getParent()) instanceof GoFunctionOrMethodDeclaration || parent instanceof GoVarOrConstDefinition) {
                return parent;
            }
            if (parent != null && parent.getParent() instanceof GoTypeSpec) {
                return parent.getParent();
            }
            return null;
        }

        @Nullable
        private static PsiElement createComment(@NotNull GoNamedElement o, @NotNull Project project) {
            String name;
            if (o == null) {
                GoAddCommentQuickFix.$$$reportNull$$$0(6);
            }
            if (project == null) {
                GoAddCommentQuickFix.$$$reportNull$$$0(7);
            }
            return StringUtil.isEmpty((String)(name = o.getName())) ? null : GoElementFactory.createLineCommentFromText(project, " " + name + " ");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5, 6, 7 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/inspections/GoExportedElementShouldHaveCommentInspection$GoAddCommentQuickFix";
                    break;
                }
                case 1: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/inspections/GoExportedElementShouldHaveCommentInspection$GoAddCommentQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addBefore";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getElementToComment";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "createComment";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
            };
        }
    }
}

