/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections;

import com.goide.i18n.GoBundle;
import com.goide.inspections.core.GoMethodDescriptor;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptTable;
import com.intellij.codeInspection.options.OptTableColumn;
import com.intellij.codeInspection.options.OptionContainer;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoMethodDescriptors
implements OptionContainer {
    private final List<String> myImportPaths;
    private final List<String> myReceivers;
    private final List<String> myMethodNames;

    public GoMethodDescriptors() {
        this.myImportPaths = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myReceivers = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myMethodNames = ContainerUtil.createLockFreeCopyOnWriteList();
    }

    public GoMethodDescriptors(@NotNull GoMethodDescriptors defaults) {
        if (defaults == null) {
            GoMethodDescriptors.$$$reportNull$$$0(0);
        }
        this.myImportPaths = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myReceivers = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myMethodNames = ContainerUtil.createLockFreeCopyOnWriteList();
        this.addAll(defaults);
    }

    public void addAll(@NotNull GoMethodDescriptors defaults) {
        if (defaults == null) {
            GoMethodDescriptors.$$$reportNull$$$0(1);
        }
        this.myImportPaths.addAll(defaults.myImportPaths);
        this.myReceivers.addAll(defaults.myReceivers);
        this.myMethodNames.addAll(defaults.myMethodNames);
    }

    public void add(@NotNull String importPath, @NotNull String receiver, @NotNull String methodName) {
        if (importPath == null) {
            GoMethodDescriptors.$$$reportNull$$$0(2);
        }
        if (receiver == null) {
            GoMethodDescriptors.$$$reportNull$$$0(3);
        }
        if (methodName == null) {
            GoMethodDescriptors.$$$reportNull$$$0(4);
        }
        this.myImportPaths.add(importPath);
        this.myReceivers.add(receiver);
        this.myMethodNames.add(methodName);
    }

    boolean contains(@Nullable String importPath, @Nullable String receiver, @Nullable String methodName) {
        if (importPath == null || receiver == null || methodName == null) {
            return false;
        }
        for (int i = 0; i < this.myImportPaths.size(); ++i) {
            if (!importPath.equals(this.myImportPaths.get(i)) || !receiver.equals(this.myReceivers.get(i)) || !methodName.equals(this.myMethodNames.get(i))) continue;
            return true;
        }
        return false;
    }

    void clear() {
        this.myImportPaths.clear();
        this.myReceivers.clear();
        this.myMethodNames.clear();
    }

    @NotNull
    public List<String> getImportPaths() {
        List<String> list = this.myImportPaths;
        if (list == null) {
            GoMethodDescriptors.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public List<String> getReceivers() {
        List<String> list = this.myReceivers;
        if (list == null) {
            GoMethodDescriptors.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public List<String> getMethodNames() {
        List<String> list = this.myMethodNames;
        if (list == null) {
            GoMethodDescriptors.$$$reportNull$$$0(7);
        }
        return list;
    }

    public List<GoMethodDescriptor> getDescriptors() {
        ArrayList<GoMethodDescriptor> result = new ArrayList<GoMethodDescriptor>(this.myImportPaths.size());
        for (int i = 0; i < this.myImportPaths.size(); ++i) {
            result.add(new GoMethodDescriptor(this.myImportPaths.get(i), this.myReceivers.get(i), this.myMethodNames.get(i)));
        }
        return result;
    }

    public static void readList(@NotNull Element node2, @NotNull GoMethodDescriptors dst) {
        Element items;
        if (node2 == null) {
            GoMethodDescriptors.$$$reportNull$$$0(8);
        }
        if (dst == null) {
            GoMethodDescriptors.$$$reportNull$$$0(9);
        }
        if ((items = node2.getChild("methods")) == null) {
            return;
        }
        dst.clear();
        for (Element item : items.getChildren("method")) {
            String importPath = item.getAttributeValue("importPath");
            String receiver = item.getAttributeValue("receiver");
            String name = item.getAttributeValue("name");
            if (importPath == null || receiver == null || name == null) continue;
            dst.add(importPath, receiver, name);
        }
    }

    public void writeList(@NotNull Element node2, @NotNull GoMethodDescriptors defaults) {
        if (node2 == null) {
            GoMethodDescriptors.$$$reportNull$$$0(10);
        }
        if (defaults == null) {
            GoMethodDescriptors.$$$reportNull$$$0(11);
        }
        if (defaults.myImportPaths.equals(this.myImportPaths) && defaults.myReceivers.equals(this.myReceivers) && defaults.myMethodNames.equals(this.myMethodNames)) {
            return;
        }
        Element itemsElement = new Element("methods");
        HashSet<String> unique = new HashSet<String>();
        for (int i = 0; i < this.myImportPaths.size(); ++i) {
            String methodName;
            String receiver;
            String importPath = this.myImportPaths.get(i);
            if (!unique.add(GoMethodDescriptors.asString(importPath, receiver = this.myReceivers.get(i), methodName = this.myMethodNames.get(i)))) continue;
            Element element = new Element("method");
            element.setAttribute("importPath", importPath);
            element.setAttribute("receiver", receiver);
            element.setAttribute("name", methodName);
            itemsElement.addContent(element);
        }
        node2.addContent(itemsElement);
    }

    @NotNull
    private static String asString(@NotNull String importPath, @NotNull String receiver, @NotNull String methodName) {
        if (importPath == null) {
            GoMethodDescriptors.$$$reportNull$$$0(12);
        }
        if (receiver == null) {
            GoMethodDescriptors.$$$reportNull$$$0(13);
        }
        if (methodName == null) {
            GoMethodDescriptors.$$$reportNull$$$0(14);
        }
        String receiverName = StringUtil.trimStart((String)receiver, (String)"*");
        String string = String.format("(%s%s.%s).%s", receiver.startsWith("*") ? "*" : "", importPath, receiverName, methodName);
        if (string == null) {
            GoMethodDescriptors.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Nullable
    public static Trinity<String, String, String> asParts(@NotNull String methodDescriptor) {
        int lastDot;
        if (methodDescriptor == null) {
            GoMethodDescriptors.$$$reportNull$$$0(16);
        }
        if ((lastDot = methodDescriptor.lastIndexOf(".")) == -1 || lastDot == 0 || lastDot == methodDescriptor.length() - 1) {
            return null;
        }
        String methodName = methodDescriptor.substring(lastDot + 1);
        String importPathAndReceiver = methodDescriptor.substring(0, lastDot);
        boolean isPointerReceiver = importPathAndReceiver.startsWith("(*");
        String noOpenParens = StringUtil.trimStart((String)importPathAndReceiver, (String)"(");
        String noAsterisk = StringUtil.trimStart((String)noOpenParens, (String)"*");
        String unwrapped = StringUtil.trimEnd((String)noAsterisk, (String)")");
        lastDot = unwrapped.lastIndexOf(".");
        if (lastDot == -1 || lastDot == 0 || lastDot == unwrapped.length() - 1) {
            return null;
        }
        String receiverName = unwrapped.substring(lastDot + 1);
        String importPath = unwrapped.substring(0, lastDot);
        return Trinity.create((Object)importPath, (Object)(isPointerReceiver ? "*" + receiverName : receiverName), (Object)methodName);
    }

    public OptTable getTable(@NotNull @Nls String label) {
        if (label == null) {
            GoMethodDescriptors.$$$reportNull$$$0(17);
        }
        return OptPane.table((String)label, (OptTableColumn[])new OptTableColumn[]{OptPane.column((String)"myImportPaths", (String)GoBundle.message((String)"go.inspection.options.panel.import.path", (Object[])new Object[0])), OptPane.column((String)"myReceivers", (String)GoBundle.message((String)"go.inspection.options.panel.receiver", (Object[])new Object[0])), OptPane.column((String)"myMethodNames", (String)GoBundle.message((String)"go.inspection.options.panel.method.name", (Object[])new Object[0]))});
    }

    public OptTable getTable() {
        return this.getTable("");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaults";
                break;
            }
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importPath";
                break;
            }
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
            case 4: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/inspections/GoMethodDescriptors";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dst";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodDescriptor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/inspections/GoMethodDescriptors";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportPaths";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getReceivers";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodNames";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "asString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 15: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "readList";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "writeList";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "asString";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "asParts";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getTable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 15 -> new IllegalStateException(string);
        };
    }
}

