/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections;

import com.goide.i18n.GoBundle;
import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoExpression;
import com.goide.psi.GoRangeClause;
import com.goide.psi.GoVarDefinition;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoExpressionUtil;
import com.goide.quickfix.GoDeleteRangeQuickFix;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoRedundantBlankArgInRangeInspection
extends GoInspectionBase
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(final @NotNull GoProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            GoRedundantBlankArgInRangeInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            GoRedundantBlankArgInRangeInspection.$$$reportNull$$$0(1);
        }
        return new GoVisitor(this){

            @Override
            public void visitRangeClause(@NotNull GoRangeClause o) {
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                List<GoExpression> leftExpressions = o.getLeftExpressionsList();
                PsiElement range = o.getRange();
                if (range == null) {
                    return;
                }
                if (leftExpressions.size() == 2 && GoExpressionUtil.isBlankGoReferenceExpression(leftExpressions.get(1))) {
                    if (GoExpressionUtil.isBlankGoReferenceExpression(leftExpressions.get(0))) {
                        GoRedundantBlankArgInRangeInspection.registerBlankArgumentProblem(holder, leftExpressions.get(0), range.getPrevSibling());
                    } else if (leftExpressions.get(0).getNextSibling() != null) {
                        GoRedundantBlankArgInRangeInspection.registerBlankArgumentProblem(holder, leftExpressions.get(0).getNextSibling(), leftExpressions.get(1));
                    }
                } else if (leftExpressions.size() == 1 && GoExpressionUtil.isBlankGoReferenceExpression(leftExpressions.get(0))) {
                    GoRedundantBlankArgInRangeInspection.registerBlankArgumentProblem(holder, leftExpressions.get(0), range.getPrevSibling());
                }
                List<GoVarDefinition> leftDefinitions = o.getVarDefinitionList();
                if (leftDefinitions.size() == 2 && GoRedundantBlankArgInRangeInspection.isBlankGoVarDefinition(leftDefinitions.get(1))) {
                    GoRedundantBlankArgInRangeInspection.registerBlankArgumentProblem(holder, leftDefinitions.get(0).getNextSibling(), leftDefinitions.get(1));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/goide/inspections/GoRedundantBlankArgInRangeInspection$1", "visitRangeClause"));
            }
        };
    }

    private static void registerBlankArgumentProblem(@NotNull GoProblemsHolder holder, @NotNull PsiElement start, @NotNull PsiElement end) {
        if (holder == null) {
            GoRedundantBlankArgInRangeInspection.$$$reportNull$$$0(2);
        }
        if (start == null) {
            GoRedundantBlankArgInRangeInspection.$$$reportNull$$$0(3);
        }
        if (end == null) {
            GoRedundantBlankArgInRangeInspection.$$$reportNull$$$0(4);
        }
        GoDeleteRangeQuickFix fix = new GoDeleteRangeQuickFix(start, end, GoBundle.message((String)"go.fix.delete.blank.argument.name", (Object[])new Object[0]));
        holder.registerProblem(start, end, GoRedundantBlankArgInRangeInspection.message("go.inspection.problem.redundant.blank.expression", GoRedundantBlankArgInRangeInspection.code("_")), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, holder.isOnTheFly(), new LocalQuickFix[]{fix});
    }

    private static boolean isBlankGoVarDefinition(@Nullable PsiElement o) {
        return o instanceof GoVarDefinition && o.textMatches((CharSequence)"_");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
        }
        objectArray2[1] = "com/goide/inspections/GoRedundantBlankArgInRangeInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "registerBlankArgumentProblem";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

