/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections;

import com.goide.GoTypes;
import com.goide.i18n.GoBundle;
import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoArgumentList;
import com.goide.psi.GoBinaryExpr;
import com.goide.psi.GoBuiltinArgumentList;
import com.goide.psi.GoBuiltinCallExpr;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoCompositeElement;
import com.goide.psi.GoConstSpec;
import com.goide.psi.GoConversionExpr;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFunctionLit;
import com.goide.psi.GoIndexOrSliceExpr;
import com.goide.psi.GoSignature;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeOwner;
import com.goide.psi.GoTypeReferenceExpression;
import com.goide.psi.GoVarOrConstSpec;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoExpressionUtil;
import com.goide.psi.impl.GoLightType;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.psi.impl.GoReferenceBase;
import com.goide.psi.impl.GoSizes;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.psi.impl.expectedTypes.GoExpectedTypes;
import com.goide.psi.impl.generics.GoTypeInferenceKt;
import com.goide.psi.impl.generics.GoTypeInferenceResult;
import com.goide.psi.impl.generics.GoTypeInferenceSpecificationBuilder;
import com.goide.util.GoTargetSystem;
import com.goide.util.GoUtil;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoRedundantConversionInspection
extends GoInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(final @NotNull GoProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            GoRedundantConversionInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            GoRedundantConversionInspection.$$$reportNull$$$0(1);
        }
        return new GoVisitor(){

            @Override
            public void visitCallExpr(@NotNull GoCallExpr e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                PsiElement context = GoReferenceBase.getSubstitutionContextOrSelf(e);
                this.checkConversion(e, e.getExpression(), GoPsiUtil.getTypeIfConversion(e), (GoTypeOwner)ContainerUtil.getFirstItem(e.getArgumentList().getExpressionList()), context);
            }

            @Override
            public void visitBuiltinCallExpr(@NotNull GoBuiltinCallExpr o) {
                if (o == null) {
                    1.$$$reportNull$$$0(1);
                }
                GoBuiltinArgumentList argumentList = o.getBuiltinArgumentList();
                GoType type = argumentList.getType();
                PsiElement context = GoReferenceBase.getSubstitutionContextOrSelf(o);
                if (type != null) {
                    GoTypeReferenceExpression expression = type.getTypeReferenceExpression();
                    PsiElement resolve = expression != null ? expression.resolve(null) : null;
                    this.checkConversion(o, o.getExpression(), GoPsiUtil.getTypeIfConversion(o), (GoTypeOwner)ObjectUtils.tryCast((Object)resolve, GoTypeOwner.class), context);
                } else {
                    this.checkConversion(o, o.getExpression(), GoPsiUtil.getTypeIfConversion(o), (GoTypeOwner)ContainerUtil.getFirstItem(argumentList.getExpressionList()), context);
                }
            }

            @Override
            public void visitConversionExpr(@NotNull GoConversionExpr o) {
                if (o == null) {
                    1.$$$reportNull$$$0(2);
                }
                PsiElement context = GoReferenceBase.getSubstitutionContextOrSelf(o);
                this.checkConversion(o, o.getType(), o.getType(), o.getExpression(), context);
            }

            private void checkConversion(@NotNull GoExpression conversion, @NotNull PsiElement elementToReport, @Nullable GoType conversionType, @Nullable GoTypeOwner argument, @NotNull PsiElement context) {
                ResolveState resolveState;
                GoExpectedTypes expectedTypes;
                GoSignature signature;
                if (conversion == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (elementToReport == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (conversionType == null || argument == null || GoTypeUtil.isCType(conversionType, context) || GoExpressionUtil.isNil(argument)) {
                    return;
                }
                GoType argumentType = argument.getGoType(null);
                if (argumentType == null || GoTypeUtil.isCType(argumentType, context) || 1.isUntypedValueInConstSpec(argumentType, context) || 1.isInBinaryOperatorWithUntypedArgument(conversion, argument)) {
                    return;
                }
                if (GoTypeUtil.identical(conversionType, argumentType, true, context)) {
                    this.registerProblem(elementToReport, 1.isFloatingType(argumentType, context), context);
                    return;
                }
                if (1.isLeftHandSideInLeftShift(conversion)) {
                    return;
                }
                if (1.isInVarSpecWithoutType(conversion)) {
                    return;
                }
                if (argumentType instanceof GoLightType.LightUntypedNumericType) {
                    return;
                }
                if (1.isNecessaryNumericTypesConversion(argumentType.getUnderlyingType(context), conversionType.getUnderlyingType(context), context)) {
                    return;
                }
                GoExpression callArgument = (GoExpression)GoPsiUtil.skipParens(conversion);
                GoCallExpr callExpr = 1.getCallExprByArgument(callArgument);
                if (callExpr != null && (signature = GoPsiImplUtil.getSignature(callExpr)) != null && signature.getTypeParameters() != null) {
                    ResolveState state = GoPsiImplUtil.createContextOnElement(context);
                    GoTypeInferenceResult typeInferenceResultBefore = GoTypeInferenceSpecificationBuilder.fromCall(callExpr, signature).build(state).infer();
                    GoTypeInferenceResult typeInferenceResultAfter = GoTypeInferenceSpecificationBuilder.fromCall(callExpr, signature).replaceArgument(callArgument, argument).build(state).infer();
                    if (typeInferenceResultBefore == null || typeInferenceResultAfter == null || !typeInferenceResultBefore.getOk() || !typeInferenceResultAfter.getOk()) {
                        return;
                    }
                    if (!GoTypeInferenceKt.identical(typeInferenceResultBefore, typeInferenceResultAfter, context)) {
                        return;
                    }
                }
                if (!(expectedTypes = GoTypeUtil.getExpectedTypes(conversion, context)).containInterfaceType(resolveState = GoPsiImplUtil.createContextOnElement(context)) && !expectedTypes.containDocOnlyAnyType(resolveState) && expectedTypes.areCompatibleWith(argumentType, argument, true, false, resolveState)) {
                    this.registerProblem(elementToReport, false, context);
                }
            }

            private static boolean isInBinaryOperatorWithUntypedArgument(@NotNull GoExpression conversion, @Nullable GoTypeOwner conversionArgument) {
                GoBinaryExpr binaryExpression;
                if (conversion == null) {
                    1.$$$reportNull$$$0(6);
                }
                if ((binaryExpression = (GoBinaryExpr)ObjectUtils.tryCast((Object)conversion.getParent(), GoBinaryExpr.class)) == null) {
                    return false;
                }
                IElementType operator = GoExpressionUtil.getOperatorType(binaryExpression);
                GoExpression leftArgument = binaryExpression.getLeft();
                if (operator != GoTypes.SHIFT_LEFT && operator != GoTypes.SHIFT_RIGHT) {
                    GoExpression otherArgument = conversion == leftArgument ? binaryExpression.getRight() : leftArgument;
                    return otherArgument != null && otherArgument.getGoType(null) instanceof GoLightType.LightUntypedType;
                }
                return conversion == leftArgument && conversionArgument != null && conversionArgument.getGoType(null) instanceof GoLightType.LightUntypedType;
            }

            private static boolean isLeftHandSideInLeftShift(@NotNull GoExpression conversion) {
                PsiElement psiElement;
                if (conversion == null) {
                    1.$$$reportNull$$$0(7);
                }
                if ((psiElement = conversion.getParent()) instanceof GoBinaryExpr) {
                    GoBinaryExpr binaryExpr = (GoBinaryExpr)psiElement;
                    IElementType operator = GoExpressionUtil.getOperatorType(binaryExpr);
                    return operator == GoTypes.SHIFT_LEFT && conversion == binaryExpr.getLeft();
                }
                return false;
            }

            private static boolean isUntypedValueInConstSpec(@NotNull GoType expressionType, @NotNull PsiElement context) {
                if (expressionType == null) {
                    1.$$$reportNull$$$0(8);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(9);
                }
                return expressionType instanceof GoLightType.LightUntypedType && PsiTreeUtil.getParentOfType((PsiElement)context, GoConstSpec.class) != null;
            }

            private static boolean isFloatingType(@NotNull GoType type, @Nullable PsiElement context) {
                if (type == null) {
                    1.$$$reportNull$$$0(10);
                }
                return GoTypeUtil.isComplexType(type, context) || GoTypeUtil.isFloatType(type, context);
            }

            private static boolean isInVarSpecWithoutType(@NotNull GoExpression expression) {
                GoCompositeElement parent;
                if (expression == null) {
                    1.$$$reportNull$$$0(11);
                }
                return (parent = (GoCompositeElement)PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{GoFunctionLit.class, GoCallExpr.class, GoIndexOrSliceExpr.class, GoVarOrConstSpec.class})) instanceof GoVarOrConstSpec && ((GoVarOrConstSpec)parent).getType() == null;
            }

            private static boolean isNecessaryNumericTypesConversion(@NotNull GoType argumentType, @NotNull GoType conversionType, @NotNull PsiElement context) {
                if (argumentType == null) {
                    1.$$$reportNull$$$0(12);
                }
                if (conversionType == null) {
                    1.$$$reportNull$$$0(13);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(14);
                }
                if (GoTypeUtil.isNumericType(argumentType, context) && GoTypeUtil.isNumericType(conversionType, context)) {
                    if (GoTypeUtil.isUintType(argumentType, context) != GoTypeUtil.isUintType(conversionType, context)) {
                        return true;
                    }
                    if (GoTypeUtil.isFloatType(argumentType, context) && !GoTypeUtil.isFloatType(conversionType, context)) {
                        return true;
                    }
                    GoSizes sizes = GoSizes.forTarget(GoTargetSystem.forModule(GoUtil.module(context)));
                    if (sizes.sizeOf(conversionType, context) < sizes.sizeOf(argumentType, context)) {
                        return true;
                    }
                    if (sizes.isBasicTypeWithFixedSize(conversionType, context) != sizes.isBasicTypeWithFixedSize(argumentType, context)) {
                        return true;
                    }
                }
                return false;
            }

            private void registerProblem(@NotNull PsiElement e, boolean changesSemantics, @NotNull PsiElement context) {
                if (e == null) {
                    1.$$$reportNull$$$0(15);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(16);
                }
                GoInspectionMessage message = changesSemantics ? GoRedundantConversionInspection.message("go.inspection.problem.possibly.redundant.type.conversion") : GoRedundantConversionInspection.message("go.inspection.problem.redundant.type.conversion");
                ProblemHighlightType symbol = changesSemantics ? GoRedundantConversionInspection.this.nonDefaultHighlightingType(ProblemHighlightType.WEAK_WARNING, context) : ProblemHighlightType.LIKE_UNUSED_SYMBOL;
                holder.registerProblem(e, message, symbol, new Fix(changesSemantics));
            }

            @Nullable
            private static GoCallExpr getCallExprByArgument(@NotNull GoExpression expr) {
                PsiElement grandParent;
                PsiElement parent;
                if (expr == null) {
                    1.$$$reportNull$$$0(17);
                }
                if ((parent = expr.getParent()) instanceof GoArgumentList && (grandParent = parent.getParent()) instanceof GoCallExpr) {
                    GoCallExpr callExpr = (GoCallExpr)grandParent;
                    return callExpr;
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "o";
                        break;
                    }
                    case 3: 
                    case 6: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "conversion";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "elementToReport";
                        break;
                    }
                    case 5: 
                    case 9: 
                    case 14: 
                    case 16: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expressionType";
                        break;
                    }
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 12: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "argumentType";
                        break;
                    }
                    case 13: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "conversionType";
                        break;
                    }
                    case 17: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expr";
                        break;
                    }
                }
                objectArray2[1] = "com/goide/inspections/GoRedundantConversionInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitCallExpr";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitBuiltinCallExpr";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitConversionExpr";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkConversion";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isInBinaryOperatorWithUntypedArgument";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isLeftHandSideInLeftShift";
                        break;
                    }
                    case 8: 
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isUntypedValueInConstSpec";
                        break;
                    }
                    case 10: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isFloatingType";
                        break;
                    }
                    case 11: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isInVarSpecWithoutType";
                        break;
                    }
                    case 12: 
                    case 13: 
                    case 14: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isNecessaryNumericTypesConversion";
                        break;
                    }
                    case 15: 
                    case 16: {
                        objectArray = objectArray2;
                        objectArray2[2] = "registerProblem";
                        break;
                    }
                    case 17: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getCallExprByArgument";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/goide/inspections/GoRedundantConversionInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Fix
    implements LocalQuickFix {
        private final boolean myChangesSemantics;

        protected Fix(boolean changesSemantics) {
            this.myChangesSemantics = changesSemantics;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            String string = this.myChangesSemantics ? GoBundle.message((String)"go.fix.delete.conversion.with.side.effects.name", (Object[])new Object[0]) : GoBundle.message((String)"go.fix.delete.conversion.name", (Object[])new Object[0]);
            if (string == null) {
                Fix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = GoBundle.message((String)"go.fix.delete.conversion.name", (Object[])new Object[0]);
            if (string == null) {
                Fix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            GoExpression replacement;
            PsiElement startElement;
            if (project == null) {
                Fix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                Fix.$$$reportNull$$$0(3);
            }
            if (!(startElement = descriptor.getStartElement()).isValid()) {
                return;
            }
            PsiElement e = PsiTreeUtil.getParentOfType((PsiElement)startElement, (Class[])new Class[]{GoCallExpr.class, GoBuiltinCallExpr.class, GoConversionExpr.class});
            if (e == null || !e.isValid()) {
                return;
            }
            if (e instanceof GoCallExpr) {
                GoExpression replacement2 = (GoExpression)ContainerUtil.getFirstItem(((GoCallExpr)e).getArgumentList().getExpressionList());
                if (replacement2 != null) {
                    e.replace((PsiElement)GoElementFactory.createExpression(project, this.getReplacementText(e, replacement2)));
                }
            } else if (e instanceof GoBuiltinCallExpr) {
                GoBuiltinArgumentList argumentList = ((GoBuiltinCallExpr)e).getBuiltinArgumentList();
                GoType type = argumentList.getType();
                if (type != null) {
                    e.replace((PsiElement)GoElementFactory.createExpression(project, type.getText()));
                } else {
                    GoExpression replacement3 = (GoExpression)ContainerUtil.getFirstItem(argumentList.getExpressionList());
                    if (replacement3 != null) {
                        e.replace((PsiElement)GoElementFactory.createExpression(project, this.getReplacementText(e, replacement3)));
                    }
                }
            } else if (e instanceof GoConversionExpr && (replacement = ((GoConversionExpr)e).getExpression()) != null) {
                e.replace((PsiElement)GoElementFactory.createExpression(project, this.getReplacementText(e, replacement)));
            }
        }

        public String getReplacementText(PsiElement host, GoExpression replacement) {
            return GoExpressionUtil.needParentheses(host, replacement) ? "(" + replacement.getText() + ")" : replacement.getText();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/inspections/GoRedundantConversionInspection$Fix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/inspections/GoRedundantConversionInspection$Fix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

