/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections;

import com.goide.GoTypes;
import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoCompositeElement;
import com.goide.psi.GoEmptyStatement;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoImportDeclaration;
import com.goide.psi.GoImportList;
import com.goide.psi.GoLabeledStatement;
import com.goide.psi.GoStatementsHolder;
import com.goide.psi.GoTopLevelDeclaration;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.quickfix.GoDeleteQuickFix;
import com.goide.stubs.GoTokenSets;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoRedundantSemicolonInspection
extends GoInspectionBase
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(@NotNull GoProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            GoRedundantSemicolonInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            GoRedundantSemicolonInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(semicolon -> holder.registerProblem((PsiElement)semicolon, GoRedundantSemicolonInspection.message("go.inspection.problem.redundant.semicolon"), GoDeleteQuickFix.Fixes.DELETE_SEMICOLON_FIX));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/goide/inspections/GoRedundantSemicolonInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Visitor
    extends GoVisitor {
        @NotNull
        private final Consumer<? super PsiElement> problemConsumer;

        public Visitor(@NotNull Consumer<? super PsiElement> problemConsumer) {
            if (problemConsumer == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            this.problemConsumer = problemConsumer;
        }

        @Override
        public void visitCompositeElement(@NotNull GoCompositeElement o) {
            if (o == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            super.visitCompositeElement(o);
            if (GoTokenSets.BLOCKS.contains(o.getNode().getElementType()) || o instanceof GoTopLevelDeclaration && !(o instanceof GoFunctionOrMethodDeclaration) || o instanceof GoImportDeclaration || o instanceof GoImportList) {
                this.checkBlock(o);
            }
        }

        @Override
        public void visitGoFile(@NotNull GoFile file2) {
            if (file2 == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            super.visitGoFile(file2);
            this.checkBlock((PsiElement)file2);
        }

        private void checkBlock(@NotNull PsiElement o) {
            if (o == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            ASTNode[] semicolons = o.getNode().getChildren(TokenSet.create((IElementType[])new IElementType[]{GoTypes.SEMICOLON}));
            Arrays.stream(semicolons).forEach(this::checkSemicolon);
        }

        private void checkSemicolon(@NotNull ASTNode semicolon) {
            IElementType nextElementType;
            if (semicolon == null) {
                Visitor.$$$reportNull$$$0(4);
            }
            PsiElement semicolonPsi = semicolon.getPsi();
            PsiElement prev = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)semicolonPsi);
            PsiElement next = Visitor.nextSignificantNode(semicolonPsi);
            IElementType iElementType = nextElementType = next != null ? next.getNode().getElementType() : null;
            if (prev instanceof GoLabeledStatement && ((GoLabeledStatement)prev).getStatement() instanceof GoEmptyStatement && (next == null || nextElementType != GoTypes.RBRACE)) {
                return;
            }
            PsiElement parent = semicolonPsi.getParent();
            if (next == null || GoPsiUtil.onDifferentLines(semicolonPsi, next) || nextElementType == GoTypes.RBRACE || nextElementType == GoTypes.RPAREN || parent instanceof GoStatementsHolder && (prev instanceof GoEmptyStatement || nextElementType == GoTypes.SEMICOLON)) {
                this.registerProblem(semicolonPsi);
            }
        }

        @Nullable
        private static PsiElement nextSignificantNode(@NotNull PsiElement node2) {
            if (node2 == null) {
                Visitor.$$$reportNull$$$0(5);
            }
            PsiElement nextLeaf = PsiTreeUtil.nextVisibleLeaf((PsiElement)node2);
            while (nextLeaf != null && GoPsiUtil.isWhiteSpaceOrCommentOrEmpty(nextLeaf)) {
                nextLeaf = PsiTreeUtil.nextVisibleLeaf((PsiElement)nextLeaf);
            }
            return nextLeaf;
        }

        private void registerProblem(@NotNull PsiElement semicolon) {
            if (semicolon == null) {
                Visitor.$$$reportNull$$$0(6);
            }
            this.problemConsumer.accept((PsiElement)semicolon);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "problemConsumer";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "semicolon";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "com/goide/inspections/GoRedundantSemicolonInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitCompositeElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitGoFile";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkBlock";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkSemicolon";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "nextSignificantNode";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerProblem";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

