/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections;

import com.goide.highlighting.legacyErrorInspections.GoUnusedVariableInspection;
import com.goide.i18n.GoBundle;
import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoExpression;
import com.goide.psi.GoTypeAssertionExpr;
import com.goide.psi.GoTypeSwitchGuard;
import com.goide.psi.GoVarDefinition;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoExpressionUtil;
import com.goide.quickfix.GoNavigateToQuickFix;
import com.goide.quickfix.GoRenameQuickFix;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public final class GoShadowedVarInspection
extends GoInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(final @NotNull GoProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            GoShadowedVarInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            GoShadowedVarInspection.$$$reportNull$$$0(1);
        }
        return new GoVisitor(){

            @Override
            public void visitVarDefinition(@NotNull GoVarDefinition o) {
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!GoUnusedVariableInspection.shouldCheck(o, false)) {
                    return;
                }
                PsiElement resolve = GoExpressionUtil.getShadowedElement(o);
                if (resolve == null) {
                    return;
                }
                if (GoShadowedVarInspection.this.isInformationLevel(o) || !GoShadowedVarInspection.shadowsAssertedVariable(o)) {
                    GoShadowedVarInspection.report(holder, o, resolve, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                    return;
                }
                if (holder.isOnTheFly()) {
                    GoShadowedVarInspection.report(holder, o, resolve, ProblemHighlightType.INFORMATION);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/goide/inspections/GoShadowedVarInspection$1", "visitVarDefinition"));
            }
        };
    }

    private static void report(@NotNull GoProblemsHolder holder, @NotNull GoVarDefinition o, @NotNull PsiElement resolve, @NotNull ProblemHighlightType highlightType) {
        PsiFile file2;
        if (holder == null) {
            GoShadowedVarInspection.$$$reportNull$$$0(2);
        }
        if (o == null) {
            GoShadowedVarInspection.$$$reportNull$$$0(3);
        }
        if (resolve == null) {
            GoShadowedVarInspection.$$$reportNull$$$0(4);
        }
        if (highlightType == null) {
            GoShadowedVarInspection.$$$reportNull$$$0(5);
        }
        GoInspectionMessage message = (file2 = resolve.getContainingFile()) == null ? GoShadowedVarInspection.message("go.inspection.problem.declaration.shadows.declaration", REF) : GoShadowedVarInspection.message("go.inspection.problem.declaration.shadows.declaration.at", REF, file2.getName());
        holder.registerProblem((PsiElement)o, message, highlightType, new LocalQuickFix[]{new GoRenameQuickFix(o), new GoNavigateToQuickFix(resolve, GoBundle.message((String)"go.terms.shadowed.declaration", (Object[])new Object[0]))});
    }

    private static boolean shadowsAssertedVariable(@NotNull GoVarDefinition o) {
        GoTypeSwitchGuard typeSwitchGuard;
        if (o == null) {
            GoShadowedVarInspection.$$$reportNull$$$0(6);
        }
        if ((typeSwitchGuard = (GoTypeSwitchGuard)ObjectUtils.tryCast((Object)o.getParent(), GoTypeSwitchGuard.class)) == null) {
            return false;
        }
        String varName = o.getName();
        if (varName == null) {
            return false;
        }
        GoTypeAssertionExpr assertion = (GoTypeAssertionExpr)ObjectUtils.tryCast((Object)typeSwitchGuard.getExpression(), GoTypeAssertionExpr.class);
        GoExpression assertedExpression = assertion != null ? assertion.getExpression() : null;
        GoExpression unwrapped = assertedExpression != null ? assertedExpression.unwrapParentheses() : null;
        return unwrapped != null && unwrapped.textMatches(varName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolve";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightType";
                break;
            }
        }
        objectArray2[1] = "com/goide/inspections/GoShadowedVarInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "report";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "shadowsAssertedVariable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

