/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections;

import com.goide.GoFileType;
import com.goide.GoPluginDisposable;
import com.goide.configuration.GoLibrariesConfigurableProvider;
import com.goide.configuration.GoSdkConfigurable;
import com.goide.execution.GoWslUtil;
import com.goide.i18n.GoBundle;
import com.goide.project.GoLibrariesService;
import com.goide.project.GoModuleSettings;
import com.goide.project.GoWslProjectConfigurator;
import com.goide.sdk.GoSdk;
import com.goide.sdk.GoSdkService;
import com.goide.sdk.GoSdkUtil;
import com.goide.util.GoUtil;
import com.goide.vgo.configuration.VgoProjectSettings;
import com.goide.vgo.mod.VgoFileType;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.MessageBusConnection;
import java.util.function.Function;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class GoWrongSdkConfigurationNotificationProvider
implements EditorNotificationProvider,
DumbAware {
    private static final String DO_NOT_SHOW_NOTIFICATION_ABOUT_EMPTY_GOPATH = "DO_NOT_SHOW_NOTIFICATION_ABOUT_EMPTY_GOPATH";

    GoWrongSdkConfigurationNotificationProvider(final @NotNull Project project) {
        if (project == null) {
            GoWrongSdkConfigurationNotificationProvider.$$$reportNull$$$0(0);
        }
        MessageBusConnection connection = project.getMessageBus().connect(GoPluginDisposable.getInstance(project));
        connection.subscribe(ModuleRootListener.TOPIC, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                NonUrgentExecutor.getInstance().execute(() -> {
                    if (!project.isDisposed()) {
                        EditorNotifications.getInstance((Project)project).updateAllNotifications();
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/goide/inspections/GoWrongSdkConfigurationNotificationProvider$1", "rootsChanged"));
            }
        });
        connection.subscribe(GoLibrariesService.LIBRARIES_TOPIC, newRootUrls -> EditorNotifications.getInstance((Project)project).updateAllNotifications());
    }

    @Nullable
    public @Nullable Function<? super @NotNull FileEditor, ? extends @Nullable JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file2) {
        FileType fileType;
        if (project == null) {
            GoWrongSdkConfigurationNotificationProvider.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            GoWrongSdkConfigurationNotificationProvider.$$$reportNull$$$0(2);
        }
        if ((fileType = file2.getFileType()) != GoFileType.INSTANCE && fileType != VgoFileType.INSTANCE) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file2);
        if (psiFile == null) {
            return null;
        }
        Module module = GoUtil.module((PsiElement)psiFile);
        if (module == null) {
            return null;
        }
        GoSdk sdk = GoSdkService.getInstance(project).getSdk(module);
        if (sdk == GoSdk.NULL) {
            return fileEditor -> GoWrongSdkConfigurationNotificationProvider.createMissingSdkPanel(project, fileEditor, GoBundle.message((String)"go.notification.go.root.is.not.defined.text", (Object[])new Object[0]));
        }
        if (!sdk.isValid()) {
            return fileEditor -> GoWrongSdkConfigurationNotificationProvider.createMissingSdkPanel(project, fileEditor, GoBundle.message((String)"go.notification.go.root.is.incorrect.text", (Object[])new Object[0]));
        }
        String error = GoWslUtil.getWslValidationError(sdk, project);
        if (error != null) {
            return fileEditor -> GoWrongSdkConfigurationNotificationProvider.createConfigureWslSdkPanel(project, module, fileEditor, error);
        }
        if (!GoSdkService.getInstance(project).isGoModule(module)) {
            return fileEditor -> GoWrongSdkConfigurationNotificationProvider.createGoSupportIsDisabledPanel(module, fileEditor);
        }
        if (!PropertiesComponent.getInstance().getBoolean(DO_NOT_SHOW_NOTIFICATION_ABOUT_EMPTY_GOPATH, false) && !VgoProjectSettings.getInstance(project).isIntegrationEnabled() && StringUtil.isEmpty((String)GoSdkUtil.retrieveGoPath(project, module).trim())) {
            return fileEditor -> GoWrongSdkConfigurationNotificationProvider.createEmptyGoPathPanel(project, fileEditor);
        }
        return null;
    }

    @RequiresEdt
    @NotNull
    private static EditorNotificationPanel createConfigureWslSdkPanel(@NotNull Project project, @NotNull Module module, @NotNull FileEditor fileEditor, @NotNull @Nls String error) {
        if (project == null) {
            GoWrongSdkConfigurationNotificationProvider.$$$reportNull$$$0(3);
        }
        if (module == null) {
            GoWrongSdkConfigurationNotificationProvider.$$$reportNull$$$0(4);
        }
        if (fileEditor == null) {
            GoWrongSdkConfigurationNotificationProvider.$$$reportNull$$$0(5);
        }
        if (error == null) {
            GoWrongSdkConfigurationNotificationProvider.$$$reportNull$$$0(6);
        }
        ThreadingAssertions.assertEventDispatchThread();
        EditorNotificationPanel panel2 = new EditorNotificationPanel(fileEditor, EditorNotificationPanel.Status.Error);
        panel2.setText(error);
        panel2.createActionLabel(GoBundle.message((String)"go.notification.go.setup.action.text", (Object[])new Object[0]), () -> {
            WSLDistribution wsl;
            if (ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)new GoSdkConfigurable(project, true)) && (wsl = GoWslUtil.getWsl(project)) != null) {
                GoWslProjectConfigurator.configureProjectInWsl(project, module, wsl);
            }
        });
        EditorNotificationPanel editorNotificationPanel = panel2;
        if (editorNotificationPanel == null) {
            GoWrongSdkConfigurationNotificationProvider.$$$reportNull$$$0(7);
        }
        return editorNotificationPanel;
    }

    @RequiresEdt
    @NotNull
    private static EditorNotificationPanel createMissingSdkPanel(@NotNull Project project, @NotNull FileEditor fileEditor, @Nls @NotNull String title) {
        if (project == null) {
            GoWrongSdkConfigurationNotificationProvider.$$$reportNull$$$0(8);
        }
        if (fileEditor == null) {
            GoWrongSdkConfigurationNotificationProvider.$$$reportNull$$$0(9);
        }
        if (title == null) {
            GoWrongSdkConfigurationNotificationProvider.$$$reportNull$$$0(10);
        }
        ThreadingAssertions.assertEventDispatchThread();
        EditorNotificationPanel panel2 = new EditorNotificationPanel(fileEditor, EditorNotificationPanel.Status.Warning);
        panel2.setText(title);
        panel2.createActionLabel(GoBundle.message((String)"go.notification.go.setup.action.text", (Object[])new Object[0]), GoSdkUtil.getConfigureSDKRunnable(project));
        EditorNotificationPanel editorNotificationPanel = panel2;
        if (editorNotificationPanel == null) {
            GoWrongSdkConfigurationNotificationProvider.$$$reportNull$$$0(11);
        }
        return editorNotificationPanel;
    }

    @RequiresEdt
    @NotNull
    private static EditorNotificationPanel createGoSupportIsDisabledPanel(@NotNull Module module, @NotNull FileEditor fileEditor) {
        if (module == null) {
            GoWrongSdkConfigurationNotificationProvider.$$$reportNull$$$0(12);
        }
        if (fileEditor == null) {
            GoWrongSdkConfigurationNotificationProvider.$$$reportNull$$$0(13);
        }
        ThreadingAssertions.assertEventDispatchThread();
        EditorNotificationPanel panel2 = new EditorNotificationPanel(fileEditor, EditorNotificationPanel.Status.Warning);
        panel2.setText(GoBundle.message((String)"go.notification.go.support.is.disabled.in.module.text", (Object[])new Object[]{module.getName()}));
        panel2.createActionLabel(GoBundle.message((String)"go.notification.go.support.enable.action.text", (Object[])new Object[0]), () -> GoModuleSettings.getInstance(module).setGoSupportEnabled(true));
        EditorNotificationPanel editorNotificationPanel = panel2;
        if (editorNotificationPanel == null) {
            GoWrongSdkConfigurationNotificationProvider.$$$reportNull$$$0(14);
        }
        return editorNotificationPanel;
    }

    @RequiresEdt
    @NotNull
    private static EditorNotificationPanel createEmptyGoPathPanel(@NotNull Project project, @NotNull FileEditor fileEditor) {
        if (project == null) {
            GoWrongSdkConfigurationNotificationProvider.$$$reportNull$$$0(15);
        }
        if (fileEditor == null) {
            GoWrongSdkConfigurationNotificationProvider.$$$reportNull$$$0(16);
        }
        ThreadingAssertions.assertEventDispatchThread();
        EditorNotificationPanel panel2 = new EditorNotificationPanel(fileEditor, EditorNotificationPanel.Status.Warning);
        panel2.setText(GoBundle.message((String)"go.notification.gopath.is.empty.text", (Object[])new Object[0]));
        panel2.createActionLabel(GoBundle.message((String)"go.notification.gopath.configure.action.text", (Object[])new Object[0]), () -> GoLibrariesConfigurableProvider.showModulesConfigurable(project));
        panel2.createActionLabel(GoBundle.message((String)"go.notification.do.not.show.action.text", (Object[])new Object[0]), () -> {
            PropertiesComponent.getInstance().setValue(DO_NOT_SHOW_NOTIFICATION_ABOUT_EMPTY_GOPATH, true);
            EditorNotifications.getInstance((Project)project).updateAllNotifications();
        });
        EditorNotificationPanel editorNotificationPanel = panel2;
        if (editorNotificationPanel == null) {
            GoWrongSdkConfigurationNotificationProvider.$$$reportNull$$$0(17);
        }
        return editorNotificationPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 11, 14, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: 
            case 9: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 7: 
            case 11: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/inspections/GoWrongSdkConfigurationNotificationProvider";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/inspections/GoWrongSdkConfigurationNotificationProvider";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigureWslSdkPanel";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createMissingSdkPanel";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createGoSupportIsDisabledPanel";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyGoPathPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectNotificationData";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createConfigureWslSdkPanel";
                break;
            }
            case 7: 
            case 11: 
            case 14: 
            case 17: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createMissingSdkPanel";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createGoSupportIsDisabledPanel";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyGoPathPanel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 11, 14, 17 -> new IllegalStateException(string);
        };
    }
}

