/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections.core;

import com.goide.inspections.core.GoCallableDescriptor;
import com.goide.psi.GoFunctionDeclaration;
import com.goide.psi.impl.imports.GoImportPathUtil;
import com.goide.util.GoUtil;
import com.intellij.psi.PsiElement;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoFunctionDescriptor
implements GoCallableDescriptor {
    @NotNull
    private final String myImportPath;
    @NotNull
    private final String myName;

    public GoFunctionDescriptor(@NotNull String importPath, @NotNull String name) {
        if (importPath == null) {
            GoFunctionDescriptor.$$$reportNull$$$0(0);
        }
        if (name == null) {
            GoFunctionDescriptor.$$$reportNull$$$0(1);
        }
        this.myImportPath = importPath;
        this.myName = name;
    }

    @Override
    @NotNull
    public String getImportPath() {
        String string = this.myImportPath;
        if (string == null) {
            GoFunctionDescriptor.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            GoFunctionDescriptor.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GoFunctionDescriptor that = (GoFunctionDescriptor)o;
        return this.myImportPath.equals(that.myImportPath) && this.myName.equals(that.myName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.myImportPath, this.myName);
    }

    public String toString() {
        return this.myImportPath + "." + this.myName;
    }

    @NotNull
    public static GoFunctionDescriptor of(@NotNull String descriptorText) {
        int lastDot;
        if (descriptorText == null) {
            GoFunctionDescriptor.$$$reportNull$$$0(4);
        }
        if ((lastDot = descriptorText.lastIndexOf(".")) == -1 || lastDot == 0 || lastDot == descriptorText.length() - 1) {
            throw new IllegalArgumentException("Wrong function name: " + descriptorText);
        }
        return new GoFunctionDescriptor(descriptorText.substring(0, lastDot), descriptorText.substring(lastDot + 1));
    }

    @Nullable
    public static GoFunctionDescriptor of(@NotNull GoFunctionDeclaration declaration, @NotNull PsiElement context, boolean ignoreVersion) {
        String functionName;
        if (declaration == null) {
            GoFunctionDescriptor.$$$reportNull$$$0(5);
        }
        if (context == null) {
            GoFunctionDescriptor.$$$reportNull$$$0(6);
        }
        if ((functionName = declaration.getName()) == null) {
            return null;
        }
        String importPath = GoUtil.getImportPath(declaration, context);
        if (importPath == null) {
            return null;
        }
        importPath = ignoreVersion ? GoImportPathUtil.removeVersion(importPath) : importPath;
        return new GoFunctionDescriptor(importPath, functionName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/inspections/core/GoFunctionDescriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptorText";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/inspections/core/GoFunctionDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "of";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

