/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections.fmtstring;

import com.goide.inspections.GoDecodedStringLiteralRangeConverter;
import com.goide.inspections.GoInspectionUtil;
import com.goide.inspections.core.GoCallableDescriptor;
import com.goide.inspections.core.GoFunctionDescriptor;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoMethodDescriptor;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.inspections.fmtstring.GoExcludedPrintfFuncsPersistentSet;
import com.goide.inspections.fmtstring.GoPrintfFuncUtilKt;
import com.goide.inspections.fmtstring.parser.GoFmtStringParser;
import com.goide.inspections.fmtstring.parser.tokens.GoFmtStringPlaceholder;
import com.goide.inspections.fmtstring.parser.tokens.GoFmtStringToken;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoStringLiteral;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.sdk.GoSdkUtil;
import com.goide.stubs.index.GoFunctionIndex;
import com.goide.stubs.index.GoMethodIndex;
import com.goide.util.GoUtil;
import com.goide.util.Value;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoFmtStringUtil {
    @NotNull
    private static final GoFunctionDescriptor FMT_ERRORF = GoFunctionDescriptor.of("fmt.Errorf");
    private static final Map<GoCallableDescriptor, Integer> STD = Map.ofEntries(Map.entry(FMT_ERRORF, 0), Map.entry(GoFunctionDescriptor.of("fmt.Fprintf"), 1), Map.entry(GoFunctionDescriptor.of("fmt.Printf"), 0), Map.entry(GoFunctionDescriptor.of("fmt.Sprintf"), 0), Map.entry(GoFunctionDescriptor.of("fmt.Appendf"), 1), Map.entry(GoFunctionDescriptor.of("log.Fatalf"), 0), Map.entry(GoFunctionDescriptor.of("log.Panicf"), 0), Map.entry(GoFunctionDescriptor.of("log.Printf"), 0), Map.entry(GoMethodDescriptor.of("(*testing.common).Errorf"), 0), Map.entry(GoMethodDescriptor.of("(*testing.common).Fatalf"), 0), Map.entry(GoMethodDescriptor.of("(*testing.common).Logf"), 0), Map.entry(GoMethodDescriptor.of("(*testing.common).Skipf"), 0));
    private static final Map<GoFunctionDescriptor, Integer> SCANF = Map.of(GoFunctionDescriptor.of("fmt.Fscanf"), 1, GoFunctionDescriptor.of("fmt.Scanf"), 0, GoFunctionDescriptor.of("fmt.Sscanf"), 1);

    @Nullable
    public static FmtFunctionInfo findFormattingFunction(@Nullable PsiElement context) {
        GoCallExpr call = (GoCallExpr)PsiTreeUtil.getParentOfType((PsiElement)context, GoCallExpr.class, (boolean)false);
        if (call == null) {
            return null;
        }
        Project project = call.getProject();
        boolean excluded = ((GoExcludedPrintfFuncsPersistentSet)project.getService(GoExcludedPrintfFuncsPersistentSet.class)).contains(call, false);
        if (excluded) {
            return null;
        }
        Integer index = GoFmtStringUtil.getFmtArgIndex(call);
        if (index == null) {
            return null;
        }
        GoCallableDescriptor descriptor = GoCallableDescriptor.of(call, true);
        if (descriptor == null) {
            return null;
        }
        if ((STD.containsKey(descriptor) || SCANF.containsKey(descriptor)) && !GoSdkUtil.isInSdk((PsiFileSystemItem)Objects.requireNonNull(GoInspectionUtil.resolveCall(call)).getContainingFile())) {
            return null;
        }
        return new FmtFunctionInfo(call, descriptor, index);
    }

    @Nullable
    public static FmtFunctionInfo findFormattingFunction(@NotNull GoCallExpr call, @NotNull GoCallableDescriptor descriptor) {
        Project project;
        boolean excluded;
        if (call == null) {
            GoFmtStringUtil.$$$reportNull$$$0(0);
        }
        if (descriptor == null) {
            GoFmtStringUtil.$$$reportNull$$$0(1);
        }
        if (excluded = ((GoExcludedPrintfFuncsPersistentSet)(project = call.getProject()).getService(GoExcludedPrintfFuncsPersistentSet.class)).contains(descriptor)) {
            return null;
        }
        Collection<GoFunctionOrMethodDeclaration> foundDeclarations = GoFmtStringUtil.findDeclarations(descriptor, project, call);
        for (GoFunctionOrMethodDeclaration declaration : foundDeclarations) {
            Integer index = GoPrintfFuncUtilKt.computeIndex(declaration);
            if (index == null) continue;
            return new FmtFunctionInfo(call, descriptor, index);
        }
        return null;
    }

    @NotNull
    private static Collection<GoFunctionOrMethodDeclaration> findDeclarations(@NotNull GoCallableDescriptor descriptor, @NotNull Project project, @NotNull GoCallExpr call) {
        if (descriptor == null) {
            GoFmtStringUtil.$$$reportNull$$$0(2);
        }
        if (project == null) {
            GoFmtStringUtil.$$$reportNull$$$0(3);
        }
        if (call == null) {
            GoFmtStringUtil.$$$reportNull$$$0(4);
        }
        String importPath = descriptor.getImportPath();
        Module module = GoUtil.module(call);
        if (module == null) {
            List<GoFunctionOrMethodDeclaration> list = Collections.emptyList();
            if (list == null) {
                GoFmtStringUtil.$$$reportNull$$$0(5);
            }
            return list;
        }
        GlobalSearchScope scope = GoUtil.moduleScope(module);
        List declarations = Collections.emptyList();
        if (descriptor instanceof GoFunctionDescriptor) {
            declarations = ContainerUtil.filter(GoFunctionIndex.find(descriptor.getName(), project, scope, null), function -> Objects.equals(GoUtil.getImportPath(function, call), importPath));
        } else if (descriptor instanceof GoMethodDescriptor) {
            String receiverType = StringUtil.trimStart((String)((GoMethodDescriptor)descriptor).getReceiver(), (String)"*");
            String methodName = descriptor.getName();
            declarations = ContainerUtil.filter(GoMethodIndex.find(importPath + "." + receiverType, project, scope, null), method -> Objects.equals(method.getName(), methodName));
        }
        List list = declarations;
        if (list == null) {
            GoFmtStringUtil.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Nullable
    private static Integer getFmtArgIndex(@NotNull GoCallExpr call) {
        GoReferenceExpression callReference;
        if (call == null) {
            GoFmtStringUtil.$$$reportNull$$$0(7);
        }
        if ((callReference = GoPsiUtil.getCallReference(call)) == null) {
            return null;
        }
        return GoPrintfFuncUtilKt.computeIndex(callReference);
    }

    @NotNull
    public static List<GoFmtStringToken> parse(@NotNull GoStringLiteral fmtStringLiteral) {
        String fmtString;
        if (fmtStringLiteral == null) {
            GoFmtStringUtil.$$$reportNull$$$0(8);
        }
        List<GoFmtStringToken> list = (fmtString = GoFmtStringUtil.getStringValue(fmtStringLiteral)) != null ? GoFmtStringParser.parse(fmtString) : Collections.emptyList();
        if (list == null) {
            GoFmtStringUtil.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Nullable
    public static String getStringValue(@NotNull GoExpression expr) {
        if (expr == null) {
            GoFmtStringUtil.$$$reportNull$$$0(10);
        }
        if (!GoTypeUtil.isString(expr.getGoType(null), expr)) {
            return null;
        }
        Value value2 = expr.getValue();
        return value2 != null ? value2.getString() : null;
    }

    @NotNull
    public static List<GoFmtStringPlaceholder> filterPlaceholders(@NotNull List<GoFmtStringToken> tokens) {
        if (tokens == null) {
            GoFmtStringUtil.$$$reportNull$$$0(11);
        }
        List<GoFmtStringPlaceholder> list = tokens.stream().map(t -> (GoFmtStringPlaceholder)ObjectUtils.tryCast((Object)t, GoFmtStringPlaceholder.class)).filter(Objects::nonNull).collect(Collectors.toList());
        if (list == null) {
            GoFmtStringUtil.$$$reportNull$$$0(12);
        }
        return list;
    }

    public static boolean hasExplicitIndices(@NotNull List<GoFmtStringPlaceholder> placeholders) {
        if (placeholders == null) {
            GoFmtStringUtil.$$$reportNull$$$0(13);
        }
        for (GoFmtStringPlaceholder p : placeholders) {
            Integer index;
            GoFmtStringPlaceholder.OperandBased operandBased = (GoFmtStringPlaceholder.OperandBased)ObjectUtils.tryCast((Object)p.getWidth(), GoFmtStringPlaceholder.OperandBased.class);
            Integer n = index = operandBased != null ? operandBased.getIndex() : null;
            if (index != null) {
                return true;
            }
            operandBased = (GoFmtStringPlaceholder.OperandBased)ObjectUtils.tryCast((Object)p.getPrecision(), GoFmtStringPlaceholder.OperandBased.class);
            Integer n2 = index = operandBased != null ? operandBased.getIndex() : null;
            if (index != null) {
                return true;
            }
            if (p.getVerbIndex() == null) continue;
            return true;
        }
        return false;
    }

    public static boolean hasZeroIndices(@NotNull GoFmtStringPlaceholder p) {
        Integer precisionIndex;
        Integer widthIndex;
        GoFmtStringPlaceholder.Parameter parameter;
        if (p == null) {
            GoFmtStringUtil.$$$reportNull$$$0(14);
        }
        if ((parameter = p.getWidth()) instanceof GoFmtStringPlaceholder.OperandBased) {
            GoFmtStringPlaceholder.OperandBased operandBased = (GoFmtStringPlaceholder.OperandBased)parameter;
            v0 = operandBased.getIndex();
        } else {
            v0 = widthIndex = null;
        }
        if (widthIndex != null && widthIndex == 0) {
            return true;
        }
        GoFmtStringPlaceholder.Parameter parameter2 = p.getPrecision();
        if (parameter2 instanceof GoFmtStringPlaceholder.OperandBased) {
            GoFmtStringPlaceholder.OperandBased operandBased = (GoFmtStringPlaceholder.OperandBased)parameter2;
            v1 = operandBased.getIndex();
        } else {
            v1 = precisionIndex = null;
        }
        if (precisionIndex != null && precisionIndex == 0) {
            return true;
        }
        Integer verbIndex = p.getVerbIndex();
        return verbIndex != null && verbIndex == 0;
    }

    public static List<Indices> operandsIndices(@NotNull List<GoFmtStringPlaceholder> placeholders) {
        if (placeholders == null) {
            GoFmtStringUtil.$$$reportNull$$$0(15);
        }
        SmartList operandsIndices = new SmartList();
        int currentIndex = 0;
        for (GoFmtStringPlaceholder placeholder : placeholders) {
            Integer index;
            GoFmtStringPlaceholder.Parameter width = placeholder.getWidth();
            Integer widthIndex = null;
            if (width instanceof GoFmtStringPlaceholder.OperandBased) {
                Integer index2 = ((GoFmtStringPlaceholder.OperandBased)width).getIndex();
                widthIndex = index2 == null ? currentIndex : index2 - 1;
                currentIndex = widthIndex + 1;
            }
            Integer precisionIndex = null;
            GoFmtStringPlaceholder.Parameter precision = placeholder.getPrecision();
            if (precision instanceof GoFmtStringPlaceholder.OperandBased) {
                Integer index3 = ((GoFmtStringPlaceholder.OperandBased)precision).getIndex();
                precisionIndex = index3 == null ? currentIndex : index3 - 1;
                currentIndex = precisionIndex + 1;
            }
            int verbIndex = (index = placeholder.getVerbIndex()) == null ? currentIndex : index - 1;
            currentIndex = verbIndex + 1;
            operandsIndices.add(new Indices(widthIndex, precisionIndex, verbIndex));
        }
        return operandsIndices;
    }

    public static int maxIndex(@NotNull List<Indices> indices) {
        if (indices == null) {
            GoFmtStringUtil.$$$reportNull$$$0(16);
        }
        int max = 0;
        for (Indices index : indices) {
            max = Math.max(max, (Integer)ObjectUtils.notNull((Object)index.getWidthIndex(), (Object)-1));
            max = Math.max(max, (Integer)ObjectUtils.notNull((Object)index.getPrecisionIndex(), (Object)-1));
            max = Math.max(max, index.getVerbIndex());
        }
        return max;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 9, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/inspections/fmtstring/GoFmtStringUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fmtStringLiteral";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokens";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeholders";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indices";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/inspections/fmtstring/GoFmtStringUtil";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findDeclarations";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "filterPlaceholders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findFormattingFunction";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findDeclarations";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 12: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFmtArgIndex";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getStringValue";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "filterPlaceholders";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "hasExplicitIndices";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "hasZeroIndices";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "operandsIndices";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "maxIndex";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 9, 12 -> new IllegalStateException(string);
        };
    }

    public static class FmtFunctionInfo {
        @NotNull
        private final GoCallExpr myCallExpression;
        @NotNull
        private final GoCallableDescriptor myDescriptor;
        @Nullable
        private final Integer myFmtArgIndex;

        public FmtFunctionInfo(@NotNull GoCallExpr call, @NotNull GoCallableDescriptor descriptor) {
            if (call == null) {
                FmtFunctionInfo.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                FmtFunctionInfo.$$$reportNull$$$0(1);
            }
            this(call, descriptor, null);
        }

        public FmtFunctionInfo(@NotNull GoCallExpr call, @NotNull GoCallableDescriptor descriptor, @Nullable Integer fmtArgIndex) {
            if (call == null) {
                FmtFunctionInfo.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                FmtFunctionInfo.$$$reportNull$$$0(3);
            }
            this.myCallExpression = call;
            this.myDescriptor = descriptor;
            this.myFmtArgIndex = fmtArgIndex;
        }

        @NotNull
        public GoCallExpr getCallExpression() {
            GoCallExpr goCallExpr = this.myCallExpression;
            if (goCallExpr == null) {
                FmtFunctionInfo.$$$reportNull$$$0(4);
            }
            return goCallExpr;
        }

        public boolean isScanFunction() {
            return SCANF.containsKey(this.myDescriptor);
        }

        public boolean isFmtErrorfFunction() {
            return FMT_ERRORF.equals(this.myDescriptor);
        }

        @Nullable
        public FmtCallArguments getFmtStringAndRestArguments() {
            if (this.myFmtArgIndex == null) {
                return null;
            }
            List<GoExpression> args = this.myCallExpression.getArgumentList().getExpressionList();
            if (this.myFmtArgIndex >= args.size()) {
                return null;
            }
            return new FmtCallArguments(args.get(this.myFmtArgIndex), ContainerUtil.subList(args, (int)(this.myFmtArgIndex + 1)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/inspections/fmtstring/GoFmtStringUtil$FmtFunctionInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/inspections/fmtstring/GoFmtStringUtil$FmtFunctionInfo";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCallExpression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    public static final class Indices {
        @Nullable
        private final Integer myWidthIndex;
        @Nullable
        private final Integer myPrecisionIndex;
        private final int myVerbIndex;

        private Indices(@Nullable Integer widthIndex, @Nullable Integer precisionIndex, int index) {
            this.myWidthIndex = widthIndex;
            this.myPrecisionIndex = precisionIndex;
            this.myVerbIndex = index;
        }

        @Nullable
        public Integer getWidthIndex() {
            return this.myWidthIndex;
        }

        @Nullable
        public Integer getPrecisionIndex() {
            return this.myPrecisionIndex;
        }

        public int getVerbIndex() {
            return this.myVerbIndex;
        }
    }

    public static class FmtStringProblemsHolder {
        private final GoProblemsHolder myHolder;
        private final GoExpression myFmtStringExpr;
        @Nullable
        private GoDecodedStringLiteralRangeConverter myTokenRangeConverter;

        public FmtStringProblemsHolder(@NotNull GoProblemsHolder holder, @NotNull GoExpression expr) {
            if (holder == null) {
                FmtStringProblemsHolder.$$$reportNull$$$0(0);
            }
            if (expr == null) {
                FmtStringProblemsHolder.$$$reportNull$$$0(1);
            }
            this.myHolder = holder;
            this.myFmtStringExpr = expr;
            GoStringLiteral literal = (GoStringLiteral)ObjectUtils.tryCast((Object)expr, GoStringLiteral.class);
            if (literal != null) {
                this.myTokenRangeConverter = new GoDecodedStringLiteralRangeConverter(literal);
            }
        }

        @NotNull
        public GoExpression getFmtStringExpr() {
            GoExpression goExpression = this.myFmtStringExpr;
            if (goExpression == null) {
                FmtStringProblemsHolder.$$$reportNull$$$0(2);
            }
            return goExpression;
        }

        public void registerWarning(@NotNull GoInspectionMessage message) {
            if (message == null) {
                FmtStringProblemsHolder.$$$reportNull$$$0(3);
            }
            this.myHolder.registerProblem((PsiElement)this.myFmtStringExpr, message, new LocalQuickFix[0]);
        }

        public void registerWarning(@NotNull GoInspectionMessage message, @NotNull GoFmtStringToken token) {
            if (message == null) {
                FmtStringProblemsHolder.$$$reportNull$$$0(4);
            }
            if (token == null) {
                FmtStringProblemsHolder.$$$reportNull$$$0(5);
            }
            this.reportToken(message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, token);
        }

        public void reportToken(@NotNull GoInspectionMessage message, @NotNull ProblemHighlightType highlightType, @NotNull GoFmtStringToken token) {
            TextRange range;
            if (message == null) {
                FmtStringProblemsHolder.$$$reportNull$$$0(6);
            }
            if (highlightType == null) {
                FmtStringProblemsHolder.$$$reportNull$$$0(7);
            }
            if (token == null) {
                FmtStringProblemsHolder.$$$reportNull$$$0(8);
            }
            TextRange textRange = range = this.myTokenRangeConverter != null ? this.myTokenRangeConverter.computeRange(token.getStart(), token.getEnd()) : null;
            if (range != null && FmtStringProblemsHolder.isValidRange(range, this.myFmtStringExpr.getTextRange())) {
                this.myHolder.registerProblem((PsiElement)this.myFmtStringExpr, message, highlightType, range, new LocalQuickFix[0]);
            } else {
                this.myHolder.registerProblem((PsiElement)this.myFmtStringExpr, message, highlightType, new LocalQuickFix[0]);
            }
        }

        private static boolean isValidRange(@NotNull TextRange tokenRange, @NotNull TextRange fmtStringRange) {
            if (tokenRange == null) {
                FmtStringProblemsHolder.$$$reportNull$$$0(9);
            }
            if (fmtStringRange == null) {
                FmtStringProblemsHolder.$$$reportNull$$$0(10);
            }
            return tokenRange.getEndOffset() <= fmtStringRange.getEndOffset() - fmtStringRange.getStartOffset();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expr";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/inspections/fmtstring/GoFmtStringUtil$FmtStringProblemsHolder";
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "token";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "highlightType";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tokenRange";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fmtStringRange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/inspections/fmtstring/GoFmtStringUtil$FmtStringProblemsHolder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFmtStringExpr";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "registerWarning";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "reportToken";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "isValidRange";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    public static class FmtCallArguments {
        @NotNull
        private final GoExpression myFmtString;
        @NotNull
        private final List<GoExpression> myRestArguments;

        public FmtCallArguments(@NotNull GoExpression fmtString, @NotNull List<GoExpression> arguments) {
            if (fmtString == null) {
                FmtCallArguments.$$$reportNull$$$0(0);
            }
            if (arguments == null) {
                FmtCallArguments.$$$reportNull$$$0(1);
            }
            this.myFmtString = fmtString;
            this.myRestArguments = arguments;
        }

        @NotNull
        public GoExpression getFmtString() {
            GoExpression goExpression = this.myFmtString;
            if (goExpression == null) {
                FmtCallArguments.$$$reportNull$$$0(2);
            }
            return goExpression;
        }

        @NotNull
        public List<GoExpression> getRestArguments() {
            List<GoExpression> list = this.myRestArguments;
            if (list == null) {
                FmtCallArguments.$$$reportNull$$$0(3);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fmtString";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arguments";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/inspections/fmtstring/GoFmtStringUtil$FmtCallArguments";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/inspections/fmtstring/GoFmtStringUtil$FmtCallArguments";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFmtString";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRestArguments";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

