/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections.fmtstring.parser.tokens;

import com.goide.inspections.fmtstring.parser.tokens.GoFmtStringToken;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoFmtStringPlaceholder
extends GoFmtStringToken {
    private final List<Character> myFlags = new SmartList();
    private Parameter myWidth;
    private Parameter myPrecision;
    private Integer myVerbIndex;
    private char myVerb;

    public GoFmtStringPlaceholder() {
        super("PLACEHOLDER");
    }

    @NotNull
    public List<Character> getFlags() {
        List<Character> list = this.myFlags;
        if (list == null) {
            GoFmtStringPlaceholder.$$$reportNull$$$0(0);
        }
        return list;
    }

    public void setFlags(@NotNull CharSequence flags) {
        if (flags == null) {
            GoFmtStringPlaceholder.$$$reportNull$$$0(1);
        }
        for (int i = 0; i < flags.length(); ++i) {
            this.myFlags.add(Character.valueOf(flags.charAt(i)));
        }
    }

    @Nullable
    public Parameter getWidth() {
        return this.myWidth;
    }

    public void setWidthNumericalValue() {
        this.myWidth = NumericalValue.INSTANCE;
    }

    public void setWidthReference(@NotNull CharSequence reference) {
        if (reference == null) {
            GoFmtStringPlaceholder.$$$reportNull$$$0(2);
        }
        String maybeIndex = StringUtil.trimEnd((String)reference.toString(), (char)'*');
        this.myWidth = new OperandBased(GoFmtStringPlaceholder.tryParseIndex(maybeIndex));
    }

    @Nullable
    public Parameter getPrecision() {
        return this.myPrecision;
    }

    public void setPrecisionNumericalValue() {
        this.myPrecision = NumericalValue.INSTANCE;
    }

    public void setPrecisionReference(@NotNull CharSequence reference) {
        if (reference == null) {
            GoFmtStringPlaceholder.$$$reportNull$$$0(3);
        }
        String maybeIndex = StringUtil.trimEnd((String)reference.toString(), (char)'*');
        this.myPrecision = new OperandBased(GoFmtStringPlaceholder.tryParseIndex(maybeIndex));
    }

    @Nullable
    public Integer getVerbIndex() {
        return this.myVerbIndex;
    }

    public void setVerbIndex(@NotNull CharSequence verbIndex) {
        if (verbIndex == null) {
            GoFmtStringPlaceholder.$$$reportNull$$$0(4);
        }
        this.myVerbIndex = GoFmtStringPlaceholder.tryParseIndex(verbIndex.toString());
    }

    public char getVerb() {
        return this.myVerb;
    }

    public void setVerb(char verb) {
        this.myVerb = verb;
    }

    @Override
    public String toString() {
        String formatString = "%s{flags: %s, width: %s, precision: %s, index: %s, verb: %c}";
        return String.format(formatString, super.toString(), this.myFlags, this.myWidth, this.myPrecision, this.myVerbIndex, Character.valueOf(this.myVerb));
    }

    @Nullable
    private static Integer tryParseIndex(@NotNull String index) {
        String number;
        if (index == null) {
            GoFmtStringPlaceholder.$$$reportNull$$$0(5);
        }
        if ((number = StringUtil.trimEnd((String)StringUtil.trimStart((String)index, (String)"["), (String)"]")).isEmpty()) {
            return null;
        }
        return GoFmtStringPlaceholder.tryParseNumber(number);
    }

    @Nullable
    private static Integer tryParseNumber(String number) {
        try {
            return Integer.parseInt(number);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/inspections/fmtstring/parser/tokens/GoFmtStringPlaceholder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flags";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "verbIndex";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlags";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/inspections/fmtstring/parser/tokens/GoFmtStringPlaceholder";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setFlags";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setWidthReference";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setPrecisionReference";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setVerbIndex";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "tryParseIndex";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }

    public static interface Parameter {
    }

    public static class NumericalValue
    implements Parameter {
        public static final NumericalValue INSTANCE = new NumericalValue();

        public String toString() {
            return "number";
        }
    }

    public static class OperandBased
    implements Parameter {
        private final Integer myIndex;

        public OperandBased(@Nullable Integer index) {
            this.myIndex = index;
        }

        @Nullable
        public Integer getIndex() {
            return this.myIndex;
        }

        public String toString() {
            return "index(" + String.valueOf(this.myIndex == null ? "next" : this.myIndex) + ")";
        }
    }
}

