/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections.suppression;

import com.goide.GoLanguage;
import com.goide.i18n.GoBundle;
import com.goide.psi.GoCaseClause;
import com.goide.psi.GoCommCase;
import com.goide.psi.GoCommClause;
import com.goide.psi.GoCompositeElement;
import com.goide.psi.GoExprCaseClause;
import com.goide.psi.GoImportDeclaration;
import com.goide.psi.GoImportList;
import com.goide.psi.GoPackageClause;
import com.goide.psi.GoStatement;
import com.goide.psi.GoTopLevelDeclaration;
import com.goide.psi.GoTypeCaseClause;
import com.intellij.codeInsight.daemon.impl.actions.AbstractBatchSuppressByNoInspectionCommentFix;
import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoInspectionSuppressor
implements InspectionSuppressor {
    public static final String GOLAND_NOINSPECTION_PREFIX = "goland:noinspection ";
    @NonNls
    public static final Pattern GO_SUPPRESS_IN_LINE_COMMENT_PATTERN = Pattern.compile("//goland:noinspection ([a-zA-Z_0-9.-]+(\\s*,\\s*[a-zA-Z_0-9.-]+)*).*");

    public boolean isSuppressedFor(@NotNull PsiElement element, @NotNull String toolId) {
        GoTopLevelDeclaration topLevelDeclaration;
        if (element == null) {
            GoInspectionSuppressor.$$$reportNull$$$0(0);
        }
        if (toolId == null) {
            GoInspectionSuppressor.$$$reportNull$$$0(1);
        }
        if (GoInspectionSuppressor.isSuppressedInStatement(toolId, topLevelDeclaration = (GoTopLevelDeclaration)PsiTreeUtil.getTopmostParentOfType((PsiElement)element, GoTopLevelDeclaration.class))) {
            return true;
        }
        GoImportDeclaration importDeclaration = (GoImportDeclaration)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{GoImportDeclaration.class});
        if (importDeclaration != null && importDeclaration.getPrevSibling() == null && GoInspectionSuppressor.isSuppressedInStatement(element, toolId, GoImportList.class)) {
            return true;
        }
        return GoInspectionSuppressor.isSuppressedInStatement(element, toolId, GoPackageClause.class, GoStatement.class, GoCaseClause.class, GoTopLevelDeclaration.class, GoImportDeclaration.class);
    }

    public SuppressQuickFix @NotNull [] getSuppressActions(PsiElement element, @NotNull String toolId) {
        if (toolId == null) {
            GoInspectionSuppressor.$$$reportNull$$$0(2);
        }
        SuppressQuickFix[] suppressQuickFixArray = new SuppressQuickFix[]{new GoSuppressInspectionFix(GoBundle.message((String)"go.terms.case", (Object[])new Object[0]), GoCaseClause.class, false, true), new GoSuppressInspectionFix(toolId, GoBundle.message((String)"go.terms.case", (Object[])new Object[0]), GoCaseClause.class, false, true), new GoSuppressInspectionFix(GoBundle.message((String)"go.terms.declaration", (Object[])new Object[0]), GoTopLevelDeclaration.class, true, true), new GoSuppressInspectionFix(toolId, GoBundle.message((String)"go.terms.declaration", (Object[])new Object[0]), GoTopLevelDeclaration.class, true, true), new GoSuppressForStatementFix(), new GoSuppressForStatementFix(toolId), new GoSuppressInspectionFix(GoBundle.message((String)"go.terms.import", (Object[])new Object[0]), GoImportDeclaration.class, false, false), new GoSuppressInspectionFix(toolId, GoBundle.message((String)"go.terms.import", (Object[])new Object[0]), GoImportDeclaration.class, false, false), new GoSuppressInspectionFix(GoBundle.message((String)"go.terms.package.statement", (Object[])new Object[0]), GoPackageClause.class, false, false), new GoSuppressInspectionFix(toolId, GoBundle.message((String)"go.terms.package.statement", (Object[])new Object[0]), GoPackageClause.class, false, false)};
        if (suppressQuickFixArray == null) {
            GoInspectionSuppressor.$$$reportNull$$$0(3);
        }
        return suppressQuickFixArray;
    }

    @SafeVarargs
    private static boolean isSuppressedInStatement(@NotNull PsiElement place, @NotNull String toolId, Class<? extends PsiElement> ... statementClasses) {
        if (place == null) {
            GoInspectionSuppressor.$$$reportNull$$$0(4);
        }
        if (toolId == null) {
            GoInspectionSuppressor.$$$reportNull$$$0(5);
        }
        if (statementClasses == null) {
            GoInspectionSuppressor.$$$reportNull$$$0(6);
        }
        PsiElement statement = PsiTreeUtil.getNonStrictParentOfType((PsiElement)place, (Class[])statementClasses);
        while (statement != null) {
            if (GoInspectionSuppressor.isSuppressedInStatement(toolId, statement)) {
                return true;
            }
            statement = PsiTreeUtil.getParentOfType((PsiElement)statement, (Class[])statementClasses);
        }
        return false;
    }

    private static boolean isSuppressedInStatement(@NotNull String toolId, @Nullable PsiElement statement) {
        if (toolId == null) {
            GoInspectionSuppressor.$$$reportNull$$$0(7);
        }
        if (statement != null) {
            PsiElement prev = PsiTreeUtil.skipSiblingsBackward((PsiElement)statement, (Class[])new Class[]{PsiWhiteSpace.class});
            if (prev instanceof PsiComment) {
                return GoInspectionSuppressor.isSuppressComment(prev, toolId);
            }
            PsiElement caseElement = GoInspectionSuppressor.getCaseElement(statement);
            if (caseElement != null && (prev = PsiTreeUtil.skipSiblingsBackward((PsiElement)caseElement, (Class[])new Class[]{PsiWhiteSpace.class})) instanceof PsiComment) {
                return GoInspectionSuppressor.isSuppressComment(prev, toolId);
            }
        }
        return false;
    }

    private static boolean isSuppressComment(@NotNull PsiElement comment, @NotNull String toolId) {
        String toolIds;
        if (comment == null) {
            GoInspectionSuppressor.$$$reportNull$$$0(8);
        }
        if (toolId == null) {
            GoInspectionSuppressor.$$$reportNull$$$0(9);
        }
        return (toolIds = GoInspectionSuppressor.getToolIds(comment.getText())) != null && SuppressionUtil.isInspectionToolIdMentioned((String)toolIds, (String)toolId);
    }

    @Nullable
    private static String getToolIds(@NotNull String commentText) {
        Matcher matcher;
        if (commentText == null) {
            GoInspectionSuppressor.$$$reportNull$$$0(10);
        }
        if ((matcher = GO_SUPPRESS_IN_LINE_COMMENT_PATTERN.matcher(commentText)).matches()) {
            return matcher.group(1);
        }
        matcher = SuppressionUtil.SUPPRESS_IN_LINE_COMMENT_PATTERN.matcher(commentText);
        return matcher.matches() ? matcher.group(1) : null;
    }

    @Nullable
    private static PsiElement getCaseElement(@Nullable PsiElement element) {
        if (element instanceof GoExprCaseClause) {
            return ((GoExprCaseClause)element).getCase();
        }
        if (element instanceof GoTypeCaseClause) {
            return ((GoTypeCaseClause)element).getCase();
        }
        if (element instanceof GoCommClause) {
            return ((GoCommClause)element).getCommCase();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/inspections/suppression/GoInspectionSuppressor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementClasses";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/inspections/suppression/GoInspectionSuppressor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedFor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressActions";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedInStatement";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressComment";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getToolIds";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    public static class GoSuppressInspectionFix
    extends AbstractBatchSuppressByNoInspectionCommentFix {
        private final Class<? extends GoCompositeElement> myContainerClass;
        private final boolean myTopMost;
        private final boolean myUpdateElementDescription;
        private final boolean myReplaceOthers;

        public GoSuppressInspectionFix(@Nls @NotNull String elementDescription, Class<? extends GoCompositeElement> containerClass, boolean topMost, boolean updateElementDescription) {
            if (elementDescription == null) {
                GoSuppressInspectionFix.$$$reportNull$$$0(0);
            }
            super("ALL", true);
            this.myReplaceOthers = true;
            this.myUpdateElementDescription = updateElementDescription;
            this.setText(GoBundle.message((String)"go.fix.suppress.all.inspections.for.text", (Object[])new Object[]{elementDescription}));
            this.myContainerClass = containerClass;
            this.myTopMost = topMost;
        }

        public GoSuppressInspectionFix(@NonNls @NotNull String ID2, @Nls @NotNull String elementDescription, Class<? extends GoCompositeElement> containerClass, boolean topMost, boolean updateElementDescription) {
            if (ID2 == null) {
                GoSuppressInspectionFix.$$$reportNull$$$0(1);
            }
            if (elementDescription == null) {
                GoSuppressInspectionFix.$$$reportNull$$$0(2);
            }
            super(ID2, false);
            this.myReplaceOthers = false;
            this.myUpdateElementDescription = updateElementDescription;
            this.setText(GoBundle.message((String)"go.fix.suppress.inspection.for.text", (Object[])new Object[]{elementDescription}));
            this.myTopMost = topMost;
            this.myContainerClass = containerClass;
        }

        protected void createSuppression(@NotNull Project project, @NotNull PsiElement element, @NotNull PsiElement container) throws IncorrectOperationException {
            if (project == null) {
                GoSuppressInspectionFix.$$$reportNull$$$0(3);
            }
            if (element == null) {
                GoSuppressInspectionFix.$$$reportNull$$$0(4);
            }
            if (container == null) {
                GoSuppressInspectionFix.$$$reportNull$$$0(5);
            }
            PsiComment comment = SuppressionUtil.createComment((Project)project, (String)this.getSuppressCommentText(), (Language)GoLanguage.INSTANCE);
            container.getParent().addBefore((PsiElement)comment, container);
        }

        protected boolean replaceSuppressionComments(@NotNull PsiElement container) {
            List<? extends PsiElement> comments;
            if (container == null) {
                GoSuppressInspectionFix.$$$reportNull$$$0(6);
            }
            if ((comments = this.getCommentsFor(container)) != null) {
                for (PsiElement psiElement : comments) {
                    String toolIds = GoInspectionSuppressor.getToolIds(psiElement.getText());
                    if (!(psiElement instanceof PsiComment) || toolIds == null && !SuppressionUtil.isSuppressionComment((PsiElement)psiElement)) continue;
                    if (this.myReplaceOthers) {
                        PsiComment replacement = SuppressionUtil.createComment((Project)psiElement.getProject(), (String)this.getSuppressCommentText(), (Language)GoLanguage.INSTANCE);
                        psiElement.replace((PsiElement)replacement);
                        return true;
                    }
                    if (toolIds != null) {
                        String text = this.getSuppressCommentText(toolIds);
                        PsiComment replacement = SuppressionUtil.createComment((Project)psiElement.getProject(), (String)text, (Language)GoLanguage.INSTANCE);
                        psiElement.replace((PsiElement)replacement);
                    } else {
                        this.replaceSuppressionComment(psiElement);
                    }
                    return true;
                }
            }
            return false;
        }

        @NotNull
        private String getSuppressCommentText() {
            return this.getSuppressCommentText("");
        }

        @NotNull
        private String getSuppressCommentText(@NotNull String existingIds) {
            if (existingIds == null) {
                GoSuppressInspectionFix.$$$reportNull$$$0(7);
            }
            String string = existingIds.isEmpty() ? GoInspectionSuppressor.GOLAND_NOINSPECTION_PREFIX + this.myID : GoInspectionSuppressor.GOLAND_NOINSPECTION_PREFIX + existingIds + "," + this.myID;
            if (string == null) {
                GoSuppressInspectionFix.$$$reportNull$$$0(8);
            }
            return string;
        }

        @Nullable
        public PsiElement getContainer(PsiElement context) {
            String description;
            PsiElement container;
            if (this.myTopMost) {
                container = PsiTreeUtil.getTopmostParentOfType((PsiElement)context, this.myContainerClass);
                if (container == null && this.myContainerClass.isInstance(context)) {
                    container = context;
                }
            } else {
                container = PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{this.myContainerClass});
            }
            if (container != null && this.myUpdateElementDescription && StringUtil.isNotEmpty((String)(description = UsageViewUtil.getType((PsiElement)container)))) {
                this.setText(this.isSuppressAll() ? GoBundle.message((String)"go.fix.suppress.all.inspections.for.text", (Object[])new Object[]{description}) : GoBundle.message((String)"go.fix.suppress.inspection.for.text", (Object[])new Object[]{description}));
            }
            return container;
        }

        @Nullable
        protected List<? extends PsiElement> getCommentsFor(@NotNull PsiElement container) {
            PsiElement parent;
            List<PsiComment> comments;
            if (container == null) {
                GoSuppressInspectionFix.$$$reportNull$$$0(9);
            }
            if ((comments = this.getComments(container)) != null && !comments.isEmpty()) {
                return comments;
            }
            PsiElement caseElement = GoInspectionSuppressor.getCaseElement(container);
            if (caseElement != null) {
                return super.getCommentsFor(caseElement);
            }
            if (container instanceof GoImportDeclaration && (parent = container.getParent()) instanceof GoImportList && ContainerUtil.getFirstItem(((GoImportList)parent).getImportDeclarationList()) == container) {
                return super.getCommentsFor(parent);
            }
            return comments;
        }

        @Nullable
        private List<PsiComment> getComments(@NotNull PsiElement container) {
            List comments;
            if (container == null) {
                GoSuppressInspectionFix.$$$reportNull$$$0(10);
            }
            if ((comments = super.getCommentsFor(container)) == null) {
                return null;
            }
            return comments.stream().map(it -> (PsiComment)ObjectUtils.tryCast((Object)it, PsiComment.class)).filter(Objects::nonNull).collect(Collectors.toList());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementDescription";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ID";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 5: 
                case 6: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "container";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "existingIds";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/inspections/suppression/GoInspectionSuppressor$GoSuppressInspectionFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/inspections/suppression/GoInspectionSuppressor$GoSuppressInspectionFix";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSuppressCommentText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createSuppression";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceSuppressionComments";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getSuppressCommentText";
                    break;
                }
                case 8: {
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getCommentsFor";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getComments";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 8 -> new IllegalStateException(string);
            };
        }
    }

    private static final class GoSuppressForStatementFix
    extends GoSuppressInspectionFix {
        private GoSuppressForStatementFix() {
            super(GoBundle.message((String)"go.terms.statement", (Object[])new Object[0]), GoStatement.class, false, false);
        }

        private GoSuppressForStatementFix(@NotNull String ID2) {
            if (ID2 == null) {
                GoSuppressForStatementFix.$$$reportNull$$$0(0);
            }
            super(ID2, GoBundle.message((String)"go.terms.statement", (Object[])new Object[0]), GoStatement.class, false, false);
        }

        @Override
        @Nullable
        public PsiElement getContainer(PsiElement context) {
            GoStatement statement = (GoStatement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{GoStatement.class});
            if (statement != null && statement.getParent() instanceof GoCommCase) {
                return PsiTreeUtil.getParentOfType((PsiElement)statement, GoStatement.class);
            }
            return statement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ID", "com/goide/inspections/suppression/GoInspectionSuppressor$GoSuppressForStatementFix", "<init>"));
        }
    }
}

