/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections.tag;

import com.goide.i18n.GoBundle;
import com.goide.inspections.tag.GoTagEntry;
import com.goide.inspections.tag.GoTagFieldNameStyle;
import com.goide.inspections.tag.GoTagFile;
import com.goide.inspections.tag.GoTagUtil;
import com.goide.intentions.GoBaseIntentionAction;
import com.goide.psi.GoAnonymousFieldDefinition;
import com.goide.psi.GoFieldDeclaration;
import com.goide.psi.GoFieldDefinition;
import com.goide.psi.GoStringLiteral;
import com.goide.psi.GoStructType;
import com.goide.psi.GoTag;
import com.goide.psi.impl.GoElementFactory;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoTagChangeNameStyleIntention
extends GoBaseIntentionAction
implements Iconable,
PriorityAction {
    @NotNull
    @IntentionFamilyName
    public String getFamilyName() {
        String string = GoBundle.message((String)"go.intention.change.field.name.style.in.tags", (Object[])new Object[0]);
        if (string == null) {
            GoTagChangeNameStyleIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @IntentionName
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            GoTagChangeNameStyleIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public Icon getIcon(int flags) {
        return AllIcons.Nodes.Tag;
    }

    @NotNull
    public PriorityAction.Priority getPriority() {
        PriorityAction.Priority priority = PriorityAction.Priority.TOP;
        if (priority == null) {
            GoTagChangeNameStyleIntention.$$$reportNull$$$0(2);
        }
        return priority;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            GoTagChangeNameStyleIntention.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            GoTagChangeNameStyleIntention.$$$reportNull$$$0(4);
        }
        if (element == null) {
            GoTagChangeNameStyleIntention.$$$reportNull$$$0(5);
        }
        if (!GoTagUtil.RAW_STRING_IN_STRUCT_TAG.accepts((Object)element)) {
            return false;
        }
        GoTag tag = (GoTag)PsiTreeUtil.getParentOfType((PsiElement)element, GoTag.class);
        String fieldName = GoTagChangeNameStyleIntention.getFieldName(tag);
        if (fieldName == null) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        GoTagEntry tagEntry = GoTagUtil.getTagEntry(element, offset);
        if (tagEntry == null) {
            return false;
        }
        String tagEntryValue = tagEntry.getValue().getText();
        List<String> names = GoTagChangeNameStyleIntention.getStyledNames(fieldName);
        return ContainerUtil.exists(names, it -> GoTagChangeNameStyleIntention.createFieldNameMatcher(tagEntryValue, it).find());
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        GoStringLiteral literal;
        if (project == null) {
            GoTagChangeNameStyleIntention.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            GoTagChangeNameStyleIntention.$$$reportNull$$$0(7);
        }
        if (element == null) {
            GoTagChangeNameStyleIntention.$$$reportNull$$$0(8);
        }
        if ((literal = (GoStringLiteral)ObjectUtils.tryCast((Object)element.getParent(), GoStringLiteral.class)) == null) {
            return;
        }
        GoTagEntry currentTagEntry = GoTagUtil.getTagEntry(element, editor.getCaretModel().getOffset());
        if (currentTagEntry == null) {
            return;
        }
        List<GoTagFieldNameStyle> styles = GoTagFieldNameStyle.getStyles();
        List names = ContainerUtil.map(styles, it -> it.apply("fieldName"));
        JBPopupFactory.getInstance().createPopupChooserBuilder(names).setTitle(GoBundle.message((String)"go.intention.change.field.name.style.select.style", (Object[])new Object[0])).setMovable(false).setResizable(false).setRequestFocus(true).setItemChosenCallback(selectedStyle -> {
            int i = names.indexOf(selectedStyle);
            if (i < 0) {
                return;
            }
            String keyToUpdate = currentTagEntry.getKey().getText();
            GoTagFieldNameStyle style = (GoTagFieldNameStyle)styles.get(i);
            GoTagFieldNameStyle.setLastUsedStyle(style);
            GoStructType struct = (GoStructType)PsiTreeUtil.getParentOfType((PsiElement)element, GoStructType.class);
            WriteCommandAction.runWriteCommandAction((Project)project, (String)GoBundle.message((String)"go.intention.change.field.name.style.command", (Object[])new Object[0]), null, () -> {
                for (GoFieldDeclaration field : SyntaxTraverser.psiTraverser((PsiElement)struct).postOrderDfsTraversal().filter(GoFieldDeclaration.class)) {
                    GoStringLiteral tagLiteral;
                    GoTagFile file2;
                    GoTag tag = field.getTag();
                    String fieldName = GoTagChangeNameStyleIntention.getFieldName(tag);
                    if (fieldName == null || !GoTagChangeNameStyleIntention.changeFieldNameStyleInFile(file2 = GoTagUtil.parseTagLiteral(tagLiteral = tag.getStringLiteral()), keyToUpdate, fieldName, style)) continue;
                    GoStringLiteral updatedLiteral = GoElementFactory.createStringLiteral(project, "`" + file2.getText() + "`");
                    tagLiteral.replace(updatedLiteral);
                }
            }, (PsiFile[])new PsiFile[0]);
        }).createPopup().showInBestPositionFor(editor);
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (project == null) {
            GoTagChangeNameStyleIntention.$$$reportNull$$$0(9);
        }
        if (editor == null) {
            GoTagChangeNameStyleIntention.$$$reportNull$$$0(10);
        }
        if (psiFile == null) {
            GoTagChangeNameStyleIntention.$$$reportNull$$$0(11);
        }
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        if (intentionPreviewInfo == null) {
            GoTagChangeNameStyleIntention.$$$reportNull$$$0(12);
        }
        return intentionPreviewInfo;
    }

    @Contract(value="null,_,_,_->false")
    private static boolean changeFieldNameStyleInFile(@Nullable GoTagFile file2, @NotNull String keyToUpdate, @NotNull String fieldName, @NotNull Function<String, String> styleToApply) {
        if (keyToUpdate == null) {
            GoTagChangeNameStyleIntention.$$$reportNull$$$0(13);
        }
        if (fieldName == null) {
            GoTagChangeNameStyleIntention.$$$reportNull$$$0(14);
        }
        if (styleToApply == null) {
            GoTagChangeNameStyleIntention.$$$reportNull$$$0(15);
        }
        if (file2 == null) {
            return false;
        }
        boolean updated2 = false;
        for (GoTagEntry tagEntry : file2.getEntries()) {
            PsiElement updatedValue;
            String oldValue;
            String newValue;
            PsiElement key = tagEntry.getKey();
            PsiElement value2 = tagEntry.getValue();
            if (!keyToUpdate.equals(key.getText()) || (newValue = GoTagChangeNameStyleIntention.changeFieldNameStyle(styleToApply, fieldName, oldValue = value2.getText())).equals(oldValue) || (updatedValue = GoTagUtil.createValue(file2.getProject(), newValue)) == null) continue;
            value2.replace(updatedValue);
            updated2 = true;
        }
        return updated2;
    }

    @NotNull
    private static String changeFieldNameStyle(@NotNull Function<String, String> style, @NotNull String fieldName, @NotNull String value2) {
        if (style == null) {
            GoTagChangeNameStyleIntention.$$$reportNull$$$0(16);
        }
        if (fieldName == null) {
            GoTagChangeNameStyleIntention.$$$reportNull$$$0(17);
        }
        if (value2 == null) {
            GoTagChangeNameStyleIntention.$$$reportNull$$$0(18);
        }
        String updatedName = style.apply(fieldName);
        for (String styledName : GoTagChangeNameStyleIntention.getStyledNames(fieldName)) {
            Matcher matcher = GoTagChangeNameStyleIntention.createFieldNameMatcher(value2, styledName);
            int idx = 0;
            StringBuilder sb = new StringBuilder();
            while (matcher.find()) {
                sb.append(value2, idx, matcher.start());
                sb.append(matcher.group(1));
                sb.append(updatedName);
                sb.append(matcher.group(2));
                idx = matcher.end();
            }
            if (idx <= 0) continue;
            sb.append(value2.substring(idx));
            String string = sb.toString();
            if (string == null) {
                GoTagChangeNameStyleIntention.$$$reportNull$$$0(19);
            }
            return string;
        }
        String string = value2;
        if (string == null) {
            GoTagChangeNameStyleIntention.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    private static Matcher createFieldNameMatcher(@NotNull String text, @NotNull String fieldName) {
        if (text == null) {
            GoTagChangeNameStyleIntention.$$$reportNull$$$0(21);
        }
        if (fieldName == null) {
            GoTagChangeNameStyleIntention.$$$reportNull$$$0(22);
        }
        String pattern = "([ ,;.:'\\\\\"])" + Pattern.quote(fieldName) + "([ ,;.:'\\\\\"])";
        Matcher matcher = Pattern.compile(pattern).matcher(text);
        if (matcher == null) {
            GoTagChangeNameStyleIntention.$$$reportNull$$$0(23);
        }
        return matcher;
    }

    @NotNull
    private static List<String> getStyledNames(@NotNull String fieldName) {
        if (fieldName == null) {
            GoTagChangeNameStyleIntention.$$$reportNull$$$0(24);
        }
        List list = ContainerUtil.map(GoTagFieldNameStyle.getStyles(), it -> it.apply(fieldName));
        if (list == null) {
            GoTagChangeNameStyleIntention.$$$reportNull$$$0(25);
        }
        return list;
    }

    @Nullable
    private static String getFieldName(@Nullable GoTag tag) {
        if (tag == null) {
            return null;
        }
        GoFieldDeclaration field = (GoFieldDeclaration)PsiTreeUtil.getParentOfType((PsiElement)tag, GoFieldDeclaration.class);
        if (field == null) {
            return null;
        }
        GoAnonymousFieldDefinition anonymous = field.getAnonymousFieldDefinition();
        if (anonymous != null) {
            return anonymous.getName();
        }
        GoFieldDefinition item = (GoFieldDefinition)ContainerUtil.getOnlyItem(field.getFieldDefinitionList());
        return item != null ? item.getName() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 14, 15, 16, 17, 18, 21, 22, 24 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/inspections/tag/GoTagChangeNameStyleIntention";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyToUpdate";
                break;
            }
            case 14: 
            case 17: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styleToApply";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "style";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPriority";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/inspections/tag/GoTagChangeNameStyleIntention";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "changeFieldNameStyle";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createFieldNameMatcher";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyledNames";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "changeFieldNameStyleInFile";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "changeFieldNameStyle";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createFieldNameMatcher";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getStyledNames";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 14, 15, 16, 17, 18, 21, 22, 24 -> new IllegalArgumentException(string);
        };
    }
}

