/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections.tag;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.NameUtilCore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoTagFieldNameStyle
implements Function<String, String> {
    private static final String LAST_USED_STYLE_KEY = "GO_TAG_FIELD_NAME_STYLE";
    static final GoTagFieldNameStyle SNAKE_CASE = new GoTagFieldNameStyle("snake", GoTagFieldNameStyle::snakeCase);
    static final GoTagFieldNameStyle LISP_CASE = new GoTagFieldNameStyle("lisp", GoTagFieldNameStyle::lispCase);
    static final GoTagFieldNameStyle CAMEL_CASE = new GoTagFieldNameStyle("camel", GoTagFieldNameStyle::camelCase);
    @ApiStatus.Internal
    public static final GoTagFieldNameStyle PASCAL_CASE = new GoTagFieldNameStyle("pascal", GoTagFieldNameStyle::pascalCase);
    private static final List<GoTagFieldNameStyle> STYLES = List.of(SNAKE_CASE, LISP_CASE, CAMEL_CASE, PASCAL_CASE);
    private final String myName;
    private final Function<String, String> myStyleFunction;

    private GoTagFieldNameStyle(@NotNull String name, @NotNull Function<String, String> styleFunction) {
        if (name == null) {
            GoTagFieldNameStyle.$$$reportNull$$$0(0);
        }
        if (styleFunction == null) {
            GoTagFieldNameStyle.$$$reportNull$$$0(1);
        }
        this.myName = name;
        this.myStyleFunction = styleFunction;
    }

    @NotNull
    private String getName() {
        String string = this.myName;
        if (string == null) {
            GoTagFieldNameStyle.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public String apply(String fieldName) {
        return this.myStyleFunction.apply(fieldName);
    }

    public String toString() {
        return this.myName;
    }

    public boolean equals(Object o) {
        return o instanceof GoTagFieldNameStyle && Objects.equals(this.myName, ((GoTagFieldNameStyle)o).myName);
    }

    public int hashCode() {
        return Objects.hash(this.myName);
    }

    @NotNull
    private static String snakeCase(@NotNull String fieldName) {
        if (fieldName == null) {
            GoTagFieldNameStyle.$$$reportNull$$$0(3);
        }
        String string = Arrays.stream(NameUtilCore.nameToWords((String)fieldName)).map(StringUtil::toLowerCase).collect(Collectors.joining("_"));
        if (string == null) {
            GoTagFieldNameStyle.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    private static String lispCase(@NotNull String fieldName) {
        if (fieldName == null) {
            GoTagFieldNameStyle.$$$reportNull$$$0(5);
        }
        String string = Arrays.stream(NameUtilCore.nameToWords((String)fieldName)).map(StringUtil::toLowerCase).collect(Collectors.joining("-"));
        if (string == null) {
            GoTagFieldNameStyle.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    private static String pascalCase(@NotNull String fieldName) {
        if (fieldName == null) {
            GoTagFieldNameStyle.$$$reportNull$$$0(7);
        }
        String string = Arrays.stream(NameUtilCore.nameToWords((String)fieldName)).map(Strings::capitalize).collect(Collectors.joining());
        if (string == null) {
            GoTagFieldNameStyle.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    private static String camelCase(@NotNull String fieldName) {
        if (fieldName == null) {
            GoTagFieldNameStyle.$$$reportNull$$$0(9);
        }
        String string = StringUtil.decapitalize((String)GoTagFieldNameStyle.pascalCase(fieldName));
        if (string == null) {
            GoTagFieldNameStyle.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    static List<GoTagFieldNameStyle> getStyles() {
        GoTagFieldNameStyle lastUsed = GoTagFieldNameStyle.getLastUsedStyle();
        ArrayList<GoTagFieldNameStyle> result = new ArrayList<GoTagFieldNameStyle>(STYLES.size());
        result.add(lastUsed);
        for (GoTagFieldNameStyle style : STYLES) {
            if (style == lastUsed) continue;
            result.add(style);
        }
        ArrayList<GoTagFieldNameStyle> arrayList = result;
        if (arrayList == null) {
            GoTagFieldNameStyle.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @Nullable
    public static GoTagFieldNameStyle guessStyle(@Nullable String name) {
        if (StringUtil.isEmpty((String)name) || "-".equals(name)) {
            return null;
        }
        if (name.contains("_")) {
            return SNAKE_CASE;
        }
        if (name.contains("-")) {
            return LISP_CASE;
        }
        if (Character.isUpperCase(name.charAt(0))) {
            return PASCAL_CASE;
        }
        return CAMEL_CASE;
    }

    @NotNull
    static GoTagFieldNameStyle getLastUsedStyle() {
        String styleName = PropertiesComponent.getInstance().getValue(LAST_USED_STYLE_KEY);
        GoTagFieldNameStyle result = (GoTagFieldNameStyle)ContainerUtil.find(STYLES, it -> it.getName().equals(styleName));
        GoTagFieldNameStyle goTagFieldNameStyle = result != null ? result : STYLES.get(0);
        if (goTagFieldNameStyle == null) {
            GoTagFieldNameStyle.$$$reportNull$$$0(12);
        }
        return goTagFieldNameStyle;
    }

    public static void setLastUsedStyle(@Nullable GoTagFieldNameStyle style) {
        PropertiesComponent.getInstance().setValue(LAST_USED_STYLE_KEY, style != null ? style.getName() : null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 6, 8, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styleFunction";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/inspections/tag/GoTagFieldNameStyle";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/inspections/tag/GoTagFieldNameStyle";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "snakeCase";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "lispCase";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "pascalCase";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "camelCase";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyles";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastUsedStyle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "snakeCase";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lispCase";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "pascalCase";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "camelCase";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 6, 8, 10, 11, 12 -> new IllegalStateException(string);
        };
    }
}

