/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections.tag;

import com.goide.inspections.tag.GoTagEntry;
import com.goide.inspections.tag.GoTagFieldNameStyle;
import com.goide.inspections.tag.GoTagFile;
import com.goide.inspections.tag.GoTagUtil;
import com.goide.psi.GoStringLiteral;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.PlainPrefixMatcher;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoTagValueCompletionContributor
extends CompletionContributor {
    public static final char OPTIONS_DELIMITER = ',';
    static final Map<String, Options> OPTIONS = new HashMap<String, Options>();

    public GoTagValueCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)GoTagValueCompletionContributor.rawStringInStructTag(), new GoTagValueCompletionProvider());
    }

    @NotNull
    static PsiElementPattern.Capture<PsiElement> rawStringInStructTag() {
        PsiElementPattern.Capture<PsiElement> capture = GoTagUtil.RAW_STRING_IN_STRUCT_TAG;
        if (capture == null) {
            GoTagValueCompletionContributor.$$$reportNull$$$0(0);
        }
        return capture;
    }

    static {
        OPTIONS.put("json", new Options("omitempty"));
        OPTIONS.put("xml", new Options("attr", "cdata", "chardata", "innerxml", "comment", "any", "omitempty"));
        OPTIONS.put("asn1", new Options(false, "optional", "explicit", "generalized", "utc", "ia5", "printable", "numeric", "utf8", "default:", "tag:", "set", "application", "private", "omitempty"));
        OPTIONS.put("bson", new Options("omitempty", "minsize", "inline"));
        OPTIONS.put("yaml", new Options("omitempty", "inline", "flow"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/goide/inspections/tag/GoTagValueCompletionContributor", "rawStringInStructTag"));
    }

    private static class GoTagValueCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private GoTagValueCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            block11: {
                Options options;
                block10: {
                    GoStringLiteral tagStringLiteral;
                    if (parameters == null) {
                        GoTagValueCompletionProvider.$$$reportNull$$$0(0);
                    }
                    if (context == null) {
                        GoTagValueCompletionProvider.$$$reportNull$$$0(1);
                    }
                    if (result == null) {
                        GoTagValueCompletionProvider.$$$reportNull$$$0(2);
                    }
                    if ((tagStringLiteral = (GoStringLiteral)PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), GoStringLiteral.class, (boolean)false)) == null) {
                        return;
                    }
                    GoTagFile goTag = GoTagUtil.parseTagLiteral(tagStringLiteral);
                    if (goTag == null) {
                        return;
                    }
                    int offsetInTag = parameters.getOffset() - GoTagUtil.getTagStartOffset(tagStringLiteral);
                    GoTagEntry entry = (GoTagEntry)PsiTreeUtil.getParentOfType((PsiElement)goTag.findElementAt(offsetInTag), GoTagEntry.class, (boolean)false);
                    if (entry == null) {
                        return;
                    }
                    options = OPTIONS.get(entry.getKey().getText());
                    if (options == null) {
                        return;
                    }
                    PrefixInfo prefix = GoTagValueCompletionProvider.getPrefix(entry, offsetInTag);
                    if (prefix == null) {
                        return;
                    }
                    result = result.withPrefixMatcher((PrefixMatcher)new PlainPrefixMatcher(prefix.myPrefix, false));
                    if (!prefix.myIsInFirstPosition || !options.isStartsWithFieldName()) break block10;
                    String fieldName = GoTagUtil.getFieldNameForTag(tagStringLiteral);
                    if (!StringUtil.isNotEmpty((String)fieldName)) break block11;
                    for (GoTagFieldNameStyle style : GoTagFieldNameStyle.getStyles()) {
                        result.addElement((LookupElement)LookupElementBuilder.create((String)style.apply(fieldName)).withInsertHandler((ctx, item) -> GoTagFieldNameStyle.setLastUsedStyle(style)));
                    }
                    break block11;
                }
                for (String item2 : options.getLookupItems()) {
                    result.addElement((LookupElement)LookupElementBuilder.create((String)item2));
                }
            }
        }

        @Nullable
        private static PrefixInfo getPrefix(@NotNull GoTagEntry entry, int offsetInTag) {
            char c;
            int i;
            if (entry == null) {
                GoTagValueCompletionProvider.$$$reportNull$$$0(3);
            }
            PsiElement value2 = entry.getValue();
            TextRange valueRange = value2.getTextRange();
            int valueStart = valueRange.getStartOffset() + 1;
            int valueEnd = valueRange.getEndOffset() - 1;
            if (offsetInTag < valueStart || offsetInTag > valueEnd) {
                return null;
            }
            int offset = offsetInTag - valueStart;
            String text = value2.getText();
            text = text.substring(1, text.length() - 1);
            for (i = offset - 1; i >= 0 && ((c = text.charAt(i)) == ':' || Character.isAlphabetic(c) || Character.isDigit(c)); --i) {
            }
            if (i == -1) {
                return new PrefixInfo(text.substring(0, offset), true);
            }
            if (text.charAt(i) == ',') {
                return new PrefixInfo(text.substring(i + 1, offset), false);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entry";
                    break;
                }
            }
            objectArray2[1] = "com/goide/inspections/tag/GoTagValueCompletionContributor$GoTagValueCompletionProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addCompletions";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getPrefix";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class PrefixInfo {
            private final String myPrefix;
            private final boolean myIsInFirstPosition;

            private PrefixInfo(String prefix, boolean isInFirstPosition) {
                this.myPrefix = prefix;
                this.myIsInFirstPosition = isInFirstPosition;
            }
        }
    }

    static class Options {
        private final boolean myStartsWithFieldName;
        private final String[] myLookupItems;

        private Options(String ... lookupItems) {
            this(true, lookupItems);
        }

        private Options(boolean startsWithFieldName, String ... lookupItems) {
            this.myStartsWithFieldName = startsWithFieldName;
            this.myLookupItems = lookupItems;
        }

        boolean isStartsWithFieldName() {
            return this.myStartsWithFieldName;
        }

        private String[] getLookupItems() {
            return this.myLookupItems;
        }
    }
}

