/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections.time;

import com.goide.inspections.time.GoTimeToken;
import com.intellij.lexer.LexerBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoTimeLexer
extends LexerBase {
    private CharSequence myBuffer;
    private int myOffset;
    private int myEndOffset;
    private int myState;
    private int myTokenStart;
    private int myTokenEnd;
    private IElementType myToken;

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            GoTimeLexer.$$$reportNull$$$0(0);
        }
        this.myBuffer = buffer;
        this.myOffset = startOffset;
        this.myEndOffset = endOffset;
        this.myState = initialState;
        this.advance();
    }

    public void advance() {
        if (this.myOffset >= this.myEndOffset) {
            this.myToken = null;
            return;
        }
        if (this.tryConsumeStdToken(this.myOffset)) {
            return;
        }
        int textStart = this.myOffset;
        int textEnd = this.myEndOffset;
        for (int i = this.myOffset + 1; i < this.myEndOffset; ++i) {
            if (!this.tryConsumeStdToken(i)) continue;
            textEnd = i;
            break;
        }
        this.myTokenStart = textStart;
        this.myTokenEnd = textEnd;
        this.myOffset = textEnd;
        this.myToken = GoTimeToken.TEXT;
    }

    private boolean tryConsumeStdToken(int offset) {
        int c = this.charAt(offset);
        switch (c) {
            case 74: {
                if (this.tryConsume(offset, GoTimeToken.LONG_MONTH)) {
                    return true;
                }
                if (this.match(offset, "Jan") && (offset + "Jan".length() == this.myEndOffset || !Character.isLowerCase(this.myBuffer.charAt(offset + "Jan".length())))) {
                    this.consume(offset, GoTimeToken.MONTH);
                    return true;
                }
                return false;
            }
            case 77: {
                if (this.tryConsume(offset, GoTimeToken.LONG_WEEK_DAY)) {
                    return true;
                }
                if (this.match(offset, "Mon") && (offset + "Mon".length() == this.myEndOffset || !Character.isLowerCase(this.myBuffer.charAt(offset + "Mon".length())))) {
                    this.consume(offset, GoTimeToken.WEEK_DAY);
                    return true;
                }
                return this.tryConsume(offset, GoTimeToken.TZ);
            }
            case 48: {
                int c1 = this.charAt(offset + 1);
                switch (c1) {
                    case 48: {
                        if (this.charAt(offset + 2) == 50) {
                            this.consume(offset, GoTimeToken.ZERO_YEAR_DAY);
                            return true;
                        }
                        return false;
                    }
                    case 49: {
                        this.consume(offset, GoTimeToken.ZERO_MONTH);
                        return true;
                    }
                    case 50: {
                        this.consume(offset, GoTimeToken.ZERO_DAY);
                        return true;
                    }
                    case 51: {
                        this.consume(offset, GoTimeToken.ZERO_HOUR12);
                        return true;
                    }
                    case 52: {
                        this.consume(offset, GoTimeToken.ZERO_MINUTE);
                        return true;
                    }
                    case 53: {
                        this.consume(offset, GoTimeToken.ZERO_SECOND);
                        return true;
                    }
                    case 54: {
                        this.consume(offset, GoTimeToken.ZERO_YEAR);
                        return true;
                    }
                }
                return false;
            }
            case 49: {
                if (this.charAt(offset + 1) == 53) {
                    this.consume(offset, GoTimeToken.HOUR);
                    return true;
                }
                this.consume(offset, GoTimeToken.NUM_MONTH);
                return true;
            }
            case 50: {
                if (this.tryConsume(offset, GoTimeToken.LONG_YEAR)) {
                    return true;
                }
                this.consume(offset, GoTimeToken.DAY);
                return true;
            }
            case 95: {
                int c1 = this.charAt(offset + 1);
                if (c1 == 50) {
                    if (this.match(offset, "_2006")) {
                        return false;
                    }
                    this.consume(offset, GoTimeToken.UNDER_DAY);
                    return true;
                }
                if (c1 == 95 && this.charAt(offset + 2) == 50) {
                    this.consume(offset, GoTimeToken.UNDER_YEAR);
                    return true;
                }
                return false;
            }
            case 51: {
                this.consume(offset, GoTimeToken.HOUR12);
                return true;
            }
            case 52: {
                this.consume(offset, GoTimeToken.MINUTE);
                return true;
            }
            case 53: {
                this.consume(offset, GoTimeToken.SECOND);
                return true;
            }
            case 80: {
                return this.tryConsume(offset, GoTimeToken.PM_BIG);
            }
            case 112: {
                return this.tryConsume(offset, GoTimeToken.PM_SMALL);
            }
            case 45: {
                if (this.tryConsume(offset, GoTimeToken.NUM_SECONDS_TZ)) {
                    return true;
                }
                if (this.tryConsume(offset, GoTimeToken.NUM_COLON_SECONDS_TZ)) {
                    return true;
                }
                if (this.tryConsume(offset, GoTimeToken.NUM_TZ)) {
                    return true;
                }
                if (this.tryConsume(offset, GoTimeToken.NUM_COLON_TZ)) {
                    return true;
                }
                return this.tryConsume(offset, GoTimeToken.NUM_SHORT_TZ);
            }
            case 90: {
                if (this.tryConsume(offset, GoTimeToken.ISO_8601_SECONDS_TZ)) {
                    return true;
                }
                if (this.tryConsume(offset, GoTimeToken.ISO_8601_COLON_SECONDS_TZ)) {
                    return true;
                }
                if (this.tryConsume(offset, GoTimeToken.ISO_8601_TZ)) {
                    return true;
                }
                if (this.tryConsume(offset, GoTimeToken.ISO_8601_COLON_TZ)) {
                    return true;
                }
                return this.tryConsume(offset, GoTimeToken.ISO_8601_SHORT_TZ);
            }
            case 46: {
                int c1 = this.charAt(offset + 1);
                if (c1 == 48 || c1 == 57) {
                    int j = offset + 2;
                    while (this.charAt(j) == c1) {
                        ++j;
                    }
                    if (!Character.isDigit(this.charAt(j))) {
                        this.consume(offset, j, c1 == 48 ? GoTimeToken.FRAC_SECOND0 : GoTimeToken.FRAC_SECOND9);
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public int getState() {
        return this.myState;
    }

    @Nullable
    public IElementType getTokenType() {
        return this.myToken;
    }

    public int getTokenStart() {
        return this.myTokenStart;
    }

    public int getTokenEnd() {
        return this.myTokenEnd;
    }

    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.myBuffer;
        if (charSequence == null) {
            GoTimeLexer.$$$reportNull$$$0(1);
        }
        return charSequence;
    }

    public int getBufferEnd() {
        return this.myEndOffset;
    }

    private boolean tryConsume(int offset, @NotNull GoTimeToken token) {
        String text;
        if (token == null) {
            GoTimeLexer.$$$reportNull$$$0(2);
        }
        if (this.match(offset, text = Objects.requireNonNull(token.getExpectedText()))) {
            this.myTokenStart = offset;
            this.myTokenEnd = offset + text.length();
            this.myToken = token;
            this.myOffset = this.myTokenEnd;
            return true;
        }
        return false;
    }

    private void consume(int offset, @NotNull GoTimeToken token) {
        if (token == null) {
            GoTimeLexer.$$$reportNull$$$0(3);
        }
        String text = Objects.requireNonNull(token.getExpectedText());
        this.consume(offset, offset + text.length(), token);
    }

    private void consume(int offset, int endOffset, @NotNull IElementType token) {
        if (token == null) {
            GoTimeLexer.$$$reportNull$$$0(4);
        }
        this.myTokenStart = offset;
        this.myTokenEnd = endOffset;
        this.myToken = token;
        this.myOffset = this.myTokenEnd;
    }

    private boolean match(int offset, @NotNull String str) {
        int stringEndOffset;
        if (str == null) {
            GoTimeLexer.$$$reportNull$$$0(5);
        }
        if ((stringEndOffset = offset + str.length()) > this.myEndOffset) {
            return false;
        }
        return StringUtil.equals((CharSequence)str, (CharSequence)this.myBuffer.subSequence(offset, stringEndOffset));
    }

    private int charAt(int offset) {
        return offset < this.myEndOffset ? (int)this.myBuffer.charAt(offset) : -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/inspections/time/GoTimeLexer";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/inspections/time/GoTimeLexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBufferSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "tryConsume";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "consume";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "match";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

