/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections.unresolved;

import com.goide.execution.testing.GoTestFinder;
import com.goide.go.GoGotoSuperHandler;
import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoFunctionDeclaration;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoParamDefinition;
import com.goide.psi.GoParameterDeclaration;
import com.goide.psi.GoParameters;
import com.goide.psi.GoReferencesSearch;
import com.goide.psi.GoSignature;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.GoVisitor;
import com.goide.quickfix.GoDeleteAllUnusedParametersQuickFix;
import com.goide.quickfix.GoDeleteParameterNamesQuickFix;
import com.goide.quickfix.GoDeleteUnusedParameterQuickFix;
import com.goide.quickfix.GoRenameToBlankQuickFix;
import com.goide.refactor.util.GoRefactoringUtil;
import com.goide.stubs.index.GoTypeSpecInheritanceIndex;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Query;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import org.jetbrains.annotations.NotNull;

public final class GoUnusedParameterInspection
extends GoInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(final @NotNull GoProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            GoUnusedParameterInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            GoUnusedParameterInspection.$$$reportNull$$$0(1);
        }
        return new GoVisitor(this){

            @Override
            public void visitFunctionDeclaration(@NotNull GoFunctionDeclaration function) {
                if (function == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (GoTestFinder.isTestFile((PsiFile)function.getContainingFile()) && GoTestFinder.isTestFunction(function)) {
                    return;
                }
                this.analyze(function, () -> false);
            }

            @Override
            public void visitMethodDeclaration(@NotNull GoMethodDeclaration method) {
                if (method == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.analyze(method, () -> 1.participatesInInheritance(method));
            }

            private static boolean participatesInInheritance(@NotNull GoMethodDeclaration method) {
                GoTypeSpec spec;
                if (method == null) {
                    1.$$$reportNull$$$0(2);
                }
                return (spec = method.resolveTypeSpec()) != null && (GoTypeSpecInheritanceIndex.has(spec, method.getResolveScope(), method) || GoGotoSuperHandler.GoSuperMarkerProvider.hasSuperMethod(method));
            }

            private void analyze(@NotNull GoFunctionOrMethodDeclaration function, @NotNull BooleanSupplier participatesInInheritance) {
                GoSignature signature;
                if (function == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (participatesInInheritance == null) {
                    1.$$$reportNull$$$0(4);
                }
                if ((signature = function.getSignature()) == null) {
                    return;
                }
                List<PsiElement> potentiallyUnusedParameters = 1.findPotentiallyUnusedParameters(signature.getParameters());
                if (potentiallyUnusedParameters.isEmpty()) {
                    return;
                }
                if (GoUnusedParameterInspection.isUsedInSameFileFunctionType(function) || participatesInInheritance.getAsBoolean()) {
                    List<GoParamDefinition> definitions = signature.getParameters().getDefinitionList();
                    if (!definitions.isEmpty()) {
                        boolean canDeleteAllNames = definitions.size() == potentiallyUnusedParameters.size();
                        potentiallyUnusedParameters.forEach(parameter -> this.registerProblemWithRename((PsiElement)parameter, function, canDeleteAllNames));
                    }
                } else {
                    potentiallyUnusedParameters.forEach(parameter -> this.registerProblemWithDelete((PsiElement)parameter, potentiallyUnusedParameters));
                }
            }

            @NotNull
            private static List<PsiElement> findPotentiallyUnusedParameters(@NotNull GoParameters parameters) {
                if (parameters == null) {
                    1.$$$reportNull$$$0(5);
                }
                SmartList potentiallyUnusedParameters = new SmartList();
                for (GoParameterDeclaration parameterDeclaration : parameters.getParameterDeclarationList()) {
                    List<GoParamDefinition> list = parameterDeclaration.getParamDefinitionList();
                    if (list.isEmpty()) {
                        potentiallyUnusedParameters.add(parameterDeclaration);
                    }
                    for (GoParamDefinition parameter : list) {
                        Query<PsiReference> search;
                        ProgressManager.checkCanceled();
                        if (parameter.isBlank() || (search = GoReferencesSearch.search((PsiElement)parameter, parameter.getUseScope(), true)).findFirst() != null) continue;
                        potentiallyUnusedParameters.add(parameter);
                    }
                }
                SmartList smartList = potentiallyUnusedParameters;
                if (smartList == null) {
                    1.$$$reportNull$$$0(6);
                }
                return smartList;
            }

            private void registerProblemWithRename(@NotNull PsiElement parameter, @NotNull GoFunctionOrMethodDeclaration function, boolean canDeleteAllNames) {
                if (parameter == null) {
                    1.$$$reportNull$$$0(7);
                }
                if (function == null) {
                    1.$$$reportNull$$$0(8);
                }
                ArrayList<LocalQuickFixOnPsiElement> fixes = new ArrayList<LocalQuickFixOnPsiElement>();
                GoParamDefinition definition = (GoParamDefinition)ObjectUtils.tryCast((Object)parameter, GoParamDefinition.class);
                if (definition != null) {
                    fixes.add(new GoRenameToBlankQuickFix(definition));
                    if (canDeleteAllNames) {
                        fixes.add(new GoDeleteParameterNamesQuickFix(function));
                    }
                }
                this.registerProblem(parameter, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
            }

            private void registerProblemWithDelete(@NotNull PsiElement parameter, @NotNull List<PsiElement> potentiallyUnusedParameters) {
                if (parameter == null) {
                    1.$$$reportNull$$$0(9);
                }
                if (potentiallyUnusedParameters == null) {
                    1.$$$reportNull$$$0(10);
                }
                PsiElement element = parameter;
                GoParameterDeclaration declaration = (GoParameterDeclaration)ObjectUtils.tryCast((Object)parameter.getParent(), GoParameterDeclaration.class);
                if (declaration != null && declaration.getParamDefinitionList().size() == 1) {
                    element = declaration;
                }
                SmartList fixes = new SmartList();
                fixes.add(new GoDeleteUnusedParameterQuickFix(element));
                if (potentiallyUnusedParameters.size() > 1) {
                    fixes.add(new GoDeleteAllUnusedParametersQuickFix(element.getProject(), potentiallyUnusedParameters));
                }
                this.registerProblem(element, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
            }

            private void registerProblem(@NotNull PsiElement element, LocalQuickFix ... fixes) {
                if (element == null) {
                    1.$$$reportNull$$$0(11);
                }
                if (fixes == null) {
                    1.$$$reportNull$$$0(12);
                }
                holder.registerProblem(element, GoUnusedParameterInspection.message("go.inspection.unused.parameter.message", new Object[]{REF}), fixes);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 6 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "function";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "method";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "participatesInInheritance";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parameters";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/goide/inspections/unresolved/GoUnusedParameterInspection$1";
                        break;
                    }
                    case 7: 
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parameter";
                        break;
                    }
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "potentiallyUnusedParameters";
                        break;
                    }
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 12: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fixes";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/goide/inspections/unresolved/GoUnusedParameterInspection$1";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "findPotentiallyUnusedParameters";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitFunctionDeclaration";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "visitMethodDeclaration";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "participatesInInheritance";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "analyze";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "findPotentiallyUnusedParameters";
                        break;
                    }
                    case 6: {
                        break;
                    }
                    case 7: 
                    case 8: {
                        objectArray = objectArray;
                        objectArray[2] = "registerProblemWithRename";
                        break;
                    }
                    case 9: 
                    case 10: {
                        objectArray = objectArray;
                        objectArray[2] = "registerProblemWithDelete";
                        break;
                    }
                    case 11: 
                    case 12: {
                        objectArray = objectArray;
                        objectArray[2] = "registerProblem";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 6 -> new IllegalStateException(string);
                };
            }
        };
    }

    private static boolean isUsedInSameFileFunctionType(@NotNull GoFunctionOrMethodDeclaration function) {
        if (function == null) {
            GoUnusedParameterInspection.$$$reportNull$$$0(2);
        }
        return GoReferencesSearch.search(function, (SearchScope)new LocalSearchScope((PsiElement)function.getContainingFile())).anyMatch(psiReference -> !GoRefactoringUtil.isCall(psiReference.getElement()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        objectArray2[1] = "com/goide/inspections/unresolved/GoUnusedParameterInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isUsedInSameFileFunctionType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

